/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.Daemon;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.Vector;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageListener;
import javax.jms.TransactionRolledBackException;
import org.objectweb.joram.client.jms.BytesMessage;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.MapMessage;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.MessageAcks;
import org.objectweb.joram.client.jms.MessageConsumer;
import org.objectweb.joram.client.jms.MessageConsumerListener;
import org.objectweb.joram.client.jms.MessageInterceptor;
import org.objectweb.joram.client.jms.MessageProducer;
import org.objectweb.joram.client.jms.ObjectMessage;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.QueueBrowser;
import org.objectweb.joram.client.jms.SessionMBean;
import org.objectweb.joram.client.jms.SingleSessionConsumer;
import org.objectweb.joram.client.jms.StreamMessage;
import org.objectweb.joram.client.jms.TemporaryQueue;
import org.objectweb.joram.client.jms.TemporaryTopic;
import org.objectweb.joram.client.jms.TextMessage;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.TopicSubscriber;
import org.objectweb.joram.client.jms.XAConnection;
import org.objectweb.joram.client.jms.XAQueueConnection;
import org.objectweb.joram.client.jms.XATopicConnection;
import org.objectweb.joram.client.jms.connection.CompletionListener;
import org.objectweb.joram.client.jms.connection.RequestMultiplexer;
import org.objectweb.joram.client.jms.connection.Requestor;
import org.objectweb.joram.shared.DestinationConstants;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.CommitRequest;
import org.objectweb.joram.shared.client.ConsumerAckRequest;
import org.objectweb.joram.shared.client.ConsumerDenyRequest;
import org.objectweb.joram.shared.client.ConsumerMessages;
import org.objectweb.joram.shared.client.ConsumerReceiveRequest;
import org.objectweb.joram.shared.client.ConsumerUnsubRequest;
import org.objectweb.joram.shared.client.GetAdminTopicReply;
import org.objectweb.joram.shared.client.GetAdminTopicRequest;
import org.objectweb.joram.shared.client.ProducerMessages;
import org.objectweb.joram.shared.client.SessAckRequest;
import org.objectweb.joram.shared.client.SessCreateDestReply;
import org.objectweb.joram.shared.client.SessCreateDestRequest;
import org.objectweb.joram.shared.client.SessDenyRequest;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class Session
implements javax.jms.Session,
SessionMBean {
    public static Logger logger = Debug.getLogger((String)Session.class.getName());
    public static Logger trace = Debug.getLogger((String)(Session.class.getName() + ".Message"));
    public static Logger tracker = Debug.getLogger((String)(Session.class.getName() + ".tracker"));
    public static int INDIVIDUAL_ACKNOWLEDGE = 4;
    private SessionCloseTask closingTask;
    private boolean scheduled;
    protected MessageListener messageListener;
    private final String ident;
    private Connection cnx;
    boolean transacted;
    private int acknowledgeMode;
    private boolean autoAck;
    private Vector<MessageConsumer> consumers;
    private Vector<MessageProducer> producers;
    private Vector<QueueBrowser> browsers;
    private fr.dyade.aaa.common.Queue repliesIn;
    private SessionDaemon daemon;
    private int listenerCount;
    Hashtable<String, ProducerMessages> sendings;
    Hashtable<String, MessageAcks> deliveries;
    CompletionListener listener = null;
    private RequestMultiplexer mtpx;
    private Requestor requestor;
    private Requestor receiveRequestor;
    private boolean recover;
    private boolean toClose;
    private int status;
    private int sessionMode;
    private int requestStatus;
    private MessageConsumer pendingMessageConsumer;
    private Thread singleThreadOfControl;
    private Closer closer;
    private boolean implicitAck;
    private boolean asyncSend;
    private int queueMessageReadMax;
    private int topicAckBufferMax;
    private int topicPassivationThreshold;
    private int topicActivationThreshold;
    private int compressedMinSize;
    private int compressionLevel;
    private boolean asyncSub = false;
    private MessageConsumerListener messageConsumerListener;
    private List<MessageInterceptor> inInterceptors;
    private List<MessageInterceptor> outInterceptors;
    Map<String, MessageConsumerListener> messageConsumerListeners = new HashMap<String, MessageConsumerListener>();
    private String stringImage = null;

    boolean checkThread() {
        return this.daemon != null && this.daemon.isCurrentThread();
    }

    @Override
    public boolean isImplicitAck() {
        return this.implicitAck;
    }

    public void setImplicitAck(boolean implicitAck) {
        this.implicitAck = implicitAck;
    }

    @Override
    public boolean isAsyncSend() {
        return this.asyncSend;
    }

    public void setAsyncSend(boolean asyncSend) {
        this.asyncSend = asyncSend;
    }

    @Override
    public final int getQueueMessageReadMax() {
        return this.queueMessageReadMax;
    }

    public void setQueueMessageReadMax(int queueMessageReadMax) {
        this.queueMessageReadMax = queueMessageReadMax;
    }

    @Override
    public final int getTopicAckBufferMax() {
        return this.topicAckBufferMax;
    }

    public void setTopicAckBufferMax(int topicAckBufferMax) {
        this.topicAckBufferMax = topicAckBufferMax;
    }

    @Override
    public final int getTopicPassivationThreshold() {
        return this.topicPassivationThreshold;
    }

    public void setTopicPassivationThreshold(int topicPassivationThreshold) {
        this.topicPassivationThreshold = topicPassivationThreshold;
    }

    @Override
    public final int getTopicActivationThreshold() {
        return this.topicActivationThreshold;
    }

    public void setTopicActivationThreshold(int topicActivationThreshold) {
        this.topicActivationThreshold = topicActivationThreshold;
    }

    @Override
    public final int getCompressedMinSize() {
        return this.compressedMinSize;
    }

    public final void setCompressedMinSize(int compressedMinSize) {
        this.compressedMinSize = compressedMinSize;
    }

    @Override
    public final int getCompressionLevel() {
        return this.compressionLevel;
    }

    public final void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @Override
    public boolean isAsyncSub() {
        return this.asyncSub;
    }

    public void setAsyncSub(boolean asyncSub) {
        this.asyncSub = asyncSub;
    }

    synchronized MessageConsumerListener getMessageConsumerListener(String targetName) {
        return this.messageConsumerListeners.get(targetName);
    }

    synchronized void putMessageConsumerListener(String targetName, MessageConsumerListener mcl) {
        this.messageConsumerListeners.put(targetName, mcl);
    }

    synchronized MessageConsumerListener removeMessageConsumerListener(String targetName) {
        return this.messageConsumerListeners.remove(targetName);
    }

    public String getJMXBeanName() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.cnx.getJMXBeanName());
        buf.append(",location=Session");
        buf.append(",session=").append(this.getClass().getSimpleName()).append("_").append(this.ident);
        return buf.toString();
    }

    public String registerMBean() {
        String JMXBeanName;
        block2: {
            JMXBeanName = this.getJMXBeanName();
            try {
                MXWrapper.registerMBean((Object)this, (String)JMXBeanName);
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block2;
                logger.log(BasicLevel.DEBUG, "Session.registerMBean: " + JMXBeanName, (Throwable)e);
            }
        }
        return JMXBeanName;
    }

    public void unregisterMBean() {
        block2: {
            try {
                MXWrapper.unregisterMBean((String)this.getJMXBeanName());
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block2;
                logger.log(BasicLevel.DEBUG, "Session.unregisterMBean: " + this.getJMXBeanName(), (Throwable)e);
            }
        }
    }

    Session(Connection cnx, boolean transacted, int acknowledgeMode, RequestMultiplexer mtpx) throws JMSException {
        if (!(transacted || acknowledgeMode == 1 || acknowledgeMode == 2 || acknowledgeMode == 3 || acknowledgeMode == INDIVIDUAL_ACKNOWLEDGE || cnx instanceof XAQueueConnection || cnx instanceof XATopicConnection || cnx instanceof XAConnection)) {
            throw new JMSException("Can't create a non transacted session with an invalid acknowledge mode.");
        }
        this.ident = cnx.nextSessionId();
        this.stringImage = this.getClass().getSimpleName() + ':' + this.ident + '[' + cnx.getProxyId() + ']';
        this.cnx = cnx;
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.mtpx = mtpx;
        this.requestor = new Requestor(mtpx);
        this.receiveRequestor = new Requestor(mtpx);
        this.autoAck = !transacted && acknowledgeMode != 2 && acknowledgeMode != INDIVIDUAL_ACKNOWLEDGE;
        this.consumers = new Vector();
        this.producers = new Vector();
        this.browsers = new Vector();
        this.repliesIn = new fr.dyade.aaa.common.Queue();
        this.sendings = new Hashtable();
        this.deliveries = new Hashtable();
        this.closer = new Closer();
        if (transacted && cnx.getTxPendingTimer() > 0L) {
            this.closingTask = new SessionCloseTask(cnx.getTxPendingTimer() * 1000L);
        }
        this.implicitAck = cnx.getImplicitAck();
        this.asyncSend = cnx.getAsyncSend();
        this.queueMessageReadMax = cnx.getQueueMessageReadMax();
        this.topicAckBufferMax = cnx.getTopicAckBufferMax();
        this.topicActivationThreshold = cnx.getTopicActivationThreshold();
        this.topicPassivationThreshold = cnx.getTopicPassivationThreshold();
        this.compressedMinSize = cnx.getCompressedMinSize();
        this.compressionLevel = cnx.getCompressionLevel();
        if (tracker.isLoggable(BasicLevel.DEBUG)) {
            tracker.log(BasicLevel.DEBUG, this.stringImage + " initialized.", (Throwable)new Exception());
        } else if (tracker.isLoggable(BasicLevel.INFO)) {
            tracker.log(BasicLevel.INFO, this.stringImage + " initialized.");
        }
        this.setStatus(0);
        this.setSessionMode(0);
        this.setRequestStatus(0);
        this.inInterceptors = cnx.getInInterceptors();
        this.outInterceptors = cnx.getOutInterceptors();
        this.registerMBean();
    }

    private void setStatus(int status) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.setStatus(" + Status.toString(status) + ')');
        }
        this.status = status;
    }

    @Override
    public boolean isStarted() {
        return this.status == 1;
    }

    @Override
    public String getStatus() {
        return Status.toString(this.status);
    }

    private void setSessionMode(int sessionMode) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.setSessionMode(" + SessionMode.toString(sessionMode) + ')');
        }
        this.sessionMode = sessionMode;
    }

    @Override
    public String getSessionMode() {
        return SessionMode.toString(this.sessionMode);
    }

    private void setRequestStatus(int requestStatus) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.setRequestStatus(" + RequestStatus.toString(requestStatus) + ')');
        }
        this.requestStatus = requestStatus;
    }

    @Override
    public String getRequestStatus() {
        return RequestStatus.toString(this.requestStatus);
    }

    protected synchronized void checkClosed() throws IllegalStateException {
        if (this.status == 2) {
            throw new IllegalStateException("Forbidden call on a closed session.");
        }
    }

    private synchronized void checkThreadOfControl() throws IllegalStateException {
        if (this.singleThreadOfControl != null && Thread.currentThread() != this.singleThreadOfControl) {
            throw new IllegalStateException("Illegal control thread");
        }
    }

    private void checkSessionMode(int expectedSessionMode) throws IllegalStateException {
        if (this.sessionMode == 0) {
            this.setSessionMode(this.sessionMode);
        } else if (this.sessionMode != expectedSessionMode) {
            throw new IllegalStateException("Bad session mode");
        }
    }

    private void checkClientID() throws JMSException {
        if (this.cnx.getClientID() == null) {
            throw new IllegalStateException("The client identifier is unset.");
        }
    }

    public final String toString() {
        return this.stringImage;
    }

    @Override
    public final int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        if (this.transacted) {
            return 0;
        }
        return this.acknowledgeMode;
    }

    @Override
    public final synchronized boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.transacted;
    }

    public void setTransacted(boolean t) {
        if (this.status != 2) {
            this.transacted = t;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "Session.setTransacted transacted = " + this.transacted + ", autoAck = " + this.autoAck);
            }
        } else if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.WARN, "Session.setTransacted: session " + this.ident + " closed.");
        }
    }

    public synchronized void setMessageListener(MessageListener listener) throws JMSException {
        this.checkSessionMode(3);
        this.messageListener = listener;
    }

    public synchronized MessageListener getMessageListener() throws JMSException {
        return this.messageListener;
    }

    public synchronized javax.jms.Message createMessage() throws JMSException {
        this.checkClosed();
        Message m = new Message();
        m.setCompressedMinSize(this.compressedMinSize);
        m.setCompressionLevel(this.compressionLevel);
        return m;
    }

    public synchronized javax.jms.TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        TextMessage m = new TextMessage();
        m.setCompressedMinSize(this.compressedMinSize);
        m.setCompressionLevel(this.compressionLevel);
        return m;
    }

    public synchronized javax.jms.TextMessage createTextMessage(String text) throws JMSException {
        this.checkClosed();
        TextMessage message = new TextMessage();
        message.setCompressedMinSize(this.compressedMinSize);
        message.setCompressionLevel(this.compressionLevel);
        message.setText(text);
        return message;
    }

    public synchronized javax.jms.BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        BytesMessage m = new BytesMessage();
        m.setCompressedMinSize(this.compressedMinSize);
        m.setCompressionLevel(this.compressionLevel);
        return m;
    }

    public synchronized javax.jms.MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        MapMessage m = new MapMessage();
        m.setCompressedMinSize(this.compressedMinSize);
        m.setCompressionLevel(this.compressionLevel);
        return m;
    }

    public synchronized javax.jms.ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        ObjectMessage m = new ObjectMessage();
        m.setCompressedMinSize(this.compressedMinSize);
        m.setCompressionLevel(this.compressionLevel);
        return m;
    }

    public synchronized javax.jms.ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkClosed();
        ObjectMessage message = new ObjectMessage();
        message.setCompressedMinSize(this.compressedMinSize);
        message.setCompressionLevel(this.compressionLevel);
        message.setObject(object);
        return message;
    }

    public synchronized javax.jms.StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        StreamMessage m = new StreamMessage();
        m.setCompressedMinSize(this.compressedMinSize);
        m.setCompressionLevel(this.compressionLevel);
        return m;
    }

    public synchronized javax.jms.QueueBrowser createBrowser(javax.jms.Queue queue, String selector) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        QueueBrowser qb = new QueueBrowser(this, (Queue)queue, selector);
        this.browsers.addElement(qb);
        return qb;
    }

    public synchronized javax.jms.QueueBrowser createBrowser(javax.jms.Queue queue) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        QueueBrowser qb = new QueueBrowser(this, (Queue)queue, null);
        this.browsers.addElement(qb);
        return qb;
    }

    public synchronized javax.jms.MessageProducer createProducer(javax.jms.Destination dest) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        MessageProducer mp = new MessageProducer(this, (Destination)dest);
        this.addProducer(mp);
        return mp;
    }

    public synchronized javax.jms.MessageConsumer createConsumer(javax.jms.Destination dest, String selector, boolean noLocal) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        MessageConsumer mc = new MessageConsumer(this, (Destination)dest, selector, null, noLocal, false, false);
        this.addConsumer(mc);
        return mc;
    }

    public synchronized javax.jms.MessageConsumer createConsumer(javax.jms.Destination dest, String selector) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        MessageConsumer mc = new MessageConsumer(this, (Destination)dest, selector);
        this.addConsumer(mc);
        return mc;
    }

    public synchronized javax.jms.MessageConsumer createConsumer(javax.jms.Destination dest) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        MessageConsumer mc = new MessageConsumer(this, (Destination)dest, null);
        this.addConsumer(mc);
        return mc;
    }

    public synchronized javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.createDurableSubscriber(" + topic + ',' + name + ',' + selector + ',' + noLocal + ')');
        }
        this.checkClosed();
        this.checkThreadOfControl();
        this.checkClientID();
        TopicSubscriber ts = new TopicSubscriber(this, (Topic)topic, name, selector, noLocal, true);
        this.addConsumer(ts);
        return ts;
    }

    public synchronized javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic topic, String name) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.createDurableSubscriber(" + topic + ',' + name + ')');
        }
        this.checkClosed();
        this.checkThreadOfControl();
        this.checkClientID();
        TopicSubscriber ts = new TopicSubscriber(this, (Topic)topic, name, null, false, true);
        this.addConsumer(ts);
        return ts;
    }

    public synchronized javax.jms.Queue createQueue(String name) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        try {
            Destination.checkId(name);
        }
        catch (InvalidDestinationException exc) {
            String id = this.createDestination(DestinationConstants.getQueueType(), name);
            Queue queue = new Queue(id);
            queue.adminName = name;
            return queue;
        }
        return new Queue(name);
    }

    public synchronized javax.jms.Topic createTopic(String name) throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        if (name.equals("#AdminTopic")) {
            try {
                GetAdminTopicReply reply = (GetAdminTopicReply)this.requestor.request((AbstractJmsRequest)new GetAdminTopicRequest());
                if (reply.getId() != null) {
                    return new Topic(reply.getId());
                }
                throw new JMSException("AdminTopic could not be retrieved.");
            }
            catch (JMSException exc) {
                throw exc;
            }
            catch (Exception exc) {
                throw new JMSException("AdminTopic could not be retrieved: " + exc);
            }
        }
        try {
            Destination.checkId(name);
        }
        catch (InvalidDestinationException exc) {
            String id = this.createDestination(DestinationConstants.getTopicType(), name);
            Topic topic = new Topic(id);
            topic.adminName = name;
            return topic;
        }
        return new Topic(name);
    }

    private String createDestination(byte type, String name) throws JMSException {
        SessCreateDestReply reply = (SessCreateDestReply)this.requestor.request((AbstractJmsRequest)new SessCreateDestRequest(type, name));
        return reply.getAgentId();
    }

    public synchronized javax.jms.TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        SessCreateDestReply reply = (SessCreateDestReply)this.requestor.request((AbstractJmsRequest)new SessCreateDestRequest(DestinationConstants.getTemporaryQueueType()));
        String tempDest = reply.getAgentId();
        return new TemporaryQueue(tempDest, this.cnx);
    }

    public synchronized javax.jms.TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkClosed();
        this.checkThreadOfControl();
        SessCreateDestReply reply = (SessCreateDestReply)this.requestor.request((AbstractJmsRequest)new SessCreateDestRequest(DestinationConstants.getTemporaryTopicType()));
        String tempDest = reply.getAgentId();
        return new TemporaryTopic(tempDest, this.cnx);
    }

    public synchronized void run() {
        block4: {
            int load = this.repliesIn.size();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "-- " + this + ": loaded with " + load + " message(s) and started.");
            }
            try {
                for (int i = 0; i < load; ++i) {
                    org.objectweb.joram.shared.messages.Message momMsg = (org.objectweb.joram.shared.messages.Message)this.repliesIn.pop();
                    this.onMessage(momMsg, this.messageConsumerListener);
                }
            }
            catch (Exception exc) {
                if (!logger.isLoggable(BasicLevel.ERROR)) break block4;
                logger.log(BasicLevel.ERROR, "", (Throwable)exc);
            }
        }
    }

    void setMessageConsumerListener(MessageConsumerListener mcl) {
        this.messageConsumerListener = mcl;
    }

    public void commit() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.commit()");
        }
        if (!this.transacted) {
            throw new IllegalStateException("Can't commit a non transacted session.");
        }
        if (this.cnx.checkCLSession(this)) {
            throw new IllegalStateException("Cannot commit session from CompletionListener");
        }
        this.doCommit();
    }

    public synchronized void doCommit() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "--- " + this + ": committing...");
        }
        this.checkClosed();
        this.checkThreadOfControl();
        if (this.scheduled) {
            this.closingTask.cancel();
            this.scheduled = false;
        }
        try {
            CommitRequest commitReq = new CommitRequest();
            Enumeration<ProducerMessages> producerMessages = this.sendings.elements();
            while (producerMessages.hasMoreElements()) {
                ProducerMessages pM = producerMessages.nextElement();
                commitReq.addProducerMessages(pM);
            }
            this.sendings.clear();
            Enumeration<String> targets = this.deliveries.keys();
            while (targets.hasMoreElements()) {
                String target = targets.nextElement();
                MessageAcks acks = this.deliveries.get(target);
                commitReq.addAckRequest(new SessAckRequest(target, acks.getIds(), acks.getQueueMode()));
            }
            this.deliveries.clear();
            if (this.asyncSend && this.listener == null) {
                commitReq.setAsyncSend(true);
                this.mtpx.sendRequest((AbstractJmsRequest)commitReq);
            } else {
                this.requestor.request((AbstractJmsRequest)commitReq, this.listener);
            }
            this.listener = null;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, this + ": committed.");
            }
        }
        catch (JMSException jE) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.ERROR, "A JMSException was thrown during the commit", (Throwable)jE);
            } else {
                logger.log(BasicLevel.ERROR, "A JMSException was thrown during the commit: " + jE.getMessage());
            }
            TransactionRolledBackException tE = new TransactionRolledBackException("A JMSException was thrown during the commit.");
            tE.setLinkedException((Exception)((Object)jE));
            this.rollback();
            throw tE;
        }
    }

    public void rollback() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.rollback()");
        }
        if (!this.transacted) {
            throw new IllegalStateException("Can't rollback a non transacted session.");
        }
        if (this.cnx.checkCLSession(this)) {
            throw new IllegalStateException("Cannot rollback session from CompletionListener");
        }
        this.doRollback();
    }

    public synchronized void doRollback() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "--- " + this + ": rolling back...");
        }
        this.checkClosed();
        this.checkThreadOfControl();
        if (this.scheduled) {
            this.closingTask.cancel();
            this.scheduled = false;
        }
        this.deny();
        this.sendings.clear();
        this.listener = null;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, this + ": rolled back.");
        }
    }

    public synchronized void recover() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.recover()");
        }
        this.checkClosed();
        this.checkThreadOfControl();
        if (this.transacted) {
            throw new IllegalStateException("Can't recover a transacted session.");
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "--- " + this + " recovering...");
        }
        if (this.daemon != null && this.daemon.isCurrentThread()) {
            this.recover = true;
        } else {
            this.doRecover();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, this + ": recovered.");
        }
    }

    private void doRecover() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.doRecover()");
        }
        this.deny();
    }

    @Override
    public synchronized void unsubscribe(String name) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.unsubscribe(" + name + ')');
        }
        if (name == null) {
            throw new JMSException("Bad subscription name: null");
        }
        this.checkClosed();
        this.checkThreadOfControl();
        if (this.consumers != null) {
            for (int i = 0; i < this.consumers.size(); ++i) {
                MessageConsumer cons = this.consumers.get(i);
                if (cons.isQueueMode() || !cons.getTargetName().equals(name) || !cons.isOpen()) continue;
                throw new JMSException("Can't delete durable subscription " + name + " as long as an active subscriber exists.");
            }
        }
        this.syncRequest((AbstractJmsRequest)new ConsumerUnsubRequest(name));
    }

    @Override
    public void close() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.close()");
        }
        if (this.cnx.checkCLSession(this)) {
            throw new IllegalStateException("Cannot close session from CompletionListener");
        }
        if (this.daemon != null && this.daemon.isCurrentThread()) {
            this.toClose = true;
        } else {
            this.closer.close();
        }
        this.unregisterMBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClose() throws JMSException {
        Session session = this;
        synchronized (session) {
            if (this.status == 2) {
                return;
            }
        }
        Vector consumersToClose = (Vector)this.consumers.clone();
        this.consumers.clear();
        for (int i = 0; i < consumersToClose.size(); ++i) {
            MessageConsumer mc = (MessageConsumer)consumersToClose.elementAt(i);
            try {
                mc.close();
                continue;
            }
            catch (JMSException exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
            }
        }
        Vector browsersToClose = (Vector)this.browsers.clone();
        this.browsers.clear();
        for (int i = 0; i < browsersToClose.size(); ++i) {
            QueueBrowser qb = (QueueBrowser)browsersToClose.elementAt(i);
            try {
                qb.close();
                continue;
            }
            catch (JMSException exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
            }
        }
        Vector producersToClose = (Vector)this.producers.clone();
        this.producers.clear();
        for (int i = 0; i < producersToClose.size(); ++i) {
            MessageProducer mp = (MessageProducer)producersToClose.elementAt(i);
            try {
                mp.close();
                continue;
            }
            catch (JMSException exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
            }
        }
        this.stop();
        this.receiveRequestor.close();
        if (this.transacted) {
            this.rollback();
        } else {
            this.deny();
        }
        this.cnx.closeSession(this);
        Session session2 = this;
        synchronized (session2) {
            this.setStatus(2);
        }
        if (tracker.isLoggable(BasicLevel.DEBUG)) {
            tracker.log(BasicLevel.DEBUG, this.stringImage + " closed.", (Throwable)new Exception());
        } else if (tracker.isLoggable(BasicLevel.INFO)) {
            tracker.log(BasicLevel.INFO, this.stringImage + " closed.");
        }
    }

    synchronized void start() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.start()");
        }
        if (this.status == 2) {
            return;
        }
        if (this.status == 1) {
            return;
        }
        this.receiveRequestor.start();
        if (this.listenerCount > 0) {
            this.doStart();
        }
        this.setStatus(1);
    }

    private void doStart() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.doStart()");
        }
        this.repliesIn.start();
        this.daemon = new SessionDaemon();
        this.daemon.setDaemon(false);
        this.daemon.start();
        this.singleThreadOfControl = this.daemon.getThread();
    }

    synchronized void stop() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.stop()");
        }
        if (this.status == 0 || this.status == 2) {
            return;
        }
        this.doStop();
        this.setStatus(0);
    }

    private void doStop() {
        this.receiveRequestor.stop();
        if (this.daemon != null) {
            this.daemon.stop();
            this.daemon = null;
            this.singleThreadOfControl = null;
        }
    }

    private void prepareSend(Destination dest, org.objectweb.joram.shared.messages.Message msg) throws JMSException {
        ProducerMessages pM;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.prepareSend(" + dest + ',' + msg + ')');
        }
        this.checkClosed();
        this.checkThreadOfControl();
        if (this.scheduled) {
            this.closingTask.cancel();
        }
        if ((pM = this.sendings.get(dest.getName())) == null) {
            pM = new ProducerMessages(dest.getName());
            this.sendings.put(dest.getName(), pM);
        }
        pM.addMessage(msg);
        if (this.scheduled) {
            this.closingTask.start();
        }
    }

    private void prepareAck(String name, String id, boolean queueMode) {
        MessageAcks acks;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.prepareAck(" + name + ',' + id + ',' + queueMode + ')');
        }
        if (this.scheduled) {
            this.closingTask.cancel();
        }
        if ((acks = this.deliveries.get(name)) == null) {
            acks = new MessageAcks(queueMode);
            this.deliveries.put(name, acks);
        }
        acks.addId(id);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, " -> acks = " + acks);
        }
        if (this.closingTask != null) {
            this.scheduled = true;
            this.closingTask.start();
        }
    }

    synchronized void acknowledge() throws JMSException {
        this.checkClosed();
        if (this.transacted || this.acknowledgeMode != 2) {
            return;
        }
        this.doAcknowledge();
    }

    private void doAcknowledge() throws JMSException {
        Enumeration<String> targets = this.deliveries.keys();
        while (targets.hasMoreElements()) {
            String target = targets.nextElement();
            MessageAcks acks = this.deliveries.remove(target);
            this.mtpx.sendRequest((AbstractJmsRequest)new SessAckRequest(target, acks.getIds(), acks.getQueueMode()));
        }
    }

    synchronized void acknowledge(Destination dest, String msgId) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.acknowledge(" + dest + ", " + msgId + ')');
        }
        this.checkClosed();
        if (this.acknowledgeMode == INDIVIDUAL_ACKNOWLEDGE) {
            Enumeration<String> targets = this.deliveries.keys();
            while (targets.hasMoreElements()) {
                String target = targets.nextElement();
                if (!target.equals(dest.getAdminName()) && !target.equals(dest.getName())) continue;
                MessageAcks acks = this.deliveries.get(target);
                acks.remove(msgId);
                Vector<String> ackToSend = new Vector<String>();
                ackToSend.add(msgId);
                this.mtpx.sendRequest((AbstractJmsRequest)new SessAckRequest(dest.getName(), ackToSend, dest.isQueue()));
                return;
            }
        }
    }

    private void deny() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.deny()");
        }
        Enumeration<String> targets = this.deliveries.keys();
        while (targets.hasMoreElements()) {
            String target = targets.nextElement();
            MessageAcks acks = this.deliveries.remove(target);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, " -> acks = " + acks + ')');
            }
            SessDenyRequest deny = new SessDenyRequest(target, acks.getIds(), acks.getQueueMode());
            deny.setRedelivered(true);
            if (acks.getQueueMode()) {
                this.requestor.request((AbstractJmsRequest)deny);
                continue;
            }
            this.mtpx.sendRequest((AbstractJmsRequest)deny);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    javax.jms.Message receive(long requestTimeToLive, long waitTimeOut, MessageConsumer mc, String targetName, String selector, boolean queueMode) throws JMSException {
        Message msg;
        block22: {
            Iterator<MessageInterceptor> it;
            block23: {
                block20: {
                    block21: {
                        ConsumerMessages reply;
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, "Session.receive(" + requestTimeToLive + ',' + waitTimeOut + ',' + targetName + ',' + selector + ',' + queueMode + ')');
                        }
                        this.preReceive(mc);
                        try {
                            reply = null;
                            ConsumerReceiveRequest request = new ConsumerReceiveRequest(targetName, selector, requestTimeToLive, queueMode);
                            if (this.implicitAck) {
                                request.setReceiveAck(true);
                            }
                            reply = (ConsumerMessages)this.receiveRequestor.request((AbstractJmsRequest)request, waitTimeOut, null);
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, " -> reply = " + reply);
                            }
                            Session session = this;
                            // MONITORENTER : session
                            if (this.status == 2) {
                                if (reply != null) {
                                    this.mtpx.deny(reply);
                                }
                                javax.jms.Message message = null;
                                // MONITOREXIT : session
                                this.postReceive();
                                return message;
                            }
                            if (reply == null) break block20;
                        }
                        catch (Throwable throwable) {
                            this.postReceive();
                            throw throwable;
                        }
                        Vector msgs = reply.getMessages();
                        if (msgs == null || msgs.isEmpty()) break block21;
                        msg = Message.wrapMomMessage(this, (org.objectweb.joram.shared.messages.Message)msgs.get(0));
                        String msgId = msg.getJMSMessageID();
                        if (this.autoAck && !this.implicitAck) {
                            ConsumerAckRequest req = new ConsumerAckRequest(targetName, queueMode);
                            req.addId(msgId);
                            this.mtpx.sendRequest((AbstractJmsRequest)req);
                        } else {
                            this.prepareAck(targetName, msgId, queueMode);
                        }
                        msg.session = this;
                        if (trace.isLoggable(BasicLevel.INFO)) {
                            trace.log(BasicLevel.INFO, this + " handling message=" + msg + ", from=" + mc.getDest().getAdminName() + '/' + mc.getTargetName());
                        }
                        if (this.inInterceptors == null || this.inInterceptors.isEmpty()) break block22;
                        it = this.inInterceptors.iterator();
                        break block23;
                    }
                    javax.jms.Message message = null;
                    // MONITOREXIT : session
                    this.postReceive();
                    return message;
                }
                javax.jms.Message message = null;
                // MONITOREXIT : session
                this.postReceive();
                return message;
            }
            while (it.hasNext()) {
                MessageInterceptor interceptor = it.next();
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, "Intercepting the message after receiving by " + interceptor.getClass().getName());
                }
                try {
                    interceptor.handle(msg, this);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(BasicLevel.WARN)) continue;
                    logger.log(BasicLevel.WARN, "Error during interception (continue anyway...)", t);
                }
            }
        }
        Message message = msg;
        // MONITOREXIT : session
        this.postReceive();
        return message;
    }

    private synchronized void preReceive(MessageConsumer mc) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.preReceive(" + mc + ')');
        }
        mc.checkClosed();
        this.checkClosed();
        this.checkThreadOfControl();
        switch (this.sessionMode) {
            case 0: {
                this.setSessionMode(1);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal session mode");
            }
        }
        if (this.requestStatus != 0) {
            throw new IllegalStateException("Illegal request status");
        }
        this.singleThreadOfControl = Thread.currentThread();
        this.pendingMessageConsumer = mc;
        this.setRequestStatus(1);
    }

    private synchronized void postReceive() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.postReceive(" + this.pendingMessageConsumer + ')');
        }
        this.singleThreadOfControl = null;
        this.pendingMessageConsumer = null;
        this.setRequestStatus(0);
        this.setSessionMode(0);
        this.notifyAll();
    }

    protected synchronized void addConsumer(MessageConsumer mc) {
        this.consumers.addElement(mc);
    }

    synchronized void closeConsumer(MessageConsumer mc) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.closeConsumer(" + mc + ')');
        }
        this.consumers.removeElement(mc);
        if (this.pendingMessageConsumer == mc && this.requestStatus == 1) {
            this.receiveRequestor.close();
            try {
                while (this.requestStatus != 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.receiveRequestor = new Requestor(this.mtpx);
        }
    }

    synchronized void checkConsumers(String agentId) throws JMSException {
        for (int j = 0; j < this.consumers.size(); ++j) {
            MessageConsumer cons = this.consumers.elementAt(j);
            if (!agentId.equals(cons.getDest().agentId)) continue;
            throw new JMSException("Consumers still exist for this temp queue.");
        }
    }

    private void checkCLMessageProducer(MessageProducer mp) throws IllegalStateException {
        if (this.cnx.checkCLMessageProducer(this, mp)) {
            throw new IllegalStateException("Illegal call.");
        }
    }

    protected void addProducer(MessageProducer mp) {
        this.producers.addElement(mp);
    }

    synchronized void closeProducer(MessageProducer mp) throws IllegalStateException {
        this.checkCLMessageProducer(mp);
        this.producers.removeElement(mp);
    }

    synchronized void closeBrowser(QueueBrowser qb) {
        this.browsers.removeElement(qb);
    }

    synchronized MessageConsumerListener addMessageListener(MessageConsumerListener mcl, boolean check) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.addMessageListener(" + mcl + ')');
        }
        if (check) {
            this.checkClosed();
            this.checkThreadOfControl();
        }
        this.checkSessionMode(2);
        mcl.start();
        if (this.status == 1 && this.listenerCount == 0) {
            this.doStart();
        }
        ++this.listenerCount;
        return mcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessageListener(MessageConsumerListener mcl, boolean check) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.removeMessageListener(" + mcl + ',' + check + ')');
        }
        if (check) {
            this.checkClosed();
            this.checkThreadOfControl();
        }
        mcl.close();
        Session session = this;
        synchronized (session) {
            --this.listenerCount;
            if (this.status == 1 && this.listenerCount == 0) {
                try {
                    this.repliesIn.stop();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.doStop();
            }
        }
    }

    void pushMessages(SingleSessionConsumer consumerListener, ConsumerMessages messages) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.pushMessages(" + consumerListener + ',' + messages + ')');
        }
        this.repliesIn.push((Object)new MessageListenerContext(consumerListener, messages));
    }

    void onMessage(org.objectweb.joram.shared.messages.Message msg) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.onMessage(" + msg + ')');
        }
        this.repliesIn.push((Object)msg);
    }

    private void denyMessage(String targetName, String msgId, boolean queueMode, boolean redelivered) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.denyMessage(" + targetName + ',' + msgId + ',' + queueMode + ',' + redelivered + ')');
        }
        ConsumerDenyRequest cdr = new ConsumerDenyRequest(targetName, msgId, queueMode);
        cdr.setRedelivered(redelivered);
        if (queueMode) {
            this.requestor.request((AbstractJmsRequest)cdr);
        } else {
            this.mtpx.sendRequest((AbstractJmsRequest)cdr);
        }
    }

    private void onMessages(MessageListenerContext ctx) throws JMSException {
        Vector msgs = ctx.messages.getMessages();
        for (int i = 0; i < msgs.size(); ++i) {
            this.onMessage((org.objectweb.joram.shared.messages.Message)msgs.elementAt(i), ctx.consumerListener);
        }
    }

    void onMessage(org.objectweb.joram.shared.messages.Message momMsg, MessageConsumerListener mcl) throws JMSException {
        String msgId = momMsg.id;
        if (!this.autoAck) {
            this.prepareAck(mcl.getTargetName(), msgId, mcl.getQueueMode());
        }
        Message msg = null;
        try {
            msg = Message.wrapMomMessage(this, momMsg);
        }
        catch (JMSException jE) {
            if (this.autoAck) {
                this.denyMessage(mcl.getTargetName(), msgId, mcl.getQueueMode(), true);
            }
            return;
        }
        msg.session = this;
        if (trace.isLoggable(BasicLevel.INFO)) {
            trace.log(BasicLevel.INFO, this + " handling message=" + msg + ", from=" + mcl.getDestName() + '/' + mcl.getTargetName());
        }
        if (this.inInterceptors != null && !this.inInterceptors.isEmpty()) {
            for (MessageInterceptor interceptor : this.inInterceptors) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, "Intercepting the message after receiving by " + interceptor.getClass().getName());
                }
                try {
                    interceptor.handle(msg, this);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(BasicLevel.WARN)) continue;
                    logger.log(BasicLevel.WARN, "Error during interception (continue anyway...)", t);
                }
            }
        }
        try {
            if (this.messageListener == null) {
                mcl.onMessage(msg, this.acknowledgeMode);
            } else {
                mcl.onMessage(msg, this.messageListener, this.acknowledgeMode);
            }
        }
        catch (JMSException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
            }
            if (mcl.isClosed()) {
                this.denyMessage(mcl.getTargetName(), msgId, mcl.getQueueMode(), false);
            } else if (this.autoAck) {
                this.denyMessage(mcl.getTargetName(), msgId, mcl.getQueueMode(), true);
            }
            return;
        }
        if (this.recover) {
            this.recover = false;
            if (this.autoAck) {
                this.denyMessage(mcl.getTargetName(), msgId, mcl.getQueueMode(), true);
            } else {
                this.doRecover();
            }
        } else if (this.autoAck) {
            mcl.ack(msgId, this.acknowledgeMode);
        }
        if (this.toClose) {
            this.doClose();
            this.toClose = false;
        }
    }

    synchronized void send(Destination dest, javax.jms.Message msg, int deliveryMode, int priority, long timeToLive, boolean timestampDisabled, long deliveryDelay, javax.jms.CompletionListener completionListener, MessageProducer messageProducer) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.send(" + dest + ',' + msg + ',' + deliveryMode + ',' + priority + ',' + timeToLive + ',' + timestampDisabled + ',' + completionListener + ',' + messageProducer + ')');
        }
        this.checkClosed();
        this.checkThreadOfControl();
        if (msg == null) {
            throw new MessageFormatException("Cannot send null message");
        }
        msg.setJMSMessageID(this.cnx.nextMessageId());
        msg.setJMSDeliveryMode(deliveryMode);
        msg.setJMSDestination((javax.jms.Destination)dest);
        if (timeToLive == 0L) {
            msg.setJMSExpiration(0L);
        } else {
            msg.setJMSExpiration(System.currentTimeMillis() + timeToLive);
        }
        msg.setJMSPriority(priority);
        if (!timestampDisabled) {
            msg.setJMSTimestamp(System.currentTimeMillis());
        }
        msg.setJMSRedelivered(false);
        if (deliveryDelay > 0L) {
            long deliveryTime = System.currentTimeMillis() + deliveryDelay;
            msg.setJMSDeliveryTime(deliveryTime);
        } else {
            msg.setJMSDeliveryTime(0L);
        }
        if (completionListener != null) {
            if (this.listener == null) {
                this.listener = new CompletionListener(this, messageProducer);
            }
            this.listener.addCompletionListener(completionListener, msg);
        }
        Message joramMsg = null;
        try {
            joramMsg = (Message)msg;
        }
        catch (ClassCastException exc) {
            try {
                joramMsg = Message.convertJMSMessage(msg);
            }
            catch (JMSException jE) {
                MessageFormatException mE = new MessageFormatException("Message to send is invalid.");
                mE.setLinkedException((Exception)((Object)jE));
                throw mE;
            }
        }
        if (trace.isLoggable(BasicLevel.INFO)) {
            trace.log(BasicLevel.INFO, this + " sending message=" + joramMsg + ", to=" + dest.getAdminName());
        }
        if (this.outInterceptors != null && !this.outInterceptors.isEmpty()) {
            for (MessageInterceptor interceptor : this.outInterceptors) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, "Intercepting the message before sending by " + interceptor.getClass().getName());
                }
                try {
                    interceptor.handle(joramMsg, this);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(BasicLevel.WARN)) continue;
                    logger.log(BasicLevel.WARN, "Warning while interception (continue anyway...)", t);
                }
            }
        }
        joramMsg.prepare();
        joramMsg.momMsg.clientID = this.cnx.getClientID();
        if (this.transacted) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "Buffering the message.");
            }
            this.prepareSend(dest, (org.objectweb.joram.shared.messages.Message)joramMsg.momMsg.clone());
        } else {
            ProducerMessages pM = new ProducerMessages(dest.getName(), (org.objectweb.joram.shared.messages.Message)joramMsg.momMsg.clone());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "Sending " + joramMsg);
            }
            if ((this.asyncSend || !joramMsg.momMsg.persistent) && this.listener == null) {
                pM.setAsyncSend(true);
                this.mtpx.sendRequest((AbstractJmsRequest)pM);
            } else {
                this.requestor.request((AbstractJmsRequest)pM, this.listener);
            }
            this.listener = null;
        }
    }

    synchronized AbstractJmsReply syncRequest(AbstractJmsRequest request) throws JMSException {
        return this.requestor.request(request);
    }

    final Connection getConnection() {
        return this.cnx;
    }

    final String getId() {
        return this.ident;
    }

    final RequestMultiplexer getRequestMultiplexer() {
        return this.mtpx;
    }

    @Override
    public final boolean isAutoAck() {
        return this.autoAck;
    }

    private MessageConsumer getMessageConsumer(String sharedSubscriptionName) {
        for (MessageConsumer messageConsumer : this.consumers) {
            if (!sharedSubscriptionName.equals(messageConsumer.targetName)) continue;
            return messageConsumer;
        }
        return null;
    }

    private void checkShared(Topic topic, String sharedSubscriptionName, String selector) throws JMSException {
        if (sharedSubscriptionName == null) {
            throw new JMSException("the sharedSubscriptionName must be set.");
        }
        MessageConsumer mc = this.getMessageConsumer(sharedSubscriptionName);
        if (mc != null && mc.isOpen()) {
            if (!mc.getDest().getName().equals(topic.getName())) {
                if (logger.isLoggable(BasicLevel.ERROR)) {
                    logger.log(BasicLevel.ERROR, "The shared \"" + sharedSubscriptionName + "\" durable/non-durable subscription already exists and active with a different topic name (" + mc.getDest() + ").");
                }
                throw new JMSException("The shared \"" + sharedSubscriptionName + "\" durable/non-durable subscription already exists and active with a different topic name (" + mc.getDest() + ").");
            }
            if (mc.getMessageSelector() != null && selector == null || selector != null && !selector.equals(mc.getMessageSelector())) {
                if (logger.isLoggable(BasicLevel.ERROR)) {
                    logger.log(BasicLevel.ERROR, "The shared \"" + sharedSubscriptionName + "\" durable/non-durable subscription already exists and active with a different selector (" + mc.getMessageSelector() + ").");
                }
                throw new JMSException("The shared \"" + sharedSubscriptionName + "\" durable/non-durable subscription already exists and active with a different selector (" + mc.getMessageSelector() + ").");
            }
        }
    }

    public javax.jms.MessageConsumer createSharedConsumer(javax.jms.Topic topic, String sharedSubscriptionName) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.createSharedConsumer(" + topic + ',' + sharedSubscriptionName + ')');
        }
        return this.createSharedConsumer(topic, sharedSubscriptionName, null);
    }

    public javax.jms.MessageConsumer createSharedConsumer(javax.jms.Topic topic, String sharedSubscriptionName, String selector) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.createSharedConsumer(" + topic + ',' + sharedSubscriptionName + ',' + selector + ')');
        }
        this.checkClosed();
        this.checkThreadOfControl();
        if (topic == null) {
            throw new InvalidDestinationException("Invalid null destination.");
        }
        ((Topic)topic).check();
        this.checkShared((Topic)topic, sharedSubscriptionName, selector);
        MessageConsumer mc = new MessageConsumer(this, (Topic)topic, selector, sharedSubscriptionName, false, true, false);
        this.addConsumer(mc);
        return mc;
    }

    public javax.jms.MessageConsumer createDurableConsumer(javax.jms.Topic topic, String name) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.createDurableConsumer(" + topic + ',' + name + ')');
        }
        this.checkClosed();
        this.checkThreadOfControl();
        if (topic == null) {
            throw new InvalidDestinationException("Invalid null topic.");
        }
        this.checkClientID();
        MessageConsumer mc = new MessageConsumer(this, (Topic)topic, null, name, false, false, true);
        this.addConsumer(mc);
        return mc;
    }

    public javax.jms.MessageConsumer createDurableConsumer(javax.jms.Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.createDurableConsumer(" + topic + ',' + name + ',' + selector + ',' + noLocal + ')');
        }
        this.checkClosed();
        this.checkThreadOfControl();
        if (topic == null) {
            throw new InvalidDestinationException("Invalid null topic.");
        }
        this.checkClientID();
        MessageConsumer mc = new MessageConsumer(this, (Topic)topic, selector, name, noLocal, false, true);
        this.addConsumer(mc);
        return mc;
    }

    public javax.jms.MessageConsumer createSharedDurableConsumer(javax.jms.Topic topic, String name) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.createSharedDurableConsumer(" + topic + ',' + name + ')');
        }
        return this.createSharedDurableConsumer(topic, name, null);
    }

    public javax.jms.MessageConsumer createSharedDurableConsumer(javax.jms.Topic topic, String name, String selector) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Session.createSharedDurableConsumer(" + topic + ',' + name + ',' + selector + ')');
        }
        this.checkClosed();
        this.checkThreadOfControl();
        if (topic == null) {
            throw new InvalidDestinationException("Invalid null destination.");
        }
        ((Topic)topic).check();
        this.checkShared((Topic)topic, name, selector);
        MessageConsumer mc = new MessageConsumer(this, (Topic)topic, selector, name, false, true, true);
        this.addConsumer(mc);
        return mc;
    }

    private static class MessageListenerContext {
        SingleSessionConsumer consumerListener;
        ConsumerMessages messages;

        MessageListenerContext(SingleSessionConsumer consumerListener, ConsumerMessages messages) {
            this.consumerListener = consumerListener;
            this.messages = messages;
        }
    }

    private class SessionDaemon
    extends Daemon {
        SessionDaemon() {
            super("Connection#" + Session.this.cnx + " - Session#" + Session.this.ident, logger);
        }

        public void run() {
            while (this.running) {
                MessageListenerContext ctx;
                this.canStop = true;
                try {
                    ctx = (MessageListenerContext)Session.this.repliesIn.get();
                    Session.this.repliesIn.pop();
                }
                catch (InterruptedException exc) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
                    }
                    return;
                }
                this.canStop = false;
                try {
                    Session.this.onMessages(ctx);
                }
                catch (JMSException exc) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
                }
            }
        }

        Thread getThread() {
            return this.thread;
        }

        protected void shutdown() {
        }

        protected void close() {
        }
    }

    private class SessionCloseTask
    extends TimerTask {
        private long txPendingTimer;

        SessionCloseTask(long txPendingTimer) {
            this.txPendingTimer = txPendingTimer;
        }

        @Override
        public void run() {
            try {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, "Session closed because of pending transaction");
                }
                Session.this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void start() {
            try {
                Session.this.mtpx.schedule(this, this.txPendingTimer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class Closer {
        Closer() {
        }

        synchronized void close() throws JMSException {
            Session.this.doClose();
        }
    }

    private static class RequestStatus {
        public static final int NONE = 0;
        public static final int RUN = 1;
        public static final int DONE = 2;
        private static final String[] names = new String[]{"NONE", "RUN", "DONE"};

        private RequestStatus() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }

    private static class SessionMode {
        public static final int NONE = 0;
        public static final int RECEIVE = 1;
        public static final int LISTENER = 2;
        public static final int APP_SERVER = 3;
        private static final String[] names = new String[]{"NONE", "RECEIVE", "LISTENER", "APP_SERVER"};

        private SessionMode() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }

    private static class Status {
        public static final int STOP = 0;
        public static final int START = 1;
        public static final int CLOSE = 2;
        private static final String[] names = new String[]{"STOP", "START", "CLOSE"};

        private Status() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }
}

