/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.common.Debug;
import java.net.ConnectException;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminMessage;
import org.objectweb.joram.client.jms.admin.NameAlreadyUsedException;
import org.objectweb.joram.client.jms.admin.ServerIdAlreadyUsedException;
import org.objectweb.joram.client.jms.admin.StartFailureException;
import org.objectweb.joram.client.jms.admin.UnknownServerException;
import org.objectweb.joram.shared.admin.AbstractAdminMessage;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class AdminRequestor {
    private javax.jms.Session session;
    private Topic topic;
    private TemporaryTopic tmpTopic;
    private MessageProducer producer;
    private MessageConsumer consumer;
    public static final String REQUEST_TIMEOUT_PROP = "org.objectweb.joram.client.jms.admin.requestTimeout";
    public static final long DEFAULT_REQUEST_TIMEOUT = 60000L;
    private long requestTimeout = Long.getLong("org.objectweb.joram.client.jms.admin.requestTimeout", this.requestTimeout);
    public static Logger logger = Debug.getLogger((String)AdminRequestor.class.getName());

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public AdminRequestor(Connection cnx) throws JMSException {
        try {
            this.session = cnx.createSession(false, 1);
            this.topic = this.session.createTopic("#AdminTopic");
            this.producer = this.session.createProducer((Destination)this.topic);
            this.tmpTopic = this.session.createTemporaryTopic();
            this.consumer = this.session.createConsumer((Destination)this.tmpTopic);
        }
        catch (JMSException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.ERROR, "AdminRequestor.<init> Cannot open session.", (Throwable)exc);
            } else {
                logger.log(BasicLevel.ERROR, "AdminRequestor.<init> Cannot open session: " + exc.getMessage());
            }
            if (this.session != null) {
                this.session.close();
            }
            throw exc;
        }
    }

    public synchronized AdminReply request(AdminRequest request) throws AdminException, ConnectException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "AdminRequestor.request(" + request + ')');
        }
        AdminMessage requestMsg = new AdminMessage();
        if (this.session instanceof Session) {
            requestMsg.setCompressedMinSize(((Session)this.session).getCompressedMinSize());
        }
        Message replyMsg = null;
        AdminReply reply = null;
        try {
            requestMsg.setAdminMessage((AbstractAdminMessage)request);
            requestMsg.setJMSReplyTo((Destination)this.tmpTopic);
            this.producer.send((Message)requestMsg, 1, 4, this.requestTimeout);
            String correlationId = requestMsg.getJMSMessageID();
            while (true) {
                if ((replyMsg = this.consumer.receive(this.requestTimeout)) == null) {
                    throw new JMSException("Interrupted request");
                }
                if (!correlationId.equals(replyMsg.getJMSCorrelationID())) {
                    if (!logger.isLoggable(BasicLevel.INFO)) continue;
                    logger.log(BasicLevel.INFO, "AdminRequestor.request() bad correlation identifier.");
                    continue;
                }
                break;
            }
        }
        catch (JMSException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "AdminRequestor.request() connection failed.", (Throwable)exc);
            }
            throw new ConnectException("Connection failed: " + exc.getMessage());
        }
        try {
            reply = (AdminReply)((AdminMessage)replyMsg).getAdminMessage();
        }
        catch (ClassCastException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "AdminRequestor.request() invalid server reply.", (Throwable)exc);
            }
            throw new AdminException("Invalid server reply: " + exc.getMessage());
        }
        catch (MessageFormatException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "AdminRequestor.request() invalid server reply.", (Throwable)exc);
            }
            throw new AdminException("Invalid server reply: " + exc.getMessage());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "AdminRequestor.request(" + request + ") -> " + reply);
        }
        if (reply != null) {
            this.throwException(reply);
        }
        return reply;
    }

    private final void throwException(AdminReply reply) throws AdminException {
        if (!reply.succeeded()) {
            switch (reply.getErrorCode()) {
                case 0: {
                    throw new NameAlreadyUsedException(reply.getInfo());
                }
                case 1: {
                    throw new StartFailureException(reply.getInfo());
                }
                case 2: {
                    throw new ServerIdAlreadyUsedException(reply.getInfo());
                }
                case 3: {
                    throw new UnknownServerException(reply.getInfo());
                }
            }
            throw new AdminException(reply.getInfo());
        }
    }

    public void abort() throws ConnectException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "AdminRequestor.abort()");
        }
        try {
            this.consumer.close();
            this.consumer = this.session.createConsumer((Destination)this.tmpTopic);
        }
        catch (JMSException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "AdminRequestor.abort() connection failed.", (Throwable)exc);
            }
            throw new ConnectException("Connection failed: " + exc.getMessage());
        }
    }

    public void close() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "AdminRequestor.close()");
        }
        try {
            this.consumer.close();
        }
        catch (JMSException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.ERROR, "AdminRequestor.close()", (Throwable)exc);
            }
            logger.log(BasicLevel.ERROR, "AdminRequestor.close(): " + exc.getMessage());
        }
        try {
            this.producer.close();
        }
        catch (JMSException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.ERROR, "AdminRequestor.close()", (Throwable)exc);
            }
            logger.log(BasicLevel.ERROR, "AdminRequestor.close(): " + exc.getMessage());
        }
        try {
            this.tmpTopic.delete();
        }
        catch (JMSException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.ERROR, "AdminRequestor.close()", (Throwable)exc);
            }
            logger.log(BasicLevel.ERROR, "AdminRequestor.close(): " + exc.getMessage());
        }
        try {
            this.session.close();
        }
        catch (JMSException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.ERROR, "AdminRequestor.close()", (Throwable)exc);
            }
            logger.log(BasicLevel.ERROR, "AdminRequestor.close(): " + exc.getMessage());
        }
    }
}

