/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.common.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.JMSContext;
import org.objectweb.joram.client.jms.admin.AdministeredObject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ClusterConnectionFactory
extends AdministeredObject
implements javax.jms.ConnectionFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Debug.getLogger((String)ClusterConnectionFactory.class.getName());
    protected Hashtable<String, ConnectionFactory> cluster = null;

    public void addConnectionFactory(ConnectionFactory cf) {
        String location = System.getProperty("location");
        this.addConnectionFactory(location, cf);
    }

    public void addConnectionFactory(String location, ConnectionFactory cf) {
        if (this.cluster == null) {
            this.cluster = new Hashtable();
        }
        if (location == null) {
            location = cf.getParameters().getHost();
        }
        this.cluster.put(location, cf);
    }

    protected ConnectionFactory getConnectionFactory() {
        if (this.cluster != null && !this.cluster.isEmpty()) {
            ConnectionFactory cf = null;
            String location = System.getProperty("location");
            if (location == null || location.equals("")) {
                int idx = rand.nextInt(this.cluster.size());
                Object[] key = this.cluster.keySet().toArray();
                location = (String)key[idx];
                System.setProperty("location", location);
            }
            if ((cf = this.cluster.get(location)) == null) {
                Enumeration<ConnectionFactory> e = this.cluster.elements();
                cf = e.nextElement();
            }
            return cf;
        }
        return null;
    }

    public final Connection createConnection() throws JMSException {
        ConnectionFactory cf = this.getConnectionFactory();
        return cf.createConnection();
    }

    public final Connection createConnection(String name, String password) throws JMSException {
        ConnectionFactory cf = this.getConnectionFactory();
        return cf.createConnection(name, password);
    }

    public String toString() {
        return "ClusterConnectionFactory:" + this.cluster;
    }

    public Hashtable<String, ConnectionFactory> getCluster() {
        return this.cluster;
    }

    @Override
    public void toReference(Reference ref) throws NamingException {
        if (this.cluster == null) {
            return;
        }
        Map.Entry[] entries = new Map.Entry[this.cluster.size()];
        this.cluster.entrySet().toArray(entries);
        StringBuffer strbuf = new StringBuffer(15);
        for (int i = 0; i < entries.length; ++i) {
            strbuf.setLength(0);
            strbuf.append("CF#").append(i).append(".key");
            ref.add(new StringRefAddr(strbuf.toString(), (String)entries[i].getKey()));
            ConnectionFactory cf = (ConnectionFactory)entries[i].getValue();
            strbuf.setLength(0);
            strbuf.append("CF#").append(i).append(".class");
            ref.add(new StringRefAddr(strbuf.toString(), cf.getClass().getName()));
            strbuf.setLength(0);
            strbuf.append("CF#").append(i);
            cf.toReference(ref, strbuf.toString());
        }
    }

    @Override
    public void fromReference(Reference ref) throws NamingException {
        int i = 0;
        StringBuffer strbuf = new StringBuffer(15);
        while (true) {
            block4: {
                strbuf.setLength(0);
                strbuf.append("CF#").append(i).append(".key");
                RefAddr refAddr = ref.get(strbuf.toString());
                if (refAddr == null) break;
                String key = (String)refAddr.getContent();
                strbuf.setLength(0);
                strbuf.append("CF#").append(i).append(".class");
                String classname = (String)ref.get(strbuf.toString()).getContent();
                try {
                    Class<?> clazz = Class.forName(classname);
                    ConnectionFactory cf = (ConnectionFactory)clazz.newInstance();
                    strbuf.setLength(0);
                    strbuf.append("CF#").append(i);
                    cf.fromReference(ref, strbuf.toString());
                    if (this.cluster == null) {
                        this.cluster = new Hashtable();
                    }
                    this.cluster.put(key, cf);
                }
                catch (Exception exc) {
                    if (!logger.isLoggable(BasicLevel.ERROR)) break block4;
                    logger.log(BasicLevel.ERROR, "", (Throwable)exc);
                }
            }
            ++i;
        }
    }

    public javax.jms.JMSContext createContext() {
        try {
            return new JMSContext(this.createConnection());
        }
        catch (JMSSecurityException e) {
            logger.log(BasicLevel.ERROR, "Unable to create JMSContext", (Throwable)e);
            throw new JMSSecurityRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
        catch (JMSException e) {
            logger.log(BasicLevel.ERROR, "Unable to create JMSContext", (Throwable)e);
            throw new JMSRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
    }

    public javax.jms.JMSContext createContext(String userName, String password) {
        try {
            return new JMSContext(this.createConnection(userName, password));
        }
        catch (JMSSecurityException e) {
            logger.log(BasicLevel.ERROR, "Unable to create JMSContext", (Throwable)e);
            throw new JMSSecurityRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
        catch (JMSException e) {
            logger.log(BasicLevel.ERROR, "Unable to create JMSContext", (Throwable)e);
            throw new JMSRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
    }

    public javax.jms.JMSContext createContext(String userName, String password, int sessionMode) {
        try {
            return new JMSContext(this.createConnection(userName, password), sessionMode);
        }
        catch (JMSSecurityException e) {
            logger.log(BasicLevel.ERROR, "Unable to create JMSContext", (Throwable)e);
            throw new JMSSecurityRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
        catch (JMSException e) {
            logger.log(BasicLevel.ERROR, "Unable to create JMSContext", (Throwable)e);
            throw new JMSRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
    }

    public javax.jms.JMSContext createContext(int sessionMode) {
        try {
            return new JMSContext(this.createConnection(), sessionMode);
        }
        catch (JMSSecurityException e) {
            logger.log(BasicLevel.ERROR, "Unable to create JMSContext", (Throwable)e);
            throw new JMSSecurityRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
        catch (JMSException e) {
            logger.log(BasicLevel.ERROR, "Unable to create JMSContext", (Throwable)e);
            throw new JMSRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
    }
}

