/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.net.ConnectException;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.JoramAdmin;
import org.objectweb.joram.client.jms.admin.JoramAdminConnectMBean;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JoramAdminConnect
implements JoramAdminConnectMBean {
    public static Logger logger = Debug.getLogger((String)JoramAdminConnect.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            JoramAdminConnect admin = new JoramAdminConnect();
            admin.registerMBean();
            JoramAdminConnect joramAdminConnect = admin;
            synchronized (joramAdminConnect) {
                admin.wait();
            }
            admin.unregisterMBean();
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.WARN, "JoramAdminConnect", (Throwable)exc);
            } else {
                logger.log(BasicLevel.WARN, "JoramAdminConnect: " + exc.getMessage());
            }
            System.err.println(exc.getMessage());
        }
    }

    public void registerMBean() {
        block2: {
            try {
                MXWrapper.registerMBean((Object)this, (String)"JoramAdmin", (String)"type=AdminConnect");
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block2;
                logger.log(BasicLevel.DEBUG, "JoramAdmin.registerMBean", (Throwable)e);
            }
        }
    }

    public void unregisterMBean() {
        block2: {
            try {
                MXWrapper.unregisterMBean((String)"JoramAdmin", (String)"type=AdminConnect");
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block2;
                logger.log(BasicLevel.DEBUG, "JoramAdmin.unregisterMBean", (Throwable)e);
            }
        }
    }

    @Override
    public void connect(String name) throws ConnectException, AdminException {
        this.connect(name, "localhost", 16010, "root", "root");
    }

    @Override
    public void connect(String name, String host, int port, String user, String pass) throws ConnectException, AdminException {
        block6: {
            TcpConnectionFactory cf = TcpConnectionFactory.create(host, port);
            Connection cnx = null;
            try {
                cnx = cf.createConnection(user, pass);
                cnx.start();
                new JoramAdmin(cnx, name);
            }
            catch (JMSException exc) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.WARN, "JoramAdminConnect cannot connect", (Throwable)exc);
                } else {
                    logger.log(BasicLevel.WARN, "JoramAdminConnect cannot connect: " + exc.getMessage());
                }
                if (cnx == null) break block6;
                try {
                    cnx.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public synchronized void exit(boolean force) {
        if (force) {
            System.exit(0);
        } else {
            this.notify();
        }
    }
}

