/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import java.net.ConnectException;
import java.util.Properties;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;

public class RestAcquisitionQueue {
    public static final String RESTAcquisition = "com.scalagent.joram.mom.dest.rest.RestAcquisitionAsync";
    private String host = "localhost";
    private int port = 8989;
    private boolean useOldAPI = false;
    private String username = "anonymous";
    private String password = "anonymous";
    private boolean mediaTypeJson = true;
    private long timeout = 10000L;
    private int acquisitionPeriod = -1;
    private long idleTimeout = 60L;
    private long checkPeriod = 1800L;

    public String getHost() {
        return this.host;
    }

    public RestAcquisitionQueue setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public RestAcquisitionQueue setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean isUseOldAPI() {
        return this.useOldAPI;
    }

    public RestAcquisitionQueue setUseOldAPI(boolean useOldAPI) {
        this.useOldAPI = useOldAPI;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public RestAcquisitionQueue setUsername(String userName) {
        this.username = userName;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public RestAcquisitionQueue setPassword(String password) {
        this.password = password;
        return this;
    }

    public boolean isMediaTypeJson() {
        return this.mediaTypeJson;
    }

    public RestAcquisitionQueue setMediaTypeJson(boolean mediaTypeJson) {
        this.mediaTypeJson = mediaTypeJson;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RestAcquisitionQueue setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public long getAcquisitionPeriod() {
        return this.acquisitionPeriod;
    }

    public RestAcquisitionQueue setAcquisitionPeriod(int acquisitionPeriod) {
        this.acquisitionPeriod = acquisitionPeriod;
        return this;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public RestAcquisitionQueue setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public long getCheckPeriod() {
        return this.checkPeriod;
    }

    public RestAcquisitionQueue setCheckPeriod(long checkPeriod) {
        this.checkPeriod = checkPeriod;
        return this;
    }

    public Queue create(String dest) throws ConnectException, AdminException {
        return this.create(AdminModule.getLocalServerId(), dest);
    }

    public Queue create(int serverId, String dest) throws ConnectException, AdminException {
        return this.create(serverId, null, dest);
    }

    public Queue create(int serverId, String name, String dest) throws ConnectException, AdminException {
        return this.create(serverId, name, dest, null);
    }

    public Queue create(int serverId, String name, String dest, Properties props) throws ConnectException, AdminException {
        if (dest == null) {
            throw new AdminException("Remote destination cannot be null");
        }
        if (props == null) {
            props = new Properties();
        }
        props.setProperty("acquisition.className", RESTAcquisition);
        if (!props.containsKey("rest.host")) {
            props.setProperty("rest.host", this.host);
        }
        if (!props.containsKey("rest.port")) {
            props.setProperty("rest.port", "" + this.port);
        }
        if (!props.containsKey("rest.useOldAPI")) {
            props.setProperty("rest.useOldAPI", "" + this.useOldAPI);
        }
        if (!props.containsKey("rest.user")) {
            props.setProperty("rest.user", this.username);
        }
        if (!props.containsKey("rest.pass")) {
            props.setProperty("rest.pass", this.password);
        }
        if (!props.containsKey("rest.mediaTypeJson")) {
            props.setProperty("rest.mediaTypeJson", "" + this.mediaTypeJson);
        }
        if (!props.containsKey("rest.timeout")) {
            props.setProperty("rest.timeout", "" + this.timeout);
        }
        if (!props.containsKey("rest.idletimeout")) {
            props.setProperty("rest.idletimeout", "" + this.idleTimeout);
        }
        if (!props.containsKey("rest.checkPeriod")) {
            props.setProperty("rest.checkPeriod", "" + this.checkPeriod);
        }
        if (!props.containsKey("acquisition.period")) {
            props.setProperty("acquisition.period", "" + this.acquisitionPeriod);
        }
        props.setProperty("jms.destination", dest);
        return Queue.create(serverId, name, "org.objectweb.joram.mom.dest.AcquisitionQueue", props);
    }
}

