/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import java.net.ConnectException;
import java.util.Properties;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;

public class RestDistributionQueue {
    public static final String RESTDistribution = "com.scalagent.joram.mom.dest.rest.RESTDistribution";
    private String host = "localhost";
    private int port = 8989;
    private boolean useOldAPI = false;
    private String userName = "anonymous";
    private String password = "anonymous";
    private boolean batch = true;
    private boolean async = true;
    private int period = 1000;
    private long idleTimeout = 60L;

    public String getHost() {
        return this.host;
    }

    public RestDistributionQueue setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public RestDistributionQueue setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean isUseOldAPI() {
        return this.useOldAPI;
    }

    public RestDistributionQueue setUseOldAPI(boolean useOldAPI) {
        this.useOldAPI = useOldAPI;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public RestDistributionQueue setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public RestDistributionQueue setPassword(String password) {
        this.password = password;
        return this;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public RestDistributionQueue setBatch(boolean batch) {
        this.batch = batch;
        return this;
    }

    public boolean isAsync() {
        return this.async;
    }

    public RestDistributionQueue setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public int getPeriod() {
        return this.period;
    }

    public RestDistributionQueue setPeriod(int period) {
        this.period = period;
        return this;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public RestDistributionQueue setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public Queue create(String dest) throws ConnectException, AdminException {
        return this.create(AdminModule.getLocalServerId(), dest);
    }

    public Queue create(int serverId, String dest) throws ConnectException, AdminException {
        return this.create(serverId, null, dest);
    }

    public Queue create(int serverId, String name, String dest) throws ConnectException, AdminException {
        return this.create(serverId, name, dest, null);
    }

    public Queue create(int serverId, String name, String dest, Properties props) throws ConnectException, AdminException {
        if (dest == null) {
            throw new AdminException("Remote destination cannot be null");
        }
        if (props == null) {
            props = new Properties();
        }
        props.setProperty("distribution.className", RESTDistribution);
        if (!props.containsKey("rest.host")) {
            props.setProperty("rest.host", this.host);
        }
        if (!props.containsKey("rest.port")) {
            props.setProperty("rest.port", "" + this.port);
        }
        if (!props.containsKey("rest.useOldAPI")) {
            props.setProperty("rest.useOldAPI", "" + this.useOldAPI);
        }
        if (!props.containsKey("rest.user")) {
            props.setProperty("rest.user", this.userName);
        }
        if (!props.containsKey("rest.pass")) {
            props.setProperty("rest.pass", this.password);
        }
        if (!props.containsKey("distribution.async")) {
            props.setProperty("distribution.async", "" + this.async);
        }
        if (!props.containsKey("distribution.batch")) {
            props.setProperty("distribution.batch", "" + this.batch);
        }
        if (!props.containsKey("rest.idletimeout")) {
            props.setProperty("rest.idletimeout", "" + this.idleTimeout);
        }
        if (!props.containsKey("period")) {
            props.setProperty("period", "" + this.period);
        }
        props.setProperty("jms.destination", dest);
        return Queue.create(serverId, name, "org.objectweb.joram.mom.dest.DistributionQueue", props);
    }
}

