/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.net.ConnectException;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.AdminWrapper;
import org.objectweb.joram.client.jms.admin.AdministeredObject;
import org.objectweb.joram.client.jms.admin.Subscription;
import org.objectweb.joram.client.jms.admin.UserMBean;
import org.objectweb.joram.shared.admin.AdminCommandReply;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.ClearSubscription;
import org.objectweb.joram.shared.admin.CreateUserReply;
import org.objectweb.joram.shared.admin.CreateUserRequest;
import org.objectweb.joram.shared.admin.DeleteSubscriptionMessage;
import org.objectweb.joram.shared.admin.DeleteUser;
import org.objectweb.joram.shared.admin.GetDMQSettingsReply;
import org.objectweb.joram.shared.admin.GetDMQSettingsRequest;
import org.objectweb.joram.shared.admin.GetNbMaxMsgRequest;
import org.objectweb.joram.shared.admin.GetNumberReply;
import org.objectweb.joram.shared.admin.GetSubscription;
import org.objectweb.joram.shared.admin.GetSubscriptionMessage;
import org.objectweb.joram.shared.admin.GetSubscriptionMessageIds;
import org.objectweb.joram.shared.admin.GetSubscriptionMessageIdsRep;
import org.objectweb.joram.shared.admin.GetSubscriptionMessageRep;
import org.objectweb.joram.shared.admin.GetSubscriptionRep;
import org.objectweb.joram.shared.admin.GetSubscriptions;
import org.objectweb.joram.shared.admin.GetSubscriptionsRep;
import org.objectweb.joram.shared.admin.SetDMQRequest;
import org.objectweb.joram.shared.admin.SetNbMaxMsgRequest;
import org.objectweb.joram.shared.admin.SetThresholdRequest;
import org.objectweb.joram.shared.admin.UpdateUser;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class User
extends AdministeredObject
implements UserMBean {
    private static final long serialVersionUID = 1L;
    public static final String REDELIVERY_DELAY = "redeliveryDelay";
    public static Logger logger = Debug.getLogger((String)User.class.getName());
    String name;
    String proxyId;
    AdminWrapper wrapper = null;
    protected transient String JMXBeanName = null;

    public User() {
    }

    public User(String name) {
        this.name = name;
    }

    public User(String name, String proxyId) {
        this.name = name;
        this.proxyId = proxyId;
    }

    @Override
    public String toString() {
        return "User[" + this.name + "]:" + this.proxyId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        return other.proxyId.equals(this.proxyId);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    protected final AdminWrapper getWrapper() throws ConnectException {
        if (this.wrapper != null && !this.wrapper.isClosed()) {
            return this.wrapper;
        }
        return AdminModule.getWrapper();
    }

    public void setWrapper(AdminWrapper wrapper) {
        this.wrapper = wrapper;
    }

    private final AdminReply doRequest(AdminRequest request) throws AdminException, ConnectException {
        return this.getWrapper().doRequest(request);
    }

    public static User create(String name, String password, int serverId) throws ConnectException, AdminException {
        return User.create(name, password, serverId, SimpleIdentity.class.getName());
    }

    public static User create(String name, String password) throws ConnectException, AdminException {
        return User.create(name, password, AdminModule.getLocalServerId(), SimpleIdentity.class.getName());
    }

    public static User create(String name, String password, int serverId, String identityClassName) throws ConnectException, AdminException {
        return User.create(name, password, serverId, identityClassName, null);
    }

    public static User create(String name, String password, int serverId, String identityClassName, Properties prop) throws ConnectException, AdminException {
        if (name == null || name.equals("")) {
            throw new AdminException("User name can not be null or empty");
        }
        Identity identity = User.createIdentity(name, password, identityClassName);
        User user = new User(name);
        AdminReply reply = user.getWrapper().doRequest((AdminRequest)new CreateUserRequest(identity, serverId, prop));
        user.proxyId = ((CreateUserReply)reply).getProxId();
        return user;
    }

    public static String getJMXBeanName(String base, User user) {
        int sid = Integer.parseInt(user.proxyId.substring(user.proxyId.indexOf(46) + 1, user.proxyId.lastIndexOf(46)));
        StringBuffer buf = new StringBuffer();
        buf.append(base);
        buf.append(":type=User,location=server#").append(sid).append(",name=").append(user.getName()).append('[').append(user.getProxyId()).append(']');
        return buf.toString();
    }

    public String registerMBean(String base) {
        block2: {
            this.JMXBeanName = User.getJMXBeanName(base, this);
            try {
                MXWrapper.registerMBean((Object)this, (String)this.JMXBeanName);
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block2;
                logger.log(BasicLevel.DEBUG, "User.registerMBean: " + this.JMXBeanName, (Throwable)e);
            }
        }
        return this.JMXBeanName;
    }

    public void unregisterMBean() {
        block3: {
            if (this.JMXBeanName == null) {
                return;
            }
            try {
                MXWrapper.unregisterMBean((String)this.JMXBeanName);
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, "User.unregisterMBean: " + this.JMXBeanName, (Throwable)e);
            }
        }
    }

    private static Identity createIdentity(String user, String passwd, String identityClassName) throws AdminException {
        Identity identity = null;
        try {
            Class<?> clazz = Class.forName(identityClassName);
            identity = (Identity)clazz.newInstance();
            if (passwd != null) {
                identity.setIdentity(user, passwd);
            } else {
                identity.setUserName(user);
            }
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage());
        }
        return identity;
    }

    public void update(String newName, String newPassword) throws ConnectException, AdminException {
        this.update(newName, newPassword, SimpleIdentity.class.getName());
    }

    public void update(String newName, String newPassword, String identityClassName) throws ConnectException, AdminException {
        Identity newIdentity = User.createIdentity(newName, newPassword, identityClassName);
        this.doRequest((AdminRequest)new UpdateUser(this.name, this.proxyId, newIdentity));
        this.name = newName;
    }

    @Override
    public void delete() throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new DeleteUser(this.name, this.proxyId));
        this.unregisterMBean();
    }

    public void setDMQ(Queue dmq) throws ConnectException, AdminException {
        this.setDMQId(dmq.getName());
    }

    @Override
    public void setDMQId(String dmqId) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetDMQRequest(this.proxyId, dmqId));
    }

    public Queue getDMQ() throws ConnectException, AdminException {
        String dmqId = this.getDMQId();
        Queue dmq = null;
        if (dmqId != null) {
            dmq = new Queue(dmqId);
            if (this.wrapper != null) {
                dmq.setWrapper(this.wrapper);
            }
        }
        return dmq;
    }

    @Override
    public String getDMQId() throws ConnectException, AdminException {
        GetDMQSettingsRequest request = new GetDMQSettingsRequest(this.proxyId);
        GetDMQSettingsReply reply = (GetDMQSettingsReply)this.doRequest((AdminRequest)request);
        return reply.getDMQName();
    }

    @Override
    public void setThreshold(int threshold) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetThresholdRequest(this.proxyId, threshold));
    }

    public void setThreshold(String subname, int threshold) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetThresholdRequest(this.proxyId, subname, threshold));
    }

    @Override
    public int getThreshold() throws ConnectException, AdminException {
        GetDMQSettingsRequest request = new GetDMQSettingsRequest(this.proxyId);
        GetDMQSettingsReply reply = (GetDMQSettingsReply)this.doRequest((AdminRequest)request);
        return reply.getThreshold();
    }

    public int getThreshold(String subname) throws ConnectException, AdminException {
        GetDMQSettingsRequest request = new GetDMQSettingsRequest(this.proxyId, subname);
        GetDMQSettingsReply reply = (GetDMQSettingsReply)this.doRequest((AdminRequest)request);
        return reply.getThreshold();
    }

    @Override
    public void setNbMaxMsg(String subName, int nbMaxMsg) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetNbMaxMsgRequest(this.proxyId, nbMaxMsg, subName));
    }

    @Override
    public int getNbMaxMsg(String subName) throws ConnectException, AdminException {
        GetNbMaxMsgRequest request = new GetNbMaxMsgRequest(this.proxyId, subName);
        GetNumberReply reply = (GetNumberReply)this.doRequest((AdminRequest)request);
        return reply.getNumber();
    }

    @Override
    public Subscription[] getSubscriptions() throws AdminException, ConnectException {
        GetSubscriptionsRep reply = (GetSubscriptionsRep)this.doRequest((AdminRequest)new GetSubscriptions(this.proxyId));
        String[] subNames = reply.getSubNames();
        String[] topicIds = reply.getTopicIds();
        int[] messageCounts = reply.getMessageCounts();
        int[] ackCounts = reply.getDeliveredMessageCount();
        boolean[] durable = reply.getDurable();
        Subscription[] res = new Subscription[subNames.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new Subscription(subNames[i], topicIds[i], messageCounts[i], ackCounts[i], durable[i]);
        }
        return res;
    }

    public List<String> getSubscriptionList() throws AdminException, ConnectException {
        Vector<String> list = new Vector<String>();
        Subscription[] sub = this.getSubscriptions();
        for (int i = 0; i < sub.length; ++i) {
            list.add(sub[i].toString());
        }
        return list;
    }

    @Override
    public Subscription getSubscription(String subName) throws AdminException, ConnectException {
        GetSubscriptionRep reply = (GetSubscriptionRep)this.doRequest((AdminRequest)new GetSubscription(this.proxyId, subName));
        Subscription sub = new Subscription(subName, reply.getTopicId(), reply.getMessageCount(), reply.getDeliveredMessageCount(), reply.getDurable());
        return sub;
    }

    @Override
    public String getSubscriptionString(String subName) throws AdminException, ConnectException {
        return this.getSubscription(subName).toString();
    }

    @Override
    public String[] getMessageIds(String subName) throws AdminException, ConnectException {
        GetSubscriptionMessageIdsRep reply = (GetSubscriptionMessageIdsRep)this.doRequest((AdminRequest)new GetSubscriptionMessageIds(this.proxyId, subName));
        return reply.getMessageIds();
    }

    public Message getMessage(String subName, String msgId) throws AdminException, ConnectException, JMSException {
        GetSubscriptionMessageRep reply = (GetSubscriptionMessageRep)this.doRequest((AdminRequest)new GetSubscriptionMessage(this.proxyId, subName, msgId, true));
        return Message.wrapMomMessage(null, reply.getMessage());
    }

    @Override
    public String getMessageDigest(String subName, String msgId) throws AdminException, ConnectException, JMSException {
        GetSubscriptionMessageRep reply = (GetSubscriptionMessageRep)this.doRequest((AdminRequest)new GetSubscriptionMessage(this.proxyId, subName, msgId, true));
        Message msg = Message.wrapMomMessage(null, reply.getMessage());
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("Message: ").append(msg.getJMSMessageID());
        strbuf.append("\n\tTo: ").append(msg.getJMSDestination());
        strbuf.append("\n\tCorrelationId: ").append(msg.getJMSCorrelationID());
        strbuf.append("\n\tDeliveryMode: ").append(msg.getJMSDeliveryMode());
        strbuf.append("\n\tExpiration: ").append(msg.getJMSExpiration());
        strbuf.append("\n\tPriority: ").append(msg.getJMSPriority());
        strbuf.append("\n\tRedelivered: ").append(msg.getJMSRedelivered());
        strbuf.append("\n\tReplyTo: ").append(msg.getJMSReplyTo());
        strbuf.append("\n\tTimestamp: ").append(msg.getJMSTimestamp());
        strbuf.append("\n\tType: ").append(msg.getJMSType());
        return strbuf.toString();
    }

    @Override
    public Properties getMessageHeader(String subName, String msgId) throws AdminException, ConnectException, JMSException {
        GetSubscriptionMessageRep reply = (GetSubscriptionMessageRep)this.doRequest((AdminRequest)new GetSubscriptionMessage(this.proxyId, subName, msgId, false));
        Message msg = Message.wrapMomMessage(null, reply.getMessage());
        Properties prop = new Properties();
        prop.setProperty("JMSMessageID", msg.getJMSMessageID());
        prop.setProperty("JMSDestination", msg.getJMSDestination().toString());
        if (msg.getJMSCorrelationID() != null) {
            prop.setProperty("JMSCorrelationID", msg.getJMSCorrelationID());
        }
        prop.setProperty("JMSDeliveryMode", new Integer(msg.getJMSDeliveryMode()).toString());
        prop.setProperty("JMSExpiration", new Long(msg.getJMSExpiration()).toString());
        prop.setProperty("JMSPriority", new Integer(msg.getJMSPriority()).toString());
        prop.setProperty("JMSRedelivered", new Boolean(msg.getJMSRedelivered()).toString());
        if (msg.getJMSReplyTo() != null) {
            prop.setProperty("JMSReplyTo", msg.getJMSReplyTo().toString());
        }
        prop.setProperty("JMSTimestamp", new Long(msg.getJMSTimestamp()).toString());
        if (msg.getJMSType() != null) {
            prop.setProperty("JMSType", msg.getJMSType());
        }
        return prop;
    }

    @Override
    public Properties getMessageProperties(String subName, String msgId) throws AdminException, ConnectException, JMSException {
        GetSubscriptionMessageRep reply = (GetSubscriptionMessageRep)this.doRequest((AdminRequest)new GetSubscriptionMessage(this.proxyId, subName, msgId, false));
        Message msg = Message.wrapMomMessage(null, reply.getMessage());
        Properties prop = new Properties();
        msg.getProperties(prop);
        return prop;
    }

    @Override
    public void addInterceptorsIN(String interceptors) throws ConnectException, AdminException {
        Properties prop = new Properties();
        prop.put("jms_joram_interceptors_in", interceptors);
        this.getWrapper().processAdmin(this.getProxyId(), 1, prop);
    }

    public void addInterceptorIN(String interceptor, Properties properties) throws ConnectException, AdminException {
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("jms_joram_interceptors_in", interceptor);
        this.getWrapper().processAdmin(this.getProxyId(), 1, properties);
    }

    @Override
    public String getInterceptorsIN() throws ConnectException, AdminException {
        AdminCommandReply reply = (AdminCommandReply)this.getWrapper().processAdmin(this.getProxyId(), 3, null);
        return (String)reply.getProp().get("jms_joram_interceptors_in");
    }

    @Override
    public void removeInterceptorsIN(String interceptors) throws ConnectException, AdminException {
        Properties prop = new Properties();
        prop.put("jms_joram_interceptors_in", interceptors);
        this.getWrapper().processAdmin(this.getProxyId(), 2, prop);
    }

    @Override
    public void addInterceptorsOUT(String interceptors) throws ConnectException, AdminException {
        Properties prop = new Properties();
        prop.put("jms_joram_interceptors_out", interceptors);
        this.getWrapper().processAdmin(this.getProxyId(), 1, prop);
    }

    public void addInterceptorOUT(String interceptor, Properties properties) throws ConnectException, AdminException {
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("jms_joram_interceptors_out", interceptor);
        this.getWrapper().processAdmin(this.getProxyId(), 1, properties);
    }

    @Override
    public String getInterceptorsOUT() throws ConnectException, AdminException {
        AdminCommandReply reply = (AdminCommandReply)this.getWrapper().processAdmin(this.getProxyId(), 3, null);
        return (String)reply.getProp().get("jms_joram_interceptors_out");
    }

    @Override
    public void removeInterceptorsOUT(String interceptors) throws ConnectException, AdminException {
        Properties prop = new Properties();
        prop.put("jms_joram_interceptors_out", interceptors);
        this.getWrapper().processAdmin(this.getProxyId(), 2, prop);
    }

    public void replaceInterceptorIN(String newInterceptor, String oldInterceptor) throws ConnectException, AdminException {
        Properties prop = new Properties();
        prop.put("jms_joram_interceptors_in_new", newInterceptor);
        prop.put("jms_joram_interceptors_in_old", oldInterceptor);
        this.getWrapper().processAdmin(this.getProxyId(), 4, prop);
    }

    public void replaceInterceptorIN(String newInterceptor, String oldInterceptor, Properties properties) throws ConnectException, AdminException {
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("jms_joram_interceptors_in_new", newInterceptor);
        properties.put("jms_joram_interceptors_in_old", oldInterceptor);
        this.getWrapper().processAdmin(this.getProxyId(), 4, properties);
    }

    public void replaceInterceptorOUT(String newInterceptor, String oldInterceptor) throws ConnectException, AdminException {
        Properties prop = new Properties();
        prop.put("jms_joram_interceptors_out_new", newInterceptor);
        prop.put("jms_joram_interceptors_out_old", oldInterceptor);
        this.getWrapper().processAdmin(this.getProxyId(), 4, prop);
    }

    public void replaceInterceptorOUT(String newInterceptor, String oldInterceptor, Properties properties) throws ConnectException, AdminException {
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("jms_joram_interceptors_out_new", newInterceptor);
        properties.put("jms_joram_interceptors_out_old", oldInterceptor);
        this.getWrapper().processAdmin(this.getProxyId(), 4, properties);
    }

    public void setRedeliveryDelay(int redeliveryDelay) throws ConnectException, AdminException {
        Properties properties = new Properties();
        properties.put("joram.jms.redeliveryDelay", "" + redeliveryDelay);
        this.getWrapper().processAdmin(this.getProxyId(), 10, properties);
    }

    public Message readMessage(String subName, String msgId) throws AdminException, ConnectException, JMSException {
        return this.getMessage(subName, msgId);
    }

    @Override
    public void deleteMessage(String subName, String msgId) throws AdminException, ConnectException {
        this.doRequest((AdminRequest)new DeleteSubscriptionMessage(this.proxyId, subName, msgId));
    }

    @Override
    public void clearSubscription(String subName) throws AdminException, ConnectException {
        this.doRequest((AdminRequest)new ClearSubscription(this.proxyId, subName));
    }

    @Override
    public String getProxyId() {
        return this.proxyId;
    }

    @Override
    public void toReference(Reference ref) throws NamingException {
        ref.add(new StringRefAddr("user.name", this.name));
        ref.add(new StringRefAddr("user.id", this.proxyId));
    }

    @Override
    public void fromReference(Reference ref) throws NamingException {
        this.name = (String)ref.get("user.name").getContent();
        this.proxyId = (String)ref.get("user.id").getContent();
    }
}

