/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.connection;

import fr.dyade.aaa.common.Debug;
import java.util.ArrayList;
import javax.jms.Message;
import org.objectweb.joram.client.jms.MessageProducer;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class CompletionListener {
    public static Logger logger = Debug.getLogger((String)CompletionListener.class.getName());
    Session session = null;
    MessageProducer messageProducer = null;
    ArrayList<javax.jms.CompletionListener> listeners = null;
    ArrayList<Message> messages = null;

    public CompletionListener(Session session, MessageProducer messageProducer) {
        this.session = session;
        this.messageProducer = messageProducer;
        this.listeners = new ArrayList();
        this.messages = new ArrayList();
    }

    public void addCompletionListener(javax.jms.CompletionListener listener, Message message) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "addCompletionListener(" + listener + ", " + message + ')');
        }
        if (listener != null) {
            this.listeners.add(listener);
            this.messages.add(message);
        }
    }

    void onCompletion() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "onCompletion()");
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onCompletion(this.messages.get(i));
                continue;
            }
            catch (Exception exc) {
                logger.log(BasicLevel.WARN, "onCompletion(" + this.messages.get(i) + ") should not throw exception: " + exc);
            }
        }
    }

    void onException(Exception exception) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "onException(" + exception + ')');
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onException(this.messages.get(i), exception);
                continue;
            }
            catch (Exception exc) {
                logger.log(BasicLevel.WARN, "onException(" + this.messages.get(i) + ") should not throw exception: " + exc);
            }
        }
    }

    public String toString() {
        return "CompletionListener (" + this.session + ", " + this.messageProducer + ", " + this.listeners + ", " + this.messages + ')';
    }
}

