/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.connection;

import fr.dyade.aaa.common.Daemon;
import fr.dyade.aaa.common.Debug;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.MessageProducer;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.joram.client.jms.connection.AbortedRequestException;
import org.objectweb.joram.client.jms.connection.CompletionListener;
import org.objectweb.joram.client.jms.connection.ErrorListener;
import org.objectweb.joram.client.jms.connection.MultiThreadSyncChannel;
import org.objectweb.joram.client.jms.connection.ReplyListener;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.CommitRequest;
import org.objectweb.joram.shared.client.ConsumerMessages;
import org.objectweb.joram.shared.client.ConsumerReceiveRequest;
import org.objectweb.joram.shared.client.ConsumerUnsetListRequest;
import org.objectweb.joram.shared.client.MomExceptionReply;
import org.objectweb.joram.shared.client.PingRequest;
import org.objectweb.joram.shared.client.ProducerMessages;
import org.objectweb.joram.shared.client.SessDenyRequest;
import org.objectweb.joram.shared.excepts.MomException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class RequestMultiplexer {
    private static Logger logger = Debug.getLogger((String)RequestMultiplexer.class.getName());
    private Connection cnx;
    private volatile int status;
    private RequestChannel channel;
    private Map<Integer, ReplyListener> requestsTable;
    private Map<Integer, CompletionListener> completionListeners;
    private int requestCounter;
    private DemultiplexerDaemon demtpx;
    private static Timer timer;
    private static int timerInUse;
    private HeartBeatTask heartBeatTask;
    private ExceptionListener exceptionListener;
    private volatile long lastRequestDate;
    CompletionListener runningCL = null;

    public static JMSException buildJmsException(MomExceptionReply excReply) {
        Throwable jmsExc = null;
        int excType = excReply.getType();
        jmsExc = excType == 2 ? new JMSSecurityException(excReply.getMessage()) : (excType == 3 ? new InvalidDestinationException(excReply.getMessage()) : new JMSException(excReply.getMessage()));
        return jmsExc;
    }

    public boolean checkDemultiplexerDaemon() {
        return this.demtpx.isCurrentThread();
    }

    public boolean checkCLSession(Session session) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "checkCLSession runningCL=" + this.runningCL);
        }
        if (this.checkDemultiplexerDaemon()) {
            if (this.runningCL != null) {
                return session == this.runningCL.session;
            }
            return false;
        }
        return false;
    }

    public boolean checkCLMessageProducer(Session session, MessageProducer mp) {
        if (this.runningCL != null && mp != null) {
            return this.checkCLSession(session) && mp.equals(this.runningCL.messageProducer);
        }
        return false;
    }

    private static synchronized void createTimer() {
        if (timer == null) {
            timer = new Timer("RequestMultiplexer.Timer");
            timerInUse = 0;
        }
        ++timerInUse;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "createTimer: timerInUse = " + timerInUse);
        }
    }

    private static synchronized void cancelTimer() {
        if (timer != null && --timerInUse < 1) {
            timer.cancel();
            timer = null;
            timerInUse = 0;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "cancelTimer: timerInUse = " + timerInUse);
        }
    }

    private static synchronized Timer getTimer() {
        return timer;
    }

    public RequestMultiplexer(Connection cnx, RequestChannel channel, long heartBeat) throws JMSException {
        this.channel = channel;
        this.cnx = cnx;
        this.requestsTable = new Hashtable<Integer, ReplyListener>();
        this.completionListeners = new Hashtable<Integer, CompletionListener>();
        this.requestCounter = 0;
        RequestMultiplexer.createTimer();
        channel.setTimer(RequestMultiplexer.getTimer());
        try {
            channel.connect();
        }
        catch (JMSException exc) {
            throw exc;
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
            }
            RequestMultiplexer.cancelTimer();
            throw new JMSException(exc.toString());
        }
        this.demtpx = new DemultiplexerDaemon();
        this.demtpx.start();
        this.setStatus(0);
        if (heartBeat > 0L) {
            this.heartBeatTask = new HeartBeatTask(heartBeat);
            this.lastRequestDate = System.currentTimeMillis();
            try {
                this.heartBeatTask.start();
            }
            catch (Exception exc) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
                }
                throw new JMSException(exc.toString());
            }
        }
    }

    private void setStatus(int status) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "RequestMultiplexer.setStatus(" + Status.toString(status) + ')');
        }
        this.status = status;
    }

    public boolean isClosed() {
        return this.status == 1;
    }

    public void closing() {
        this.channel.closing();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void sendRequest(AbstractJmsRequest request) throws JMSException {
        this.sendRequest(request, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(AbstractJmsRequest request, ReplyListener listener, CompletionListener completionListener) throws JMSException {
        RequestMultiplexer requestMultiplexer = this;
        synchronized (requestMultiplexer) {
            if (this.status == 1) {
                throw new IllegalStateException("Connection closed");
            }
            if (this.requestCounter == Integer.MAX_VALUE) {
                this.requestCounter = 0;
            }
            request.setRequestId(this.requestCounter++);
            if (listener != null) {
                this.requestsTable.put(request.getRequestId(), listener);
            }
            if (completionListener != null && (request instanceof ProducerMessages || request instanceof CommitRequest)) {
                this.completionListeners.put(request.getRequestId(), completionListener);
            }
            if (this.heartBeatTask != null) {
                this.lastRequestDate = System.currentTimeMillis();
            }
        }
        try {
            this.channel.send(request);
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
            }
            JMSException jmsExc = new JMSException(exc.toString());
            jmsExc.setLinkedException(exc);
            throw jmsExc;
        }
    }

    public void setMultiThreadSync(int delay, int threshold) {
        this.channel = new MultiThreadSyncChannel(this.channel, delay, threshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "RequestMultiplexer.close()");
        }
        RequestMultiplexer requestMultiplexer = this;
        synchronized (requestMultiplexer) {
            if (this.status == 1) {
                return;
            }
            this.setStatus(1);
        }
        if (this.heartBeatTask != null) {
            this.heartBeatTask.cancel();
        }
        RequestMultiplexer.cancelTimer();
        this.channel.close();
        this.demtpx.stop();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, " -> requestsTable=" + this.requestsTable);
        }
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Integer[] requestIds;
        Map<Integer, ReplyListener> map = this.requestsTable;
        synchronized (map) {
            Set<Integer> keySet = this.requestsTable.keySet();
            requestIds = new Integer[keySet.size()];
            keySet.toArray(requestIds);
        }
        for (int i = 0; i < requestIds.length; ++i) {
            ReplyListener rl = this.requestsTable.get(requestIds[i]);
            if (rl == null) continue;
            rl.replyAborted(requestIds[i]);
        }
        this.requestsTable.clear();
        this.completionListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyAllError(MomExceptionReply exc) {
        Integer[] requestIds;
        Set<Integer> keySet;
        Map<Integer, ReplyListener> map = this.requestsTable;
        synchronized (map) {
            keySet = this.requestsTable.keySet();
            requestIds = new Integer[keySet.size()];
            keySet.toArray(requestIds);
        }
        for (int i = 0; i < requestIds.length; ++i) {
            ReplyListener rl = this.requestsTable.get(requestIds[i]);
            if (rl == null) continue;
            rl.errorReceived(requestIds[i], exc);
        }
        Map<Integer, CompletionListener> i = this.completionListeners;
        synchronized (i) {
            keySet = this.completionListeners.keySet();
            requestIds = new Integer[keySet.size()];
            keySet.toArray(requestIds);
        }
        for (int i2 = 0; i2 < requestIds.length; ++i2) {
            CompletionListener cl = this.completionListeners.get(requestIds[i2]);
            if (cl == null) continue;
            cl.onException(new Exception(exc.getMessage()));
        }
        this.completionListeners.clear();
        this.requestsTable.clear();
    }

    public void abortRequest(int requestId) {
        ReplyListener rl;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "RequestMultiplexer.abortRequest(" + requestId + ')');
        }
        if ((rl = this.doAbortRequest(requestId)) != null) {
            rl.replyAborted(requestId);
        }
    }

    private synchronized ReplyListener doAbortRequest(int requestId) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "RequestMultiplexer.doAbortRequest(" + requestId + ')');
        }
        if (this.status == 1) {
            return null;
        }
        return this.requestsTable.remove(requestId);
    }

    private void route(AbstractJmsReply reply, boolean isCompletionListener) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "RequestMultiplexer.route(" + reply + ')');
        }
        int requestId = reply.getCorrelationId();
        Integer requestKey = requestId;
        ReplyListener rl = this.requestsTable.get(requestKey);
        if (reply instanceof MomExceptionReply) {
            MomExceptionReply excReply = (MomExceptionReply)reply;
            if (rl instanceof ErrorListener) {
                ((ErrorListener)((Object)rl)).errorReceived(requestId, excReply);
            } else if (this.exceptionListener != null) {
                this.exceptionListener.onException(RequestMultiplexer.buildJmsException(excReply));
            }
        } else {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, " -> rl = " + rl);
            }
            if (rl != null) {
                try {
                    if (!isCompletionListener && rl.replyReceived(reply)) {
                        this.requestsTable.remove(requestKey);
                    }
                }
                catch (AbortedRequestException exc) {
                    logger.log(BasicLevel.WARN, " -> Request aborted: " + requestId);
                    this.abortReply(reply);
                }
            } else {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, " -> Listener not found for the reply: " + requestId);
                }
                this.abortReply(reply);
            }
        }
    }

    private void abortReply(AbstractJmsReply reply) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "RequestMultiplexer.abortReply(" + reply + ')');
        }
        if (reply instanceof ConsumerMessages) {
            this.deny((ConsumerMessages)reply);
        }
    }

    public void deny(ConsumerMessages messages) {
        block4: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "RequestMultiplexer.deny(" + messages + ')');
            }
            Vector msgList = messages.getMessages();
            Vector<String> ids = new Vector<String>();
            for (int i = 0; i < msgList.size(); ++i) {
                ids.addElement(((Message)msgList.elementAt((int)i)).id);
            }
            SessDenyRequest deny = new SessDenyRequest(messages.comesFrom(), ids, messages.getQueueMode());
            try {
                this.sendRequest((AbstractJmsRequest)deny);
            }
            catch (JMSException exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block4;
                logger.log(BasicLevel.DEBUG, "Connection is closed", (Throwable)exc);
            }
        }
    }

    public void denyRequest(ConsumerReceiveRequest request) {
        block3: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "RequestMultiplexer.denyRequest(" + request.getRequestId() + ')');
            }
            ConsumerUnsetListRequest unsetLR = new ConsumerUnsetListRequest(request.getQueueMode());
            unsetLR.setTarget(request.getTarget());
            unsetLR.setCancelledRequestId(request.getRequestId());
            try {
                this.sendRequest((AbstractJmsRequest)unsetLR);
            }
            catch (JMSException exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, "Connection is closed", (Throwable)exc);
            }
        }
    }

    private void onException(Exception exc) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "RequestMultiplexer.onException(" + exc + ')');
        }
        Throwable jmsExc = exc instanceof JMSException ? (JMSException)((Object)exc) : new IllegalStateException(exc.getMessage());
        if (this.exceptionListener != null) {
            this.exceptionListener.onException((JMSException)jmsExc);
        }
    }

    public void schedule(TimerTask task, long period) {
        block3: {
            Timer timer = RequestMultiplexer.getTimer();
            if (timer != null) {
                try {
                    timer.schedule(task, period);
                }
                catch (Exception exc) {
                    if (!logger.isLoggable(BasicLevel.ERROR)) break block3;
                    logger.log(BasicLevel.ERROR, "", (Throwable)exc);
                }
            }
        }
    }

    public void setDemultiplexerDaemonName(String name) {
        this.demtpx.setName(name);
    }

    public String getDemultiplexerDaemonName() {
        return this.demtpx.getName();
    }

    private class HeartBeatTask
    extends TimerTask {
        private long heartBeat;

        HeartBeatTask(long heartBeat) {
            this.heartBeat = heartBeat;
        }

        @Override
        public void run() {
            block3: {
                try {
                    long date = System.currentTimeMillis();
                    if (date - RequestMultiplexer.this.lastRequestDate > this.heartBeat) {
                        RequestMultiplexer.this.sendRequest((AbstractJmsRequest)new PingRequest());
                    }
                }
                catch (Exception exc) {
                    if (!logger.isLoggable(BasicLevel.WARN)) break block3;
                    logger.log(BasicLevel.WARN, "HeartBeatTask", (Throwable)exc);
                }
            }
        }

        public void start() throws Exception {
            Timer timer = RequestMultiplexer.getTimer();
            if (timer != null) {
                timer.schedule((TimerTask)this, this.heartBeat / 4L, this.heartBeat / 4L);
            }
        }
    }

    private class Closer
    implements Runnable {
        private Exception exc;

        Closer(Exception e) {
            this.exc = e;
        }

        @Override
        public void run() {
            block2: {
                try {
                    RequestMultiplexer.this.cnx.close();
                }
                catch (JMSException exc2) {
                    if (!logger.isLoggable(BasicLevel.WARN)) break block2;
                    logger.log(BasicLevel.WARN, "Error during close", (Throwable)exc2);
                }
            }
            RequestMultiplexer.this.onException(this.exc);
        }
    }

    private class DemultiplexerDaemon
    extends Daemon {
        DemultiplexerDaemon() {
            super("Connection#?", logger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.running) {
                    CompletionListener cl;
                    onExceptionRunner oer;
                    AbstractJmsReply reply;
                    this.canStop = true;
                    try {
                        reply = RequestMultiplexer.this.channel.receive();
                    }
                    catch (Exception exc) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, "Exception during receive", (Throwable)exc);
                        }
                        if (!RequestMultiplexer.this.isClosed()) {
                            RequestMultiplexer.this.replyAllError(new MomExceptionReply(new MomException(exc.getMessage())));
                            RequestMultiplexer.this.close();
                            Closer closer = new Closer(exc);
                            new Thread((Runnable)closer, "RequestMultiplexer.Closer").start();
                        } else {
                            oer = new onExceptionRunner(exc);
                            new Thread((Runnable)oer, "RequestMultiplexer.onException").start();
                        }
                        break;
                    }
                    this.canStop = false;
                    boolean isCompletionListener = false;
                    if (!RequestMultiplexer.this.completionListeners.isEmpty() && (cl = (CompletionListener)RequestMultiplexer.this.completionListeners.remove(reply.getCorrelationId())) != null) {
                        try {
                            RequestMultiplexer.this.runningCL = cl;
                            if (reply instanceof MomExceptionReply) {
                                cl.onException(new Exception(((MomExceptionReply)reply).getMessage()));
                            } else {
                                cl.onCompletion();
                            }
                        }
                        catch (Throwable t) {
                            logger.log(BasicLevel.ERROR, "Error during completion listener execution.", t);
                        }
                        finally {
                            RequestMultiplexer.this.runningCL = null;
                        }
                        isCompletionListener = true;
                    }
                    RequestMultiplexer.this.route(reply, isCompletionListener);
                    if (isCompletionListener) {
                        RequestMultiplexer.this.requestsTable.remove(reply.getCorrelationId());
                    }
                    if (this.running || !RequestMultiplexer.this.isClosed()) continue;
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, "DemultiplexerDaemon ended and Socket closed.");
                    }
                    oer = new onExceptionRunner(new Exception("DemultiplexerDaemon ended and Socket closed."));
                    new Thread((Runnable)oer, "RequestMultiplexer.onException").start();
                }
            }
            finally {
                this.finish();
            }
        }

        public void stop() {
            if (this.isCurrentThread()) {
                this.finish();
            } else {
                super.stop();
            }
        }

        protected void shutdown() {
        }

        protected void close() {
        }
    }

    class onExceptionRunner
    implements Runnable {
        Exception exc;

        onExceptionRunner(Exception exc) {
            this.exc = exc;
        }

        @Override
        public void run() {
            RequestMultiplexer.this.onException(this.exc);
        }
    }

    private static class Status {
        public static final int OPEN = 0;
        public static final int CLOSE = 1;
        private static final String[] names = new String[]{"OPEN", "CLOSE"};

        private Status() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }
}

