/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.connection;

import fr.dyade.aaa.common.Debug;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.connection.AbortedRequestException;
import org.objectweb.joram.client.jms.connection.CompletionListener;
import org.objectweb.joram.client.jms.connection.ErrorListener;
import org.objectweb.joram.client.jms.connection.ReplyListener;
import org.objectweb.joram.client.jms.connection.RequestMultiplexer;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.CommitRequest;
import org.objectweb.joram.shared.client.ConsumerMessages;
import org.objectweb.joram.shared.client.ConsumerReceiveRequest;
import org.objectweb.joram.shared.client.MomExceptionReply;
import org.objectweb.joram.shared.client.ProducerMessages;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class Requestor
implements ReplyListener,
ErrorListener {
    private static Logger logger = Debug.getLogger((String)Requestor.class.getName());
    public static final String DEFAULT_REQUEST_TIMEOUT_PROPERTY = "org.objectweb.joram.client.jms.connection.Requestor.defaultRequestTimeout";
    public static final long DEFAULT_REQUEST_TIMEOUT_VALUE = 0L;
    private long defaultRequestTimeout;
    private RequestMultiplexer mtpx;
    private Object reply;
    private int requestId;
    private int status;

    public Requestor(RequestMultiplexer mtpx) {
        this.mtpx = mtpx;
        this.init();
    }

    private void setStatus(int status) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Requestor.setStatus(" + Status.toString(status) + ')');
        }
        this.status = status;
    }

    public final synchronized int getRequestId() {
        return this.requestId;
    }

    private void init() {
        this.defaultRequestTimeout = Long.getLong(DEFAULT_REQUEST_TIMEOUT_PROPERTY, 0L);
        if (this.status == 2) {
            this.setStatus(0);
            this.reply = null;
            this.requestId = -1;
        }
    }

    public synchronized AbstractJmsReply request(AbstractJmsRequest request) throws JMSException {
        return this.request(request, this.defaultRequestTimeout, null);
    }

    public synchronized AbstractJmsReply request(AbstractJmsRequest request, CompletionListener completionListener) throws JMSException {
        return this.request(request, this.defaultRequestTimeout, completionListener);
    }

    public synchronized AbstractJmsReply request(AbstractJmsRequest request, long timeout, CompletionListener completionListener) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Requestor.request(" + request + ',' + timeout + ',' + completionListener + "), status = " + Status.toString(this.status));
        }
        long sleep = timeout;
        if (this.status != 0) {
            if (this.status == 3) {
                return null;
            }
            if (completionListener == null && this.status != 4) {
                throw new IllegalStateException("Requestor already used");
            }
        }
        if (this.status == 4) {
            long time = System.currentTimeMillis();
            try {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, " -> request STOP wait");
                }
                this.wait(sleep);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, " -> request STOP awake");
                }
            }
            catch (InterruptedException exc) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, "", (Throwable)exc);
                }
                return null;
            }
            if (sleep > 0L) {
                time = System.currentTimeMillis() - time;
                if (time >= sleep) {
                    return null;
                }
                sleep -= time;
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, "new timeout = " + sleep);
                }
            }
        }
        this.mtpx.sendRequest(request, this, completionListener);
        this.setStatus(1);
        this.requestId = request.getRequestId();
        if (completionListener != null && (request instanceof ProducerMessages || request instanceof CommitRequest)) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, " -> request #" + this.requestId + ", completionListener = " + completionListener);
            }
            this.init();
            return null;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, " -> request #" + this.requestId + " wait");
        }
        try {
            this.wait(sleep);
        }
        catch (InterruptedException exc) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, "", (Throwable)exc);
            }
            this.setStatus(2);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, " -> request #" + this.requestId + " awake");
        }
        try {
            if (this.status == 1) {
                this.mtpx.abortRequest(this.requestId);
                AbstractJmsReply exc = null;
                return exc;
            }
            if (this.status == 0) {
                this.mtpx.abortRequest(this.requestId);
                AbstractJmsReply exc = this.request(request, sleep, completionListener);
                return exc;
            }
            if (this.status == 3) {
                ConsumerReceiveRequest crr22;
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, " -> deny " + this.reply);
                }
                if (this.reply instanceof ConsumerMessages) {
                    this.mtpx.deny((ConsumerMessages)this.reply);
                } else if (this.reply == null && request instanceof ConsumerReceiveRequest && (crr22 = (ConsumerReceiveRequest)request).getTimeToLive() <= 0L && crr22.getQueueMode()) {
                    logger.log(BasicLevel.DEBUG, " -> deny request " + request.getRequestId());
                    this.mtpx.denyRequest(crr22);
                }
                AbstractJmsReply crr22 = null;
                return crr22;
            }
            if (this.status == 2) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, " -> request #" + this.requestId + " done : " + this.reply);
                }
                if (this.reply instanceof MomExceptionReply) {
                    JMSException jmsExc = RequestMultiplexer.buildJmsException((MomExceptionReply)this.reply);
                    throw jmsExc;
                }
                if (this.reply instanceof AbstractJmsReply) {
                    AbstractJmsReply abstractJmsReply = (AbstractJmsReply)this.reply;
                    return abstractJmsReply;
                }
                AbstractJmsReply abstractJmsReply = null;
                return abstractJmsReply;
            }
            throw new Error();
        }
        finally {
            this.init();
        }
    }

    @Override
    public synchronized boolean replyReceived(AbstractJmsReply reply) throws AbortedRequestException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Requestor.replyReceived(" + reply + ')');
        }
        if (this.status == 1 && reply.getCorrelationId() == this.requestId) {
            this.reply = reply;
            this.setStatus(2);
            this.notify();
            return true;
        }
        throw new AbortedRequestException();
    }

    @Override
    public synchronized void errorReceived(int replyId, MomExceptionReply exc) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Requestor.errorReceived(" + replyId + ',' + exc + ')');
        }
        if (this.status == 1 && replyId == this.requestId) {
            this.reply = exc;
            this.setStatus(2);
            this.notify();
        }
    }

    @Override
    public synchronized void replyAborted(int replyId) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Requestor.replyAborted(" + replyId + ')');
        }
        if (this.status == 1 && replyId == this.requestId) {
            this.reply = null;
            this.setStatus(2);
            this.notify();
        }
    }

    public synchronized void abortRequest() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Requestor[" + Status.toString(this.status) + ',' + this.requestId + "].abortRequest()");
        }
        if (this.status == 1 && this.requestId > 0) {
            this.mtpx.abortRequest(this.requestId);
            this.setStatus(2);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, " -> notify requestor");
            }
            this.notify();
        }
    }

    public synchronized void close() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Requestor.close()");
        }
        if (this.status != 3) {
            this.abortRequest();
            this.setStatus(3);
        }
    }

    public synchronized void start() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Requestor.start()");
        }
        if (this.status == 4) {
            this.setStatus(0);
            this.notify();
        }
    }

    public void stop() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Requestor.stop()");
        }
        this.setStatus(4);
    }

    private static class Status {
        public static final int INIT = 0;
        public static final int RUN = 1;
        public static final int DONE = 2;
        public static final int CLOSE = 3;
        public static final int STOP = 4;
        private static final String[] names = new String[]{"INIT", "RUN", "DONE", "CLOSE", "STOP"};

        private Status() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }
}

