/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.local;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.util.Date;
import java.util.Timer;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.client.jms.local.LocalConnections;
import org.objectweb.joram.client.jms.local.LocalRequestChannelMBean;
import org.objectweb.joram.mom.dest.AdminTopic;
import org.objectweb.joram.mom.notifications.GetProxyIdNot;
import org.objectweb.joram.mom.proxies.ConnectionContext;
import org.objectweb.joram.mom.proxies.ConnectionManager;
import org.objectweb.joram.mom.proxies.OpenConnectionNot;
import org.objectweb.joram.mom.proxies.StandardConnectionContext;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class LocalRequestChannel
implements RequestChannel,
LocalRequestChannelMBean {
    public static Logger logger = Debug.getLogger((String)LocalRequestChannel.class.getName());
    private FactoryParameters params;
    private Identity identity;
    private AgentId proxyId = null;
    private StandardConnectionContext ctx = null;
    private Date creationDate = null;
    private long sentCount;
    private long receivedCount;

    public LocalRequestChannel(FactoryParameters params, Identity identity) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "LocalConnection.<init>(" + identity + ')');
        }
        this.params = params;
        this.identity = identity;
    }

    @Override
    public void setTimer(Timer timer) {
    }

    @Override
    public void connect() throws Exception {
        LocalConnections localConnections;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "LocalConnection.connect()");
        }
        if (!(localConnections = LocalConnections.getCurrentInstance()).isActivated()) {
            throw new IllegalStateException("Local connections have been deactivated.");
        }
        localConnections.increaseInitiatedConnectionCount();
        if (AgentServer.getStatus() != 4) {
            if (AgentServer.getStatus() != 2 && AgentServer.getStatus() != 6) {
                if (logger.isLoggable(BasicLevel.ERROR)) {
                    logger.log(BasicLevel.ERROR, "LocalConnection.connect(), server is not initialized: " + AgentServer.getStatusInfo() + '.');
                }
                throw new Exception("Server is not initialized.");
            }
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, "LocalConnection.connect(), server is not started: " + AgentServer.getStatusInfo() + '.');
            }
            throw new Exception("Server is not started.");
        }
        GetProxyIdNot gpin = new GetProxyIdNot(this.identity, null);
        try {
            gpin.invoke(AdminTopic.getDefault(), (long)this.params.connectingTimer * 1000L);
            this.proxyId = gpin.getProxyId();
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "LocalConnection.connect() failed", (Throwable)exc);
            }
            localConnections.increaseFailedLoginCount();
            throw new JMSException(exc.getMessage());
        }
        if (this.proxyId == null) {
            String msg = "Could not connect to embedded JMS server after " + this.params.connectingTimer + " secs.";
            IllegalStateException jmsExc = new IllegalStateException(msg);
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, " -> Could not connect to JMS server " + this.identity, (Throwable)jmsExc);
            }
            throw jmsExc;
        }
        OpenConnectionNot ocn = new OpenConnectionNot(ConnectionContext.Type.STANDARD, 0, true);
        try {
            ocn.invoke(this.proxyId, (long)this.params.connectingTimer * 1000L);
            this.ctx = (StandardConnectionContext)ocn.getConnectionContext();
            this.creationDate = new Date();
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "LocalConnection.connect() failed", (Throwable)exc);
            }
            JMSException jmse = new JMSException(exc.getMessage());
            jmse.setLinkedException(exc);
            throw jmse;
        }
        if (this.ctx == null) {
            String msg = "Could not connect to embedded JMS server after " + this.params.connectingTimer + " secs.";
            IllegalStateException jmsExc = new IllegalStateException(msg);
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, " -> Could not connect to JMS server " + this.identity, (Throwable)jmsExc);
            }
            throw jmsExc;
        }
        localConnections.addLocalConnection(this);
        try {
            MXWrapper.registerMBean((Object)this, (String)("Joram#" + AgentServer.getServerId()), (String)this.getMBeanName());
        }
        catch (Exception e) {
            logger.log(BasicLevel.DEBUG, "registerMBean", (Throwable)e);
        }
    }

    private String getMBeanName() {
        return "type=Connection,mode=local,id=" + this.identity.getUserName() + "[" + this.ctx.getKey() + "]";
    }

    @Override
    public void send(AbstractJmsRequest request) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "LocalConnection.send(" + request + ')');
        }
        ConnectionManager.sendToProxy((AgentId)this.proxyId, (int)this.ctx.getKey(), (AbstractJmsRequest)request, (Object)request, (ConnectionContext)this.ctx);
        ++this.sentCount;
    }

    @Override
    public AbstractJmsReply receive() throws Exception {
        AbstractJmsReply reply = (AbstractJmsReply)this.ctx.getQueue().get();
        this.ctx.getQueue().pop();
        ++this.receivedCount;
        return reply;
    }

    @Override
    public void close() {
        this.ctx.getQueue().close();
        LocalConnections.getCurrentInstance().removeLocalConnection(this);
        try {
            MXWrapper.unregisterMBean((String)("Joram#" + AgentServer.getServerId()), (String)this.getMBeanName());
        }
        catch (Exception e) {
            logger.log(BasicLevel.DEBUG, "unregisterMBean", (Throwable)e);
        }
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public long getReceivedCount() {
        return this.receivedCount;
    }

    @Override
    public long getSentCount() {
        return this.sentCount;
    }

    @Override
    public String getUserName() {
        return this.identity.getUserName();
    }

    @Override
    public void closing() {
    }

    @Override
    public Identity getIdentity() {
        return this.identity;
    }
}

