/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.pool;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.JMSContext;
import org.objectweb.joram.client.jms.pool.ConnectionPool;
import org.objectweb.joram.client.jms.pool.PooledConnection;

public class PooledConnectionFactory
implements javax.jms.ConnectionFactory {
    ConnectionFactory cf;
    ConnectionPool pool;
    int maxFreeConnections;
    int createdCnx = 0;
    int allocatedcnx = 0;
    int freedCnx = 0;
    int maxUsedCnx = 0;

    public ConnectionFactory getConnectionFactory() {
        return this.cf;
    }

    public int getMaxFreeConnections() {
        return this.maxFreeConnections;
    }

    public void setMaxFreeConnections(int maxFreeConnections) {
        this.maxFreeConnections = maxFreeConnections;
    }

    public PooledConnectionFactory(javax.jms.ConnectionFactory cf) {
        this(cf, 10);
    }

    public PooledConnectionFactory(javax.jms.ConnectionFactory cf, int maxFreeConnections) {
        try {
            this.cf = (ConnectionFactory)cf;
            this.maxFreeConnections = maxFreeConnections;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Only Joram ConnectionFactory can be pooled");
        }
    }

    public Connection createConnection() throws JMSException {
        PooledConnectionFactory pooledConnectionFactory = this;
        PooledConnectionFactory pooledConnectionFactory2 = this;
        return this.createConnection(pooledConnectionFactory.cf.getDefaultLogin(), pooledConnectionFactory2.cf.getDefaultPassword());
    }

    public String getStatistics() {
        return "PooledConnectionFactory: " + this.allocatedcnx + " -> " + this.createdCnx + ", max=" + this.maxUsedCnx;
    }

    public synchronized Connection createConnection(String name, String password) throws JMSException {
        if (this.pool == null) {
            this.pool = this.createConnectionPool(this.maxFreeConnections);
        }
        ++this.allocatedcnx;
        PooledConnection cnx = this.pool.alloc(name, password);
        if (cnx == null) {
            ++this.createdCnx;
            cnx = new PooledConnection(this, name, password);
        }
        return cnx;
    }

    synchronized void free(PooledConnection cnx) throws JMSException {
        if (this.allocatedcnx - this.freedCnx > this.maxUsedCnx) {
            this.maxUsedCnx = this.allocatedcnx - this.freedCnx;
        }
        ++this.freedCnx;
        this.pool.free(cnx);
    }

    protected ConnectionPool createConnectionPool(int maxFreeConnections) {
        return new ConnectionPool(maxFreeConnections);
    }

    public javax.jms.JMSContext createContext() {
        try {
            return new JMSContext(this.createConnection());
        }
        catch (JMSSecurityException e) {
            throw new JMSSecurityRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
    }

    public javax.jms.JMSContext createContext(String userName, String password) {
        try {
            return new JMSContext(this.createConnection(userName, password));
        }
        catch (JMSSecurityException e) {
            throw new JMSSecurityRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
    }

    public javax.jms.JMSContext createContext(String userName, String password, int sessionMode) {
        try {
            return new JMSContext(this.createConnection(userName, password), sessionMode);
        }
        catch (JMSSecurityException e) {
            throw new JMSSecurityRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
    }

    public javax.jms.JMSContext createContext(int sessionMode) {
        try {
            return new JMSContext(this.createConnection(), sessionMode);
        }
        catch (JMSSecurityException e) {
            throw new JMSSecurityRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
    }
}

