/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.tcp;

import fr.dyade.aaa.common.Configuration;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.net.SocketFactory;
import fr.dyade.aaa.common.stream.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.Vector;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.tcp.ReliableTcpConnection;
import org.objectweb.joram.shared.client.AbstractJmsMessage;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.joram.shared.stream.MetaData;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ReliableTcpClient {
    private static final Logger logger = Debug.getLogger((String)ReliableTcpClient.class.getName());
    public static final int INIT = 0;
    public static final int CONNECT = 1;
    public static final int CLOSE = 2;
    protected static final String[] statusNames = new String[]{"INIT", "CONNECT", "CLOSE"};
    protected FactoryParameters params;
    protected Identity identity;
    protected int key;
    private ReliableTcpConnection connection;
    private volatile int status;
    private Vector<ServerAddress> addresses;
    private boolean reconnect;
    private int reconnectTimeout = 0;
    private Timer timer;
    public static final String CLOCK_SYNCHRO_THRESHOLD = "org.objectweb.joram.TcpConnection.ClockSynchro.Threshold";
    private long clockSynchroThreshold = Configuration.getLong((String)"org.objectweb.joram.TcpConnection.ClockSynchro.Threshold", (long)this.clockSynchroThreshold);

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void init(FactoryParameters params, Identity identity, boolean reconnect) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "ReliableTcpClient.init(" + params + ',' + identity + ',' + reconnect + ')');
        }
        this.params = params;
        this.reconnect = reconnect;
        if (params.cnxPendingTimer > 0) {
            this.reconnectTimeout = Math.max(3 * params.cnxPendingTimer, params.connectingTimer * 1000 + 2 * params.cnxPendingTimer);
        }
        this.addresses = new Vector();
        this.key = -1;
        this.identity = identity;
        this.setStatus(0);
    }

    private void setStatus(int status) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "ReliableTcpClient[" + this.identity + ',' + this.key + "].setStatus(" + statusNames[status] + ')');
        }
        this.status = status;
    }

    public void connect() throws JMSException {
        this.connect(false);
    }

    public synchronized void connect(boolean reconnect) throws JMSException {
        long startTime;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, "ReliableTcpClient[" + this.identity + ',' + this.key + "].connect(" + reconnect + ')');
        }
        if (this.status != 0) {
            throw new IllegalStateException("Connect: state error");
        }
        long endTime = startTime = System.currentTimeMillis();
        endTime = this.addresses.size() > 1 ? Long.MAX_VALUE : (reconnect ? (endTime += (long)this.reconnectTimeout) : (endTime += (long)this.params.connectingTimer * 1000L));
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, "ReliableTcpClient try during " + (endTime - startTime));
        }
        int attemptsC = 0;
        long nextSleep = 100L;
        while (true) {
            if (this.status == 2) {
                throw new IllegalStateException("Closed connection");
            }
            ++attemptsC;
            for (int i = 0; i < this.addresses.size(); ++i) {
                ServerAddress sa = this.addresses.elementAt(i);
                try {
                    this.doConnect(sa.hostName, sa.port);
                    this.setStatus(1);
                    return;
                }
                catch (JMSSecurityException exc) {
                    throw exc;
                }
                catch (UnknownHostException uhe) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, "ReliableTcpClient.connect", (Throwable)uhe);
                    }
                    IllegalStateException jmsExc = new IllegalStateException("Server's host is unknown: " + sa.hostName);
                    jmsExc.setLinkedException((Exception)uhe);
                    throw jmsExc;
                }
                catch (IOException ioe) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, "ReliableTcpClient.connect", (Throwable)ioe);
                    continue;
                }
                catch (JMSException jmse) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, "ReliableTcpClient.connect", (Throwable)jmse);
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, "ReliableTcpClient.connect", (Throwable)e);
                }
            }
            long currentTime = System.currentTimeMillis();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, " -> currentTime = " + currentTime + ",endTime = " + endTime);
            }
            if (currentTime >= endTime) break;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, " -> retry connection " + this.identity + ',' + this.key);
            }
            if (currentTime + nextSleep > endTime) {
                nextSleep = endTime - currentTime;
            }
            try {
                this.wait(nextSleep);
            }
            catch (InterruptedException intExc) {
                throw new IllegalStateException("Could not open the connection with " + this.addresses + ": interrupted");
            }
            nextSleep *= 2L;
        }
        long attemptsT = (System.currentTimeMillis() - startTime) / 1000L;
        String msg = "Could not connect to JMS server with " + this.addresses + " after " + attemptsC + " attempts during " + attemptsT + " secs.\nServer is not listening or server protocol version is not compatible with client.";
        IllegalStateException jmsExc = new IllegalStateException(msg);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.WARN, " -> Could not connect to JMS server " + this.identity + ',' + this.key, (Throwable)jmsExc);
        } else {
            logger.log(BasicLevel.WARN, " -> Could not connect to JMS server " + this.identity + ',' + this.key + " -> " + jmsExc.getMessage());
        }
        throw jmsExc;
    }

    protected Socket createSocket(String hostname, int port) throws Exception {
        InetAddress addr = InetAddress.getByName(hostname);
        InetAddress outLocalAddr = null;
        String outLocalAddrStr = this.params.outLocalAddress;
        if (outLocalAddrStr != null) {
            outLocalAddr = InetAddress.getByName(outLocalAddrStr);
        }
        int outLocalPort = this.params.outLocalPort;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "ReliableTcpClient[" + this.identity + ',' + this.key + "].createSocket(" + hostname + "," + port + ") on interface " + outLocalAddrStr + ":" + outLocalPort);
        }
        SocketFactory factory = SocketFactory.getFactory((String)this.params.socketFactory);
        Socket socket = factory.createSocket(addr, port, outLocalAddr, outLocalPort, this.params.connectingTimer * 1000);
        return socket;
    }

    private void doConnect(String hostname, int port) throws Exception, JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "ReliableTcpClient[" + this.identity + ',' + this.key + "].doConnect(" + hostname + "," + port + ")");
        }
        Socket socket = this.createSocket(hostname, port);
        try {
            socket.setTcpNoDelay(this.params.TcpNoDelay);
            int timeout = Math.min(this.params.SoTimeout, this.params.connectingTimer * 1000);
            if (timeout <= 0) {
                timeout = Math.max(this.params.SoTimeout, this.params.connectingTimer * 1000);
            }
            if (timeout > 0) {
                socket.setSoTimeout(timeout);
            }
            if (this.params.SoLinger >= 0) {
                socket.setSoLinger(true, this.params.SoLinger);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStream os = socket.getOutputStream();
            InputStream is = socket.getInputStream();
            baos.write(MetaData.joramMagic);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, " -> write noAckedQueue = " + this.params.noAckedQueue);
            }
            StreamUtil.writeTo((boolean)this.params.noAckedQueue, (OutputStream)baos);
            StreamUtil.writeTo((long)System.currentTimeMillis(), (OutputStream)baos);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, " -> write identity = " + this.identity);
            }
            Identity.write((Identity)this.identity, (OutputStream)baos);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, " -> write key = " + this.key);
            }
            StreamUtil.writeTo((int)this.key, (OutputStream)baos);
            if (this.key == -1) {
                int res;
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, " -> TCP connection opened, initializes new connection");
                }
                StreamUtil.writeTo((int)this.reconnectTimeout, (OutputStream)baos);
                baos.writeTo(os);
                os.flush();
                int len = StreamUtil.readIntFrom((InputStream)is);
                long dt = StreamUtil.readLongFrom((InputStream)is);
                if (dt > this.clockSynchroThreshold) {
                    logger.log(BasicLevel.WARN, " -> bad clock synchronization between client and server: " + dt);
                }
                if ((res = StreamUtil.readIntFrom((InputStream)is)) > 0) {
                    String info = StreamUtil.readStringFrom((InputStream)is);
                    this.throwSecurityError(info);
                }
                this.key = StreamUtil.readIntFrom((InputStream)is);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, " -> key = " + this.identity.getUserName() + ',' + this.key);
                }
                this.connection = new ReliableTcpConnection(this.timer, this.params.noAckedQueue);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, " -> init reliable connection");
                }
            } else {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, " -> reinitializes TCP connection " + this.identity + ',' + this.key);
                }
                baos.writeTo(os);
                os.flush();
                int len = StreamUtil.readIntFrom((InputStream)is);
                long dt = StreamUtil.readLongFrom((InputStream)is);
                if (dt > this.clockSynchroThreshold) {
                    logger.log(BasicLevel.WARN, " -> bad clock synchronization between client and server: " + dt);
                }
                int res = StreamUtil.readIntFrom((InputStream)is);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, " -> read res = " + res);
                }
                if (res > 0) {
                    String info = StreamUtil.readStringFrom((InputStream)is);
                    this.throwSecurityError(info);
                }
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, " -> reset reliable connection");
                }
            }
            socket.setSoTimeout(this.params.SoTimeout);
            this.connection.init(socket);
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.WARN, " -> Error during connect, close socket", (Throwable)exc);
            } else {
                logger.log(BasicLevel.WARN, " -> Error during connect, close socket: " + exc.getMessage());
            }
            socket.close();
            throw exc;
        }
    }

    private void throwSecurityError(String info) throws JMSSecurityException {
        JMSSecurityException jmsExc = new JMSSecurityException("Can't open the connection with the server " + this.params.getHost() + " on port " + this.params.getPort() + ": " + info);
        throw jmsExc;
    }

    public void send(AbstractJmsMessage request) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "ReliableTcpClient[" + this.identity + ',' + this.key + "].send(" + request + ')');
        }
        if (this.status == 2) {
            throw new IOException("Closed connection");
        }
        if (this.status != 1) {
            if (this.reconnect) {
                this.waitForReconnection();
            } else {
                throw new IOException("Closed connection");
            }
        }
        while (true) {
            try {
                this.connection.send(request);
                return;
            }
            catch (IOException exc) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, "ReliableTcpClient[" + this.identity + ',' + this.key + "]", (Throwable)exc);
                }
                if (this.reconnect) {
                    this.waitForReconnection();
                    continue;
                }
                this.close();
                throw exc;
            }
            break;
        }
    }

    public Object receive() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "ReliableTcpClient[" + this.identity + ',' + this.key + "].receive()");
        }
        while (true) {
            try {
                return this.connection.receive();
            }
            catch (IOException exc) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, "ReliableTcpClient[" + this.identity + ',' + this.key + "]", (Throwable)exc);
                }
                if (this.reconnect) {
                    this.reconnect();
                    continue;
                }
                this.close();
                throw exc;
            }
            break;
        }
    }

    private synchronized void waitForReconnection() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "ReliableTcpClient[" + this.identity + ',' + this.key + "].waitForReconnection()");
        }
        while (this.status == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        switch (this.status) {
            case 1: {
                break;
            }
            case 2: {
                throw new Exception("Connection closed");
            }
        }
    }

    private synchronized void reconnect() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "ReliableTcpClient[" + this.identity + ',' + this.key + "].reconnect()");
        }
        switch (this.status) {
            case 1: {
                this.setStatus(0);
            }
            case 0: {
                try {
                    this.connect(true);
                    break;
                }
                catch (JMSException exc) {
                    this.close();
                    throw exc;
                }
                finally {
                    this.notifyAll();
                }
            }
            case 2: {
                throw new Exception("Connection closed");
            }
            default: {
                throw new Error("State error");
            }
        }
    }

    public synchronized void close() {
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, "ReliableTcpClient[" + this.identity + ',' + this.key + "].close()");
        }
        if (this.status != 2) {
            this.setStatus(2);
            this.connection.close();
            this.identity = null;
        }
    }

    public void addServerAddress(String host, int port) {
        this.addresses.addElement(new ServerAddress(host, port));
    }

    public String toString() {
        return '(' + super.toString() + ",params=" + this.params + ",name=" + this.identity + ",key=" + this.key + ",connection=" + this.connection + ",status=" + statusNames[this.status] + ",addresses=" + this.addresses + ')';
    }

    public void stopReconnections() {
        this.reconnect = false;
    }

    static class ServerAddress {
        String hostName;
        int port;

        public ServerAddress(String hostName, int port) {
            this.hostName = hostName;
            this.port = port;
        }

        public String toString() {
            return "(hostName=" + this.hostName + ",port=" + this.port + ')';
        }
    }
}

