/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.tcp;

import fr.dyade.aaa.common.Daemon;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.stream.StreamUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import org.objectweb.joram.shared.client.AbstractJmsMessage;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ReliableTcpConnection {
    private static final Logger logger = Debug.getLogger((String)ReliableTcpConnection.class.getName());
    public static final int INIT = 0;
    public static final int CONNECT = 1;
    public static final int CONNECTING = 2;
    private static final String[] statusNames = new String[]{"INIT", "CONNECT", "CONNECTING"};
    public static String WINDOW_SIZE_PROP_NAME = "fr.dyade.aaa.util.ReliableTcpConnection.windowSize";
    public static int DEFAULT_WINDOW_SIZE = 100;
    private int windowSize = Integer.getInteger(WINDOW_SIZE_PROP_NAME, DEFAULT_WINDOW_SIZE);
    private volatile int unackCounter;
    private volatile long inputCounter;
    private long outputCounter;
    private Vector<TcpMessage> pendingMessages;
    private Socket sock;
    private NetOutputStream nos;
    private BufferedInputStream bis;
    private Object inputLock;
    private Object outputLock;
    private int status;
    private Timer timer;
    private boolean noAckedQueue = false;
    private LinkedBlockingQueue<byte[]> receiveQueue;
    private Reader reader;

    public ReliableTcpConnection(Timer timer, boolean noAckedQueue) {
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, "ReliableTcpConnection.windowSize=" + this.windowSize + ", noAckedQueue=" + noAckedQueue);
        }
        this.timer = timer;
        this.inputCounter = -1L;
        this.outputCounter = 0L;
        this.unackCounter = 0;
        this.pendingMessages = new Vector();
        this.inputLock = new Object();
        this.outputLock = new Object();
        this.noAckedQueue = noAckedQueue;
        this.receiveQueue = new LinkedBlockingQueue();
        this.setStatus(0);
    }

    private synchronized void setStatus(int status) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "ReliableTcpConnection.setStatus(" + statusNames[status] + ')');
        }
        this.status = status;
    }

    private final synchronized int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Socket sock) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "ReliableTcpConnection.init()");
        }
        Object object = this;
        synchronized (object) {
            if (this.getStatus() != 0) {
                throw new IOException("Already connected");
            }
            this.setStatus(2);
        }
        try {
            this.sock = sock;
            object = this.outputLock;
            synchronized (object) {
                this.nos = new NetOutputStream(sock);
                if (!this.noAckedQueue) {
                    Vector<TcpMessage> vector = this.pendingMessages;
                    synchronized (vector) {
                        for (int i = 0; i < this.pendingMessages.size(); ++i) {
                            TcpMessage pendingMsg = this.pendingMessages.elementAt(i);
                            this.doSend(pendingMsg.id, this.inputCounter, pendingMsg.object);
                        }
                    }
                }
            }
            object = this.inputLock;
            synchronized (object) {
                this.bis = new BufferedInputStream(sock.getInputStream());
            }
            this.reader = new Reader();
            this.reader.start();
            this.setStatus(1);
        }
        catch (IOException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
            }
            this.close();
            throw exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(AbstractJmsMessage request) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "ReliableTcpConnection.send(" + request + ')');
        }
        if (this.getStatus() != 1) {
            throw new IOException("Connection closed");
        }
        try {
            Object object = this.outputLock;
            synchronized (object) {
                this.doSend(this.outputCounter, this.inputCounter, request);
                if (!this.noAckedQueue) {
                    this.addPendingMessage(new TcpMessage(this.outputCounter, request));
                }
                ++this.outputCounter;
            }
        }
        catch (IOException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "ReliableTcpConnection.send()", (Throwable)exc);
            }
            this.close();
            throw exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(long id, long ackId, AbstractJmsMessage msg) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "ReliableTcpConnection.doSend(" + id + ',' + ackId + ',' + msg + ')');
        }
        Object object = this.outputLock;
        synchronized (object) {
            this.nos.send(id, ackId, msg);
            this.unackCounter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingMessage(TcpMessage msg) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "ReliableTcpConnection.addPendingMessage(" + msg + ')');
        }
        if (!this.noAckedQueue) {
            Vector<TcpMessage> vector = this.pendingMessages;
            synchronized (vector) {
                this.pendingMessages.addElement(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ackPendingMessages(long ackId) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "ReliableTcpConnection.ackPendingMessages(" + ackId + ')');
        }
        if (!this.noAckedQueue) {
            Vector<TcpMessage> vector = this.pendingMessages;
            synchronized (vector) {
                while (this.pendingMessages.size() > 0) {
                    TcpMessage pendingMsg = this.pendingMessages.elementAt(0);
                    if (ackId < pendingMsg.id) break;
                    this.pendingMessages.removeElementAt(0);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public AbstractJmsReply receive() throws Exception {
        if (ReliableTcpConnection.logger.isLoggable(BasicLevel.DEBUG)) {
            ReliableTcpConnection.logger.log(BasicLevel.DEBUG, "ReliableTcpConnection.receive()");
        }
        if (this.getStatus() != 1) {
            throw new IOException("Connection closed");
        }
        try {
            do lbl-1000:
            // 3 sources

            {
                if ((bytes = this.receiveQueue.take()).length == 0) {
                    if (ReliableTcpConnection.logger.isLoggable(BasicLevel.DEBUG)) {
                        ReliableTcpConnection.logger.log(BasicLevel.DEBUG, "The reader offer a closing marker, so closed.");
                    }
                    throw new IOException("Connection closed.");
                }
                bais = new ByteArrayInputStream(bytes);
                messageId = StreamUtil.readLongFrom((InputStream)bais);
                ackId = StreamUtil.readLongFrom((InputStream)bais);
                obj = (AbstractJmsReply)AbstractJmsMessage.read((InputStream)bais);
                if (ReliableTcpConnection.logger.isLoggable(BasicLevel.DEBUG)) {
                    ReliableTcpConnection.logger.log(BasicLevel.DEBUG, " -> id = " + messageId);
                }
                if (this.noAckedQueue) continue;
                this.ackPendingMessages(ackId);
                if (obj == null) ** GOTO lbl-1000
                if (this.unackCounter < this.windowSize) {
                    if (ReliableTcpConnection.logger.isLoggable(BasicLevel.DEBUG)) {
                        ReliableTcpConnection.logger.log(BasicLevel.DEBUG, " -> unackCounter++");
                    }
                    ++this.unackCounter;
                } else {
                    if (ReliableTcpConnection.logger.isLoggable(BasicLevel.DEBUG)) {
                        ReliableTcpConnection.logger.log(BasicLevel.DEBUG, " -> schedule");
                    }
                    ackTimertask = new AckTimerTask();
                    this.timer.schedule((TimerTask)ackTimertask, 0L);
                }
                if (messageId > this.inputCounter) {
                    this.inputCounter = messageId;
                    return obj;
                }
                ReliableTcpConnection.logger.log(BasicLevel.WARN, " -> already received message: " + messageId + " " + obj);
                throw new IOException("Duplicate  message: " + messageId);
            } while (obj == null);
            return obj;
        }
        catch (InterruptedException exc) {
            if (ReliableTcpConnection.logger.isLoggable(BasicLevel.DEBUG)) {
                ReliableTcpConnection.logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
            }
            this.close();
            throw new IllegalStateException("Interrupted receive: Connection closed.");
        }
        catch (IOException exc) {
            if (ReliableTcpConnection.logger.isLoggable(BasicLevel.DEBUG)) {
                ReliableTcpConnection.logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
            }
            this.close();
            throw exc;
        }
    }

    public boolean isReaderRun() {
        return this.reader.isRunning();
    }

    public void close() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "ReliableTcpConnection.close()");
        }
        if (this.getStatus() == 0) {
            return;
        }
        try {
            this.sock.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.reader != null) {
            this.reader.stop();
        }
        this.setStatus(0);
    }

    class Reader
    extends Daemon {
        Reader() {
            super("ReliableTcpConnection.Reader", logger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.running) {
                    this.canStop = true;
                    int len = StreamUtil.readIntFrom((InputStream)ReliableTcpConnection.this.bis);
                    byte[] bytes = new byte[len];
                    int count = 0;
                    int nb = -1;
                    do {
                        if ((nb = ReliableTcpConnection.this.bis.read(bytes, count, len - count)) >= 0) continue;
                        throw new EOFException();
                    } while ((count += nb) != len);
                    ReliableTcpConnection.this.receiveQueue.offer(bytes);
                }
            }
            catch (Exception exc) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
                }
            }
            finally {
                ReliableTcpConnection.this.receiveQueue.offer(new byte[0]);
            }
        }

        public void stop() {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "Reader stop()");
            }
            if (this.isCurrentThread()) {
                this.finish();
            } else {
                super.stop();
            }
        }

        protected void shutdown() {
        }

        protected void close() {
        }
    }

    class AckTimerTask
    extends TimerTask {
        AckTimerTask() {
        }

        @Override
        public void run() {
            block3: {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, "AckTimerTask.run()");
                }
                try {
                    ReliableTcpConnection.this.doSend(-1L, ReliableTcpConnection.this.inputCounter, null);
                    this.cancel();
                }
                catch (IOException exc) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                    logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
                }
            }
        }
    }

    static class TcpMessage {
        long id;
        AbstractJmsMessage object;

        TcpMessage(long id, AbstractJmsMessage object) {
            this.id = id;
            this.object = object;
        }

        public String toString() {
            return '(' + super.toString() + ",id=" + this.id + ",object=" + this.object + ')';
        }
    }

    static class NetOutputStream
    extends ByteArrayOutputStream {
        private OutputStream os = null;

        NetOutputStream(Socket sock) throws IOException {
            super(1024);
            this.reset();
            this.os = sock.getOutputStream();
        }

        @Override
        public synchronized void reset() {
            this.count = 4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void send(long id, long ackId, AbstractJmsMessage msg) throws IOException {
            try {
                StreamUtil.writeTo((long)id, (OutputStream)this);
                StreamUtil.writeTo((long)ackId, (OutputStream)this);
                AbstractJmsMessage.write((AbstractJmsMessage)msg, (OutputStream)this);
                this.buf[0] = (byte)(this.count - 4 >>> 24);
                this.buf[1] = (byte)(this.count - 4 >>> 16);
                this.buf[2] = (byte)(this.count - 4 >>> 8);
                this.buf[3] = (byte)(this.count - 4 >>> 0);
                this.writeTo(this.os);
                this.os.flush();
            }
            finally {
                this.reset();
            }
        }
    }
}

