/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.tcp;

import fr.dyade.aaa.common.Debug;
import java.util.Timer;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.client.jms.tcp.ReliableTcpClient;
import org.objectweb.joram.shared.client.AbstractJmsMessage;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class TcpRequestChannel
implements RequestChannel {
    private static Logger logger = Debug.getLogger((String)TcpRequestChannel.class.getName());
    private ReliableTcpClient tcpClient = null;
    private Identity identity = null;

    public TcpRequestChannel(FactoryParameters params, Identity identity) throws JMSException {
        this(params, identity, "org.objectweb.joram.client.jms.tcp.ReliableTcpClient");
    }

    public TcpRequestChannel(FactoryParameters params, Identity identity, String reliableClass) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "TcpConnection.<init>(" + params + ',' + identity + ',' + reliableClass + ')');
        }
        if (reliableClass == null || reliableClass.equals("") || reliableClass.length() < 1) {
            reliableClass = "org.objectweb.joram.client.jms.tcp.ReliableTcpClient";
        }
        try {
            this.tcpClient = (ReliableTcpClient)Class.forName(reliableClass).newInstance();
        }
        catch (ClassNotFoundException exc) {
            JMSException jmsExc = new JMSException("TcpConnection: ClassNotFoundException : " + reliableClass);
            jmsExc.setLinkedException((Exception)exc);
            throw jmsExc;
        }
        catch (InstantiationException exc) {
            JMSException jmsExc = new JMSException("TcpConnection: InstantiationException : " + reliableClass);
            jmsExc.setLinkedException((Exception)exc);
            throw jmsExc;
        }
        catch (IllegalAccessException exc) {
            JMSException jmsExc = new JMSException("TcpConnection: IllegalAccessException : " + reliableClass);
            jmsExc.setLinkedException((Exception)exc);
            throw jmsExc;
        }
        this.tcpClient.init(params, identity, params.cnxPendingTimer > 0);
        this.tcpClient.addServerAddress(params.getHost(), params.getPort());
        this.identity = identity;
    }

    @Override
    public void setTimer(Timer timer) {
        this.tcpClient.setTimer(timer);
    }

    @Override
    public void connect() throws Exception {
        this.tcpClient.connect();
    }

    @Override
    public synchronized void send(AbstractJmsRequest request) throws Exception {
        this.tcpClient.send((AbstractJmsMessage)request);
    }

    @Override
    public AbstractJmsReply receive() throws Exception {
        return (AbstractJmsReply)this.tcpClient.receive();
    }

    @Override
    public void close() {
        this.tcpClient.close();
    }

    public String toString() {
        return '(' + super.toString() + ",tcpClient=" + this.tcpClient + ')';
    }

    @Override
    public void closing() {
        this.tcpClient.stopReconnections();
    }

    @Override
    public Identity getIdentity() {
        return this.identity;
    }
}

