/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.texttablefmt;

import org.nocrala.tools.utils.Filler;

public class CellStyle {
    private static final HorizontalAlign DEFAULT_HORIZONTAL_ALIGN = HorizontalAlign.left;
    private static final AbbreviationStyle DEFAULT_ABBREVIATION_STYLE = AbbreviationStyle.dots;
    private static final NullStyle DEFAULT_NULL_STYLE = NullStyle.emptyString;
    private static final String NULL_TEXT = "<null>";
    private static final String DOTS_TEXT = "...";
    private HorizontalAlign horAlign;
    private AbbreviationStyle abbStyle;
    private NullStyle nullStyle;

    public CellStyle() {
        this.initialize(DEFAULT_HORIZONTAL_ALIGN, DEFAULT_ABBREVIATION_STYLE, DEFAULT_NULL_STYLE);
    }

    public CellStyle(HorizontalAlign horAlign) {
        this.initialize(horAlign, DEFAULT_ABBREVIATION_STYLE, DEFAULT_NULL_STYLE);
    }

    public CellStyle(HorizontalAlign horAlign, AbbreviationStyle abbStyle) {
        this.initialize(horAlign, abbStyle, DEFAULT_NULL_STYLE);
    }

    public CellStyle(HorizontalAlign horAlign, AbbreviationStyle abbStyle, NullStyle nullStyle) {
        this.initialize(horAlign, abbStyle, nullStyle);
    }

    private void initialize(HorizontalAlign horAlign, AbbreviationStyle abbStyle, NullStyle nullStyle) {
        this.horAlign = horAlign;
        this.abbStyle = abbStyle;
        this.nullStyle = nullStyle;
    }

    private String renderUnformattedText(String txt) {
        if (txt == null) {
            if (NullStyle.emptyString.equals((Object)this.nullStyle)) {
                return "";
            }
            return NULL_TEXT;
        }
        return txt;
    }

    public int getWidth(String txt) {
        return this.renderUnformattedText(txt).length();
    }

    public String render(String txt, int width) {
        String plainText = this.renderUnformattedText(txt);
        if (plainText.length() < width) {
            switch (this.horAlign) {
                case left: {
                    return this.alignLeft(plainText, width);
                }
                case center: {
                    return this.alignCenter(plainText, width);
                }
            }
            return this.alignRight(plainText, width);
        }
        if (plainText.length() == width) {
            return plainText;
        }
        switch (this.abbStyle) {
            case crop: {
                return this.abbreviateCrop(plainText, width);
            }
        }
        return this.abbreviateDots(plainText, width);
    }

    private String alignLeft(String txt, int width) {
        int diff = width - txt.length();
        return txt + Filler.getFiller(diff);
    }

    private String alignCenter(String txt, int width) {
        int diff = width - txt.length();
        int diffLeft = diff / 2;
        int diffRight = diff - diffLeft;
        return Filler.getFiller(diffLeft) + txt + Filler.getFiller(diffRight);
    }

    private String alignRight(String txt, int width) {
        int diff = width - txt.length();
        return Filler.getFiller(diff) + txt;
    }

    private String abbreviateCrop(String txt, int width) {
        return txt.substring(0, width);
    }

    private String abbreviateDots(String txt, int width) {
        if (width < 1) {
            return "";
        }
        if (width <= DOTS_TEXT.length()) {
            return DOTS_TEXT.substring(0, width);
        }
        return txt.substring(0, width - DOTS_TEXT.length()) + DOTS_TEXT;
    }

    static String renderNullCell(int width) {
        return Filler.getFiller(width);
    }

    public static enum NullStyle {
        emptyString,
        nullText;

    }

    public static enum AbbreviationStyle {
        crop,
        dots;

    }

    public static enum HorizontalAlign {
        left,
        center,
        right;

    }
}

