/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.config.properties;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.owasp.csrfguard.config.properties.SimpleBooleanConfigParameter;
import org.owasp.csrfguard.config.properties.SimpleDurationParameter;
import org.owasp.csrfguard.config.properties.SimpleIntConfigParameter;

public final class ConfigParameters {
    public static final SimpleBooleanConfigParameter ROTATE = new SimpleBooleanConfigParameter("org.owasp.csrfguard.Rotate", false);
    public static final SimpleBooleanConfigParameter TOKEN_PER_PAGE = new SimpleBooleanConfigParameter("org.owasp.csrfguard.TokenPerPage", false);
    public static final SimpleBooleanConfigParameter VALIDATE_WHEN_NO_SESSION_EXISTS = new SimpleBooleanConfigParameter("org.owasp.csrfguard.ValidateWhenNoSessionExists", true);
    public static final SimpleBooleanConfigParameter TOKEN_PER_PAGE_PRECREATE = new SimpleBooleanConfigParameter("org.owasp.csrfguard.TokenPerPagePrecreate", false);
    public static final SimpleBooleanConfigParameter PRINT_ENABLED = new SimpleBooleanConfigParameter("org.owasp.csrfguard.Config.Print", false);
    public static final SimpleBooleanConfigParameter CSRFGUARD_ENABLED = new SimpleBooleanConfigParameter("org.owasp.csrfguard.Enabled", true);
    public static final SimpleBooleanConfigParameter AJAX_ENABLED = new SimpleBooleanConfigParameter("org.owasp.csrfguard.Ajax", false);
    public static final SimpleBooleanConfigParameter CSRFGUARD_PROTECT = new SimpleBooleanConfigParameter("org.owasp.csrfguard.Protect", false);
    public static final SimpleBooleanConfigParameter FORCE_SYNCHRONOUS_AJAX = new SimpleBooleanConfigParameter("org.owasp.csrfguard.forceSynchronousAjax", false);
    public static final SimpleIntConfigParameter TOKEN_LENGTH = new SimpleIntConfigParameter("org.owasp.csrfguard.TokenLength", 32);
    public static final SimpleDurationParameter PAGE_TOKEN_SYNCHRONIZATION_TOLERANCE = new SimpleDurationParameter("org.owasp.csrfguard.PageTokenSynchronizationTolerance", Duration.of(2L, ChronoUnit.SECONDS));
    public static final Pair<String, String> TOKEN_NAME = Pair.of((Object)"org.owasp.csrfguard.TokenName", (Object)"OWASP-CSRFGUARD");
    public static final Pair<String, String> DOMAIN_ORIGIN = Pair.of((Object)"org.owasp.csrfguard.domainOrigin", null);
    public static final Pair<String, String> DEFAULT_PRNG = Pair.of((Object)"SUN", (Object)"SHA1PRNG");
    public static final Pair<String, String> PRNG = Pair.of((Object)"org.owasp.csrfguard.PRNG", (Object)((String)DEFAULT_PRNG.getValue()));
    public static final Pair<String, String> PRNG_PROVIDER = Pair.of((Object)"org.owasp.csrfguard.PRNG.Provider", (Object)((String)DEFAULT_PRNG.getKey()));
    public static final Pair<String, String> TOKEN_HOLDER = Pair.of((Object)"org.owasp.csrfguard.TokenHolder", (Object)"org.owasp.csrfguard.token.storage.impl.InMemoryTokenHolder");
    public static final String LOGICAL_SESSION_EXTRACTOR_NAME = "org.owasp.csrfguard.LogicalSessionExtractor";
    public static final String NEW_TOKEN_LANDING_PAGE = "org.owasp.csrfguard.NewTokenLandingPage";
    public static final String UNPROTECTED_METHODS = "org.owasp.csrfguard.UnprotectedMethods";
    public static final String PROTECTED_METHODS = "org.owasp.csrfguard.ProtectedMethods";
    public static final String CONFIG_OVERLAY_HIERARCHY_PROPERTY_NAME = "org.owasp.csrfguard.configOverlay.hierarchy";
    public static final String CONFIG_OVERLAY_UPDATE_CHECK_PROPERTY_NAME = "org.owasp.csrfguard.configOverlay.secondsBetweenUpdateChecks";
    public static final String CONFIG_PROVIDER_FACTORY_PROPERTY_NAME = "org.owasp.csrfguard.configuration.provider.factory";
    public static final String ACTION_PREFIX = "org.owasp.csrfguard.action.";
    public static final String ACTION_ATTRIBUTE_NAME = "AttributeName";
    public static final String PROTECTED_PAGE_PREFIX = "org.owasp.csrfguard.protected.";
    public static final String UNPROTECTED_PAGE_PREFIX = "org.owasp.csrfguard.unprotected.";
    public static final String BANNED_USER_AGENT_PROPERTIES_PREFIX = "org.owasp.csrfguard.bannedUserAgentProperty.";

    private ConfigParameters() {
    }

    public static SimpleBooleanConfigParameter getUseNewTokenLandingPage(String newTokenLandingPage) {
        String newTokenLandingPagePropertyName = "org.owasp.csrfguard.UseNewTokenLandingPage";
        return new SimpleBooleanConfigParameter("org.owasp.csrfguard.UseNewTokenLandingPage", newTokenLandingPage != null);
    }
}

