/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.http;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.util.Objects;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.CsrfValidator;
import org.owasp.csrfguard.ProtectionResult;
import org.owasp.csrfguard.session.LogicalSession;
import org.owasp.csrfguard.token.service.TokenService;

public class InterceptRedirectResponse
extends HttpServletResponseWrapper {
    private final HttpServletResponse response;
    private final CsrfGuard csrfGuard;
    private final HttpServletRequest request;

    public InterceptRedirectResponse(HttpServletResponse response, HttpServletRequest request, CsrfGuard csrfGuard) {
        super(response);
        this.response = response;
        this.request = request;
        this.csrfGuard = csrfGuard;
    }

    public void sendRedirect(String location) throws IOException {
        String sanitizedLocation = location.replaceAll("(\\r|\\n|%0D|%0A|%0a|%0d)", "");
        ProtectionResult protectionResult = new CsrfValidator().isProtectedPageAndMethod(sanitizedLocation, "GET");
        if (!sanitizedLocation.contains("://") && protectionResult.isProtected()) {
            String[] splitOnFragment = location.split("#", 2);
            StringBuilder stringBuilder = new StringBuilder();
            if (sanitizedLocation.startsWith("/")) {
                stringBuilder.append(sanitizedLocation);
            } else {
                stringBuilder.append(this.request.getContextPath()).append('/').append(sanitizedLocation);
            }
            if (sanitizedLocation.contains("?")) {
                stringBuilder.append('&');
            } else {
                stringBuilder.append('?');
            }
            String locationUri = sanitizedLocation.split("\\?", 2)[0];
            stringBuilder.append(this.csrfGuard.getTokenName()).append('=').append(this.computeTokenValue(locationUri));
            if (splitOnFragment.length > 1) {
                stringBuilder.append('#').append(splitOnFragment[1]);
            }
            this.response.sendRedirect(stringBuilder.toString());
        } else {
            this.response.sendRedirect(sanitizedLocation);
        }
    }

    private String computeTokenValue(String locationUri) {
        TokenService tokenService = CsrfGuard.getInstance().getTokenService();
        LogicalSession logicalSession = this.csrfGuard.getLogicalSessionExtractor().extract(this.request);
        return Objects.nonNull(logicalSession) ? tokenService.generateTokensIfAbsent(logicalSession.getKey(), "GET", locationUri) : null;
    }
}

