/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.Resources;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.agent.DependencyCheckScanAgent;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.exception.ReportException;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.taskdefs.RetirejsFilter;
import org.owasp.dependencycheck.taskdefs.SuppressionFile;
import org.owasp.dependencycheck.taskdefs.Update;
import org.slf4j.impl.StaticLoggerBinder;

@NotThreadSafe
public class Check
extends Update {
    private Boolean rubygemsAnalyzerEnabled;
    private Boolean nodeAnalyzerEnabled;
    private Boolean nodeAuditAnalyzerEnabled;
    private Boolean retireJsAnalyzerEnabled;
    private List<String> retirejsFilters = new ArrayList<String>();
    private Boolean retirejsFilterNonVulnerable;
    private Boolean bundleAuditAnalyzerEnabled;
    private Boolean cmakeAnalyzerEnabled;
    private Boolean opensslAnalyzerEnabled;
    private Boolean pyPackageAnalyzerEnabled;
    private Boolean pyDistributionAnalyzerEnabled;
    private Boolean centralAnalyzerEnabled;
    private Boolean nexusAnalyzerEnabled;
    private String nexusUrl;
    private String nexusUser;
    private String nexusPassword;
    private Boolean nexusUsesProxy;
    private String zipExtensions;
    private String pathToMono;
    private String projectName = "dependency-check";
    private String reportOutputDirectory = ".";
    private float failBuildOnCVSS = 11.0f;
    private Boolean autoUpdate;
    private String reportFormat = "HTML";
    private String suppressionFile = null;
    private List<String> suppressionFiles = new ArrayList<String>();
    private String hintsFile;
    private boolean showSummary = true;
    private Boolean enableExperimental;
    private Boolean enableRetired;
    private Boolean jarAnalyzerEnabled;
    private Boolean archiveAnalyzerEnabled;
    private Boolean nuspecAnalyzerEnabled;
    private Boolean nugetconfAnalyzerEnabled;
    private Boolean composerAnalyzerEnabled;
    private Boolean assemblyAnalyzerEnabled;
    private Boolean autoconfAnalyzerEnabled;
    private String bundleAuditPath;
    private Boolean cocoapodsAnalyzerEnabled;
    private Boolean swiftPackageManagerAnalyzerEnabled;
    private Boolean artifactoryAnalyzerEnabled;
    private String artifactoryAnalyzerUrl;
    private Boolean artifactoryAnalyzerUseProxy;
    private Boolean artifactoryAnalyzerParallelAnalysis;
    private String artifactoryAnalyzerUsername;
    private String artifactoryAnalyzerApiToken;
    private String artifactoryAnalyzerBearerToken;
    private Resources path = null;
    private Reference refId = null;

    public void add(ResourceCollection rc) {
        if (this.isReference()) {
            throw new BuildException("Nested elements are not allowed when using the refId attribute.");
        }
        this.getPath().add(rc);
    }

    public void addConfiguredSuppressionFile(SuppressionFile suppressionFile) {
        this.suppressionFiles.add(suppressionFile.getPath());
    }

    private synchronized Resources getPath() {
        if (this.path == null) {
            this.path = new Resources(this.getProject());
            this.path.setCache(true);
        }
        return this.path;
    }

    public boolean isReference() {
        return this.refId != null;
    }

    public synchronized void setRefId(Reference r) {
        if (this.path != null) {
            throw new BuildException("Nested elements are not allowed when using the refId attribute.");
        }
        this.refId = r;
    }

    private void dealWithReferences() throws BuildException {
        if (this.isReference()) {
            Object o = this.refId.getReferencedObject(this.getProject());
            if (!(o instanceof ResourceCollection)) {
                throw new BuildException("refId '" + this.refId.getRefId() + "' does not refer to a resource collection.");
            }
            this.getPath().add((ResourceCollection)o);
        }
    }

    public Check() {
        StaticLoggerBinder.getSingleton().setTask(this);
    }

    public String getProjectName() {
        if (this.projectName == null) {
            this.projectName = "";
        }
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(String reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
    }

    public float getFailBuildOnCVSS() {
        return this.failBuildOnCVSS;
    }

    public void setFailBuildOnCVSS(float failBuildOnCVSS) {
        this.failBuildOnCVSS = failBuildOnCVSS;
    }

    public Boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(Boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(ReportFormats reportFormat) {
        this.reportFormat = reportFormat.getValue();
    }

    public List<String> getSuppressionFiles() {
        return this.suppressionFiles;
    }

    public void setSuppressionFile(String suppressionFile) {
        this.suppressionFile = suppressionFile;
        this.suppressionFiles.add(suppressionFile);
    }

    public String getHintsFile() {
        return this.hintsFile;
    }

    public void setHintsFile(String hintsFile) {
        this.hintsFile = hintsFile;
    }

    public boolean isShowSummary() {
        return this.showSummary;
    }

    public void setShowSummary(boolean showSummary) {
        this.showSummary = showSummary;
    }

    public Boolean isEnableExperimental() {
        return this.enableExperimental;
    }

    public void setEnableExperimental(Boolean enableExperimental) {
        this.enableExperimental = enableExperimental;
    }

    public Boolean isEnableRetired() {
        return this.enableRetired;
    }

    public void setEnableRetired(Boolean enableRetired) {
        this.enableRetired = enableRetired;
    }

    public Boolean isJarAnalyzerEnabled() {
        return this.jarAnalyzerEnabled;
    }

    public void setJarAnalyzerEnabled(Boolean jarAnalyzerEnabled) {
        this.jarAnalyzerEnabled = jarAnalyzerEnabled;
    }

    public Boolean isArchiveAnalyzerEnabled() {
        return this.archiveAnalyzerEnabled;
    }

    public void setArchiveAnalyzerEnabled(Boolean archiveAnalyzerEnabled) {
        this.archiveAnalyzerEnabled = archiveAnalyzerEnabled;
    }

    public Boolean isAssemblyAnalyzerEnabled() {
        return this.assemblyAnalyzerEnabled;
    }

    public void setAssemblyAnalyzerEnabled(Boolean assemblyAnalyzerEnabled) {
        this.assemblyAnalyzerEnabled = assemblyAnalyzerEnabled;
    }

    public Boolean isNuspecAnalyzerEnabled() {
        return this.nuspecAnalyzerEnabled;
    }

    public Boolean isNugetconfAnalyzerEnabled() {
        return this.nugetconfAnalyzerEnabled;
    }

    public void setNuspecAnalyzerEnabled(Boolean nuspecAnalyzerEnabled) {
        this.nuspecAnalyzerEnabled = nuspecAnalyzerEnabled;
    }

    public void setNugetconfAnalyzerEnabled(Boolean nugetconfAnalyzerEnabled) {
        this.nugetconfAnalyzerEnabled = nugetconfAnalyzerEnabled;
    }

    public Boolean isComposerAnalyzerEnabled() {
        return this.composerAnalyzerEnabled;
    }

    public void setComposerAnalyzerEnabled(Boolean composerAnalyzerEnabled) {
        this.composerAnalyzerEnabled = composerAnalyzerEnabled;
    }

    public Boolean isAutoconfAnalyzerEnabled() {
        return this.autoconfAnalyzerEnabled;
    }

    public void setAutoconfAnalyzerEnabled(Boolean autoconfAnalyzerEnabled) {
        this.autoconfAnalyzerEnabled = autoconfAnalyzerEnabled;
    }

    public Boolean isCMakeAnalyzerEnabled() {
        return this.cmakeAnalyzerEnabled;
    }

    public void setCMakeAnalyzerEnabled(Boolean cmakeAnalyzerEnabled) {
        this.cmakeAnalyzerEnabled = cmakeAnalyzerEnabled;
    }

    public Boolean isBundleAuditAnalyzerEnabled() {
        return this.bundleAuditAnalyzerEnabled;
    }

    public void setBundleAuditAnalyzerEnabled(Boolean bundleAuditAnalyzerEnabled) {
        this.bundleAuditAnalyzerEnabled = bundleAuditAnalyzerEnabled;
    }

    public String getBundleAuditPath() {
        return this.bundleAuditPath;
    }

    public void setBundleAuditPath(String bundleAuditPath) {
        this.bundleAuditPath = bundleAuditPath;
    }

    public boolean isCocoapodsAnalyzerEnabled() {
        return this.cocoapodsAnalyzerEnabled;
    }

    public void setCocoapodsAnalyzerEnabled(Boolean cocoapodsAnalyzerEnabled) {
        this.cocoapodsAnalyzerEnabled = cocoapodsAnalyzerEnabled;
    }

    public Boolean isSwiftPackageManagerAnalyzerEnabled() {
        return this.swiftPackageManagerAnalyzerEnabled;
    }

    public void setSwiftPackageManagerAnalyzerEnabled(Boolean swiftPackageManagerAnalyzerEnabled) {
        this.swiftPackageManagerAnalyzerEnabled = swiftPackageManagerAnalyzerEnabled;
    }

    public Boolean isOpensslAnalyzerEnabled() {
        return this.opensslAnalyzerEnabled;
    }

    public void setOpensslAnalyzerEnabled(Boolean opensslAnalyzerEnabled) {
        this.opensslAnalyzerEnabled = opensslAnalyzerEnabled;
    }

    public Boolean isNodeAnalyzerEnabled() {
        return this.nodeAnalyzerEnabled;
    }

    public void setNodeAnalyzerEnabled(Boolean nodeAnalyzerEnabled) {
        this.nodeAnalyzerEnabled = nodeAnalyzerEnabled;
    }

    @Deprecated
    public Boolean isNspAnalyzerEnabled() {
        this.log("The NspAnalyzerEnabled configuration has been deprecated and replaced by NodeAuditAnalyzerEnabled", 0);
        this.log("The NspAnalyzerEnabled configuration will be removed in the next major release");
        return this.nodeAnalyzerEnabled;
    }

    @Deprecated
    public void setNspAnalyzerEnabled(Boolean nodeAnalyzerEnabled) {
        this.log("The NspAnalyzerEnabled configuration has been deprecated and replaced by NodeAuditAnalyzerEnabled", 0);
        this.log("The NspAnalyzerEnabled configuration will be removed in the next major release");
        this.nodeAnalyzerEnabled = nodeAnalyzerEnabled;
    }

    public Boolean isNodeAuditAnalyzerEnabled() {
        return this.nodeAuditAnalyzerEnabled;
    }

    public void setNodeAuditAnalyzerEnabled(Boolean nodeAuditAnalyzerEnabled) {
        this.nodeAuditAnalyzerEnabled = nodeAuditAnalyzerEnabled;
    }

    public Boolean isRetireJsAnalyzerEnabled() {
        return this.retireJsAnalyzerEnabled;
    }

    public void setRetireJsAnalyzerEnabled(Boolean retireJsAnalyzerEnabled) {
        this.retireJsAnalyzerEnabled = retireJsAnalyzerEnabled;
    }

    public Boolean isRetirejsFilterNonVulnerable() {
        return this.retirejsFilterNonVulnerable;
    }

    public void setRetirejsFilterNonVulnerable(Boolean retirejsFilterNonVulnerable) {
        this.retirejsFilterNonVulnerable = retirejsFilterNonVulnerable;
    }

    public List<String> getRetirejsFilters() {
        return this.retirejsFilters;
    }

    public void addConfiguredRetirejsFilter(RetirejsFilter retirejsFilter) {
        this.retirejsFilters.add(retirejsFilter.getRegex());
    }

    public Boolean isRubygemsAnalyzerEnabled() {
        return this.rubygemsAnalyzerEnabled;
    }

    public void setRubygemsAnalyzerEnabled(Boolean rubygemsAnalyzerEnabled) {
        this.rubygemsAnalyzerEnabled = rubygemsAnalyzerEnabled;
    }

    public Boolean isPyPackageAnalyzerEnabled() {
        return this.pyPackageAnalyzerEnabled;
    }

    public void setPyPackageAnalyzerEnabled(Boolean pyPackageAnalyzerEnabled) {
        this.pyPackageAnalyzerEnabled = pyPackageAnalyzerEnabled;
    }

    public Boolean isPyDistributionAnalyzerEnabled() {
        return this.pyDistributionAnalyzerEnabled;
    }

    public void setPyDistributionAnalyzerEnabled(Boolean pyDistributionAnalyzerEnabled) {
        this.pyDistributionAnalyzerEnabled = pyDistributionAnalyzerEnabled;
    }

    public Boolean isCentralAnalyzerEnabled() {
        return this.centralAnalyzerEnabled;
    }

    public void setCentralAnalyzerEnabled(Boolean centralAnalyzerEnabled) {
        this.centralAnalyzerEnabled = centralAnalyzerEnabled;
    }

    public Boolean isNexusAnalyzerEnabled() {
        return this.nexusAnalyzerEnabled;
    }

    public void setNexusAnalyzerEnabled(Boolean nexusAnalyzerEnabled) {
        this.nexusAnalyzerEnabled = nexusAnalyzerEnabled;
    }

    public String getNexusUrl() {
        return this.nexusUrl;
    }

    public void setNexusUrl(String nexusUrl) {
        this.nexusUrl = nexusUrl;
    }

    public String getNexusUser() {
        return this.nexusUser;
    }

    public void setNexusUser(String nexusUser) {
        this.nexusUser = nexusUser;
    }

    public String getNexusPassword() {
        return this.nexusPassword;
    }

    public void setNexusPassword(String nexusPassword) {
        this.nexusPassword = nexusPassword;
    }

    public Boolean isNexusUsesProxy() {
        return this.nexusUsesProxy;
    }

    public void setNexusUsesProxy(Boolean nexusUsesProxy) {
        this.nexusUsesProxy = nexusUsesProxy;
    }

    public String getZipExtensions() {
        return this.zipExtensions;
    }

    public void setZipExtensions(String zipExtensions) {
        this.zipExtensions = zipExtensions;
    }

    public String getPathToMono() {
        return this.pathToMono;
    }

    public void setPathToMono(String pathToMono) {
        this.pathToMono = pathToMono;
    }

    public Boolean getCmakeAnalyzerEnabled() {
        return this.cmakeAnalyzerEnabled;
    }

    public void setCmakeAnalyzerEnabled(Boolean cmakeAnalyzerEnabled) {
        this.cmakeAnalyzerEnabled = cmakeAnalyzerEnabled;
    }

    public Boolean getArtifactoryAnalyzerEnabled() {
        return this.artifactoryAnalyzerEnabled;
    }

    public void setArtifactoryAnalyzerEnabled(Boolean artifactoryAnalyzerEnabled) {
        this.artifactoryAnalyzerEnabled = artifactoryAnalyzerEnabled;
    }

    public String getArtifactoryAnalyzerUrl() {
        return this.artifactoryAnalyzerUrl;
    }

    public void setArtifactoryAnalyzerUrl(String artifactoryAnalyzerUrl) {
        this.artifactoryAnalyzerUrl = artifactoryAnalyzerUrl;
    }

    public Boolean getArtifactoryAnalyzerUseProxy() {
        return this.artifactoryAnalyzerUseProxy;
    }

    public void setArtifactoryAnalyzerUseProxy(Boolean artifactoryAnalyzerUseProxy) {
        this.artifactoryAnalyzerUseProxy = artifactoryAnalyzerUseProxy;
    }

    public Boolean getArtifactoryAnalyzerParallelAnalysis() {
        return this.artifactoryAnalyzerParallelAnalysis;
    }

    public void setArtifactoryAnalyzerParallelAnalysis(Boolean artifactoryAnalyzerParallelAnalysis) {
        this.artifactoryAnalyzerParallelAnalysis = artifactoryAnalyzerParallelAnalysis;
    }

    public String getArtifactoryAnalyzerUsername() {
        return this.artifactoryAnalyzerUsername;
    }

    public void setArtifactoryAnalyzerUsername(String artifactoryAnalyzerUsername) {
        this.artifactoryAnalyzerUsername = artifactoryAnalyzerUsername;
    }

    public String getArtifactoryAnalyzerApiToken() {
        return this.artifactoryAnalyzerApiToken;
    }

    public void setArtifactoryAnalyzerApiToken(String artifactoryAnalyzerApiToken) {
        this.artifactoryAnalyzerApiToken = artifactoryAnalyzerApiToken;
    }

    public String getArtifactoryAnalyzerBearerToken() {
        return this.artifactoryAnalyzerBearerToken;
    }

    public void setArtifactoryAnalyzerBearerToken(String artifactoryAnalyzerBearerToken) {
        this.artifactoryAnalyzerBearerToken = artifactoryAnalyzerBearerToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        this.dealWithReferences();
        this.validateConfiguration();
        this.populateSettings();
        try (Engine engine = new Engine(Check.class.getClassLoader(), this.getSettings());){
            block25: {
                for (Resource resource : this.getPath()) {
                    File file;
                    FileProvider provider = (FileProvider)resource.as(FileProvider.class);
                    if (provider == null || (file = provider.getFile()) == null || !file.exists()) continue;
                    engine.scan(file);
                }
                try {
                    engine.analyzeDependencies();
                }
                catch (ExceptionCollection ex) {
                    if (!this.isFailOnError()) break block25;
                    throw new BuildException((Throwable)ex);
                }
            }
            engine.writeReports(this.getProjectName(), new File(this.reportOutputDirectory), this.reportFormat);
            if (this.failBuildOnCVSS <= 10.0f) {
                this.checkForFailure(engine.getDependencies());
            }
            if (this.showSummary) {
                DependencyCheckScanAgent.showSummary((Dependency[])engine.getDependencies());
            }
        }
        catch (DatabaseException ex) {
            String msg = "Unable to connect to the dependency-check database; analysis has stopped";
            if (this.isFailOnError()) {
                throw new BuildException("Unable to connect to the dependency-check database; analysis has stopped", (Throwable)ex);
            }
            this.log("Unable to connect to the dependency-check database; analysis has stopped", ex, 0);
        }
        catch (ReportException ex) {
            String msg = "Unable to generate the dependency-check report";
            if (this.isFailOnError()) {
                throw new BuildException("Unable to generate the dependency-check report", (Throwable)ex);
            }
            this.log("Unable to generate the dependency-check report", ex, 0);
        }
        finally {
            this.getSettings().cleanup();
        }
    }

    private synchronized void validateConfiguration() throws BuildException {
        if (this.path == null) {
            throw new BuildException("No project dependencies have been defined to analyze.");
        }
        if (this.failBuildOnCVSS < 0.0f || this.failBuildOnCVSS > 11.0f) {
            throw new BuildException("Invalid configuration, failBuildOnCVSS must be between 0 and 11.");
        }
    }

    @Override
    protected void populateSettings() throws BuildException {
        super.populateSettings();
        this.getSettings().setBooleanIfNotNull("autoupdate", this.autoUpdate);
        this.getSettings().setArrayIfNotEmpty("suppression.file", this.suppressionFiles);
        this.getSettings().setStringIfNotEmpty("hints.file", this.hintsFile);
        this.getSettings().setBooleanIfNotNull("analyzer.experimental.enabled", this.enableExperimental);
        this.getSettings().setBooleanIfNotNull("analyzer.retired.enabled", this.enableRetired);
        this.getSettings().setBooleanIfNotNull("analyzer.jar.enabled", this.jarAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.python.distribution.enabled", this.pyDistributionAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.python.package.enabled", this.pyPackageAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.ruby.gemspec.enabled", this.rubygemsAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.openssl.enabled", this.opensslAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.cmake.enabled", this.cmakeAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.artifactory.enabled", this.artifactoryAnalyzerEnabled);
        this.getSettings().setStringIfNotEmpty("analyzer.artifactory.url", this.artifactoryAnalyzerUrl);
        this.getSettings().setBooleanIfNotNull("analyzer.artifactory.proxy", this.artifactoryAnalyzerUseProxy);
        this.getSettings().setBooleanIfNotNull("analyzer.artifactory.parallel.analysis", this.artifactoryAnalyzerParallelAnalysis);
        this.getSettings().setStringIfNotEmpty("analyzer.artifactory.api.username", this.artifactoryAnalyzerUsername);
        this.getSettings().setStringIfNotEmpty("analyzer.artifactory.api.token", this.artifactoryAnalyzerApiToken);
        this.getSettings().setStringIfNotEmpty("analyzer.artifactory.bearer.token", this.artifactoryAnalyzerBearerToken);
        this.getSettings().setBooleanIfNotNull("analyzer.swift.package.manager.enabled", this.swiftPackageManagerAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.cocoapods.enabled", this.cocoapodsAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.bundle.audit.enabled", this.bundleAuditAnalyzerEnabled);
        this.getSettings().setStringIfNotNull("analyzer.bundle.audit.path", this.bundleAuditPath);
        this.getSettings().setBooleanIfNotNull("analyzer.autoconf.enabled", this.autoconfAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.composer.lock.enabled", this.composerAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.node.package.enabled", this.nodeAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.node.audit.enabled", this.nodeAuditAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.retirejs.enabled", this.retireJsAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.retirejs.filternonvulnerable", this.retirejsFilterNonVulnerable);
        this.getSettings().setArrayIfNotEmpty("analyzer.retirejs.filters", this.retirejsFilters);
        this.getSettings().setBooleanIfNotNull("analyzer.nuspec.enabled", this.nuspecAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.nugetconf.enabled", this.nugetconfAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.central.enabled", this.centralAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.nexus.enabled", this.nexusAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.archive.enabled", this.archiveAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.assembly.enabled", this.assemblyAnalyzerEnabled);
        this.getSettings().setStringIfNotEmpty("analyzer.nexus.url", this.nexusUrl);
        this.getSettings().setStringIfNotEmpty("analyzer.nexus.username", this.nexusUser);
        this.getSettings().setStringIfNotEmpty("analyzer.nexus.password", this.nexusPassword);
        this.getSettings().setBooleanIfNotNull("analyzer.nexus.proxy", this.nexusUsesProxy);
        this.getSettings().setStringIfNotEmpty("extensions.zip", this.zipExtensions);
        this.getSettings().setStringIfNotEmpty("analyzer.assembly.mono.path", this.pathToMono);
    }

    private void checkForFailure(Dependency[] dependencies) throws BuildException {
        StringBuilder ids = new StringBuilder();
        for (Dependency d : dependencies) {
            for (Vulnerability v : d.getVulnerabilities()) {
                if (!(v.getCvssV2().getScore() >= this.failBuildOnCVSS)) continue;
                if (ids.length() == 0) {
                    ids.append(v.getName());
                    continue;
                }
                ids.append(", ").append(v.getName());
            }
        }
        if (ids.length() > 0) {
            String msg = this.showSummary ? String.format("%n%nDependency-Check Failure:%nOne or more dependencies were identified with vulnerabilities that have a CVSS score greater than or equal to '%.1f': %s%nSee the dependency-check report for more details.%n%n", Float.valueOf(this.failBuildOnCVSS), ids.toString()) : String.format("%n%nDependency-Check Failure:%nOne or more dependencies were identified with vulnerabilities.%n%nSee the dependency-check report for more details.%n%n", new Object[0]);
            throw new BuildException(msg);
        }
    }

    public static class ReportFormats
    extends EnumeratedAttribute {
        public String[] getValues() {
            int i = 0;
            ReportGenerator.Format[] formats = ReportGenerator.Format.values();
            String[] values = new String[formats.length];
            for (ReportGenerator.Format format : formats) {
                values[i++] = format.name();
            }
            return values;
        }
    }
}

