/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.paypal.PayPalProfile;
import org.pac4j.oauth.profile.paypal.PayPalProfileDefinition;
import org.pac4j.scribe.builder.api.PayPalApi20;

public class PayPalClient
extends OAuth20Client<PayPalProfile> {
    public static final String DEFAULT_SCOPE = "openid profile email address";
    protected String scope = "openid profile email address";

    public PayPalClient() {
    }

    public PayPalClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"scope", (String)this.scope);
        this.configuration.setApi(new PayPalApi20());
        this.configuration.setProfileDefinition(new PayPalProfileDefinition());
        this.configuration.setScope(this.scope);
        this.configuration.setHasGrantType(true);
        this.configuration.setTokenAsHeader(true);
        this.setConfiguration(this.configuration);
        this.defaultLogoutActionBuilder((ctx, profile, targetUrl) -> RedirectAction.redirect((String)"https://www.paypal.com/myaccount/logout"));
        super.clientInit(context);
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

