/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.strava.StravaProfile;
import org.pac4j.oauth.profile.strava.StravaProfileDefinition;
import org.pac4j.scribe.builder.api.StravaApi20;

public class StravaClient
extends OAuth20Client<StravaProfile> {
    protected String scope = null;
    private String approvalPrompt = "auto";

    public StravaClient() {
    }

    public StravaClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit(WebContext context) {
        this.configuration.setApi(new StravaApi20(this.approvalPrompt));
        this.configuration.setProfileDefinition(new StravaProfileDefinition());
        this.configuration.setScope(this.scope);
        this.setConfiguration(this.configuration);
        this.defaultLogoutActionBuilder((ctx, profile, targetUrl) -> RedirectAction.redirect((String)"https://www.strava.com/session"));
        super.clientInit(context);
    }

    public String getApprovalPrompt() {
        return this.approvalPrompt;
    }

    public void setApprovalPrompt(String approvalPrompt) {
        this.approvalPrompt = approvalPrompt;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

