/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.scribe.builder.api;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;
import java.util.Map;

public class WindowsLiveApi20
extends DefaultApi20 {
    private static final String AUTHORIZE_URL = "https://login.live.com/oauth20_authorize.srf?client_id=%s&redirect_uri=%s&response_type=code";
    private static final String SCOPED_AUTHORIZE_URL = "https://login.live.com/oauth20_authorize.srf?client_id=%s&redirect_uri=%s&response_type=code&scope=%s";

    public String getAccessTokenEndpoint() {
        return "https://login.live.com/oauth20_token.srf";
    }

    public String getAuthorizationUrl(OAuthConfig config, Map<String, String> additionalParams) {
        Preconditions.checkValidUrl((String)config.getCallback(), (String)"Must provide a valid url as callback. Live does not support OOB");
        if (config.getScope() != null) {
            return String.format(SCOPED_AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()), OAuthEncoder.encode((String)config.getScope()));
        }
        return String.format(AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()));
    }

    protected String getAuthorizationBaseUrl() {
        return "https://login.live.com/oauth20_authorize.srf";
    }
}

