/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.config;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import org.pac4j.core.client.config.BaseClientConfiguration;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.generator.RandomValueGenerator;
import org.pac4j.core.util.generator.ValueGenerator;
import org.pac4j.oidc.config.PrivateKeyJWTClientAuthnMethodConfig;
import org.pac4j.oidc.exceptions.OidcConfigurationException;
import org.pac4j.oidc.metadata.OidcOpMetadataResolver;
import org.pac4j.oidc.util.SessionStoreValueRetriever;
import org.pac4j.oidc.util.ValueRetriever;

public class OidcConfiguration
extends BaseClientConfiguration {
    public static final String SCOPE = "scope";
    public static final String CUSTOM_PARAMS = "custom_params";
    public static final String RESPONSE_TYPE = "response_type";
    public static final String RESPONSE_MODE = "response_mode";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String CLIENT_ID = "client_id";
    public static final String STATE = "state";
    public static final String MAX_AGE = "max_age";
    public static final String PROMPT = "prompt";
    public static final String NONCE = "nonce";
    public static final String CODE_CHALLENGE = "code_challenge";
    public static final String CODE_CHALLENGE_METHOD = "code_challenge_method";
    public static final List<ResponseType> AUTHORIZATION_CODE_FLOWS = List.of(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}));
    public static final List<ResponseType> IMPLICIT_FLOWS = Collections.unmodifiableList(Arrays.asList(new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.ID_TOKEN}), new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.ID_TOKEN, ResponseType.Value.TOKEN})));
    public static final List<ResponseType> HYBRID_CODE_FLOWS = Collections.unmodifiableList(Arrays.asList(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE, OIDCResponseTypeValue.ID_TOKEN}), new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE, ResponseType.Value.TOKEN}), new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE, OIDCResponseTypeValue.ID_TOKEN, ResponseType.Value.TOKEN})));
    public static final int DEFAULT_MAX_CLOCK_SKEW = 30;
    public static final int DEFAULT_TOKEN_EXPIRATION_ADVANCE = 0;
    private String clientId;
    private String secret;
    private String discoveryURI;
    private String scope;
    private Map<String, String> customParams = new HashMap<String, String>();
    private ClientAuthenticationMethod clientAuthenticationMethod;
    private Set<ClientAuthenticationMethod> supportedClientAuthenticationMethods;
    private PrivateKeyJWTClientAuthnMethodConfig privateKeyJWTClientAuthnMethodConfig;
    private boolean useNonce;
    private boolean disablePkce = false;
    private CodeChallengeMethod pkceMethod;
    private JWSAlgorithm preferredJwsAlgorithm;
    private Integer maxAge;
    private int maxClockSkew = 30;
    private ResourceRetriever resourceRetriever;
    private ResponseType responseType = AUTHORIZATION_CODE_FLOWS.get(0);
    private String responseMode;
    private String logoutUrl;
    private int connectTimeout = 500;
    private int readTimeout = 5000;
    private boolean withState = true;
    private Map<String, String> mappedClaims = new LinkedHashMap<String, String>();
    private ValueGenerator stateGenerator = new RandomValueGenerator();
    private ValueGenerator codeVerifierGenerator = new RandomValueGenerator(50);
    private ValueRetriever valueRetriever = new SessionStoreValueRetriever();
    private boolean expireSessionWithToken = true;
    private int tokenExpirationAdvance = 0;
    private boolean allowUnsignedIdTokens;
    private boolean includeAccessTokenClaimsInProfile = false;
    private SSLSocketFactory sslSocketFactory;
    private boolean callUserInfoEndpoint = true;
    private HostnameVerifier hostnameVerifier;
    protected OidcOpMetadataResolver opMetadataResolver;

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"clientId", (String)this.getClientId());
        if (!(AUTHORIZATION_CODE_FLOWS.contains(this.responseType) || IMPLICIT_FLOWS.contains(this.responseType) || HYBRID_CODE_FLOWS.contains(this.responseType))) {
            throw new OidcConfigurationException("Unsupported responseType: " + this.responseType);
        }
        if (!IMPLICIT_FLOWS.contains(this.responseType) && this.isDisablePkce()) {
            CommonHelper.assertNotBlank((String)"secret", (String)this.getSecret());
        }
        if (this.getDiscoveryURI() == null && this.getOpMetadataResolver() == null) {
            throw new OidcConfigurationException("You must define either the discovery URL or directly the provider metadata resolver");
        }
        if (forceReinit || this.getResourceRetriever() == null) {
            try {
                this.setResourceRetriever((ResourceRetriever)(this.sslSocketFactory == null ? new DefaultResourceRetriever(this.getConnectTimeout(), this.getReadTimeout()) : new DefaultResourceRetriever(this.getConnectTimeout(), this.getReadTimeout(), 0, false, this.sslSocketFactory)));
            }
            catch (Exception e) {
                throw new OidcConfigurationException("SSLFactory loaded fail, please check your configuration");
            }
        }
        if (forceReinit || this.getOpMetadataResolver() == null) {
            CommonHelper.assertNotBlank((String)"discoveryURI", (String)this.getDiscoveryURI());
            this.opMetadataResolver = new OidcOpMetadataResolver(this);
        }
    }

    public void setDiscoveryURIIfUndefined(String discoveryURI) {
        if (this.discoveryURI == null) {
            this.discoveryURI = discoveryURI;
        }
    }

    public String getCustomParam(String name) {
        return this.customParams.get(name);
    }

    public void setCustomParams(Map<String, String> customParams) {
        CommonHelper.assertNotNull((String)"customParams", customParams);
        this.customParams = customParams;
    }

    public void addCustomParam(String key, String value) {
        this.customParams.put(key, value);
    }

    public void setClientAuthenticationMethodAsString(String auth) {
        this.clientAuthenticationMethod = ClientAuthenticationMethod.parse((String)auth);
    }

    public void setSupportedClientAuthenticationMethods(Set<ClientAuthenticationMethod> supportedClientAuthenticationMethods) {
        this.supportedClientAuthenticationMethods = supportedClientAuthenticationMethods;
    }

    public CodeChallengeMethod findPkceMethod() {
        this.init();
        if (this.isDisablePkce()) {
            return null;
        }
        if (this.getPkceMethod() == null) {
            OIDCProviderMetadata opMetadataResolver = (OIDCProviderMetadata)this.getOpMetadataResolver().load();
            List methods = opMetadataResolver.getCodeChallengeMethods();
            if (methods == null || methods.isEmpty()) {
                return null;
            }
            if (methods.contains(CodeChallengeMethod.S256)) {
                return CodeChallengeMethod.S256;
            }
            return (CodeChallengeMethod)methods.get(0);
        }
        return this.getPkceMethod();
    }

    public void setPreferredJwsAlgorithmAsString(String preferredJwsAlgorithm) {
        this.preferredJwsAlgorithm = JWSAlgorithm.parse((String)preferredJwsAlgorithm);
    }

    public void configureHttpRequest(HTTPRequest request) {
        request.setConnectTimeout(this.getConnectTimeout());
        request.setReadTimeout(this.getReadTimeout());
        request.setSSLSocketFactory(this.sslSocketFactory);
        request.setHostnameVerifier(this.hostnameVerifier);
    }

    public ResourceRetriever findResourceRetriever() {
        this.init();
        return this.resourceRetriever;
    }

    public void setResponseType(String responseType) {
        try {
            this.responseType = ResponseType.parse((String)responseType);
        }
        catch (ParseException e) {
            throw new OidcConfigurationException("Unrecognised responseType: " + responseType, e);
        }
    }

    public String findLogoutUrl() {
        this.init();
        OIDCProviderMetadata opMetadataResolver = (OIDCProviderMetadata)this.getOpMetadataResolver().load();
        if (this.logoutUrl == null && opMetadataResolver.getEndSessionEndpointURI() != null) {
            return opMetadataResolver.getEndSessionEndpointURI().toString();
        }
        return this.logoutUrl;
    }

    public int getTokenExpirationAdvance() {
        return this.isExpireSessionWithToken() ? this.tokenExpirationAdvance : -1;
    }

    public void setStateGenerator(ValueGenerator stateGenerator) {
        CommonHelper.assertNotNull((String)"stateGenerator", (Object)stateGenerator);
        this.stateGenerator = stateGenerator;
    }

    public void setCodeVerifierGenerator(ValueGenerator codeVerifierGenerator) {
        CommonHelper.assertNotNull((String)"codeVerifierGenerator", (Object)codeVerifierGenerator);
        this.codeVerifierGenerator = codeVerifierGenerator;
    }

    public void setValueRetriever(ValueRetriever valueRetriever) {
        CommonHelper.assertNotNull((String)"valueRetriever", (Object)valueRetriever);
        this.valueRetriever = valueRetriever;
    }

    public String getResponseType() {
        return this.responseType.toString();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSecret() {
        return this.secret;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDiscoveryURI() {
        return this.discoveryURI;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScope() {
        return this.scope;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, String> getCustomParams() {
        return this.customParams;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientAuthenticationMethod getClientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<ClientAuthenticationMethod> getSupportedClientAuthenticationMethods() {
        return this.supportedClientAuthenticationMethods;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PrivateKeyJWTClientAuthnMethodConfig getPrivateKeyJWTClientAuthnMethodConfig() {
        return this.privateKeyJWTClientAuthnMethodConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isUseNonce() {
        return this.useNonce;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isDisablePkce() {
        return this.disablePkce;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CodeChallengeMethod getPkceMethod() {
        return this.pkceMethod;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JWSAlgorithm getPreferredJwsAlgorithm() {
        return this.preferredJwsAlgorithm;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getMaxAge() {
        return this.maxAge;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxClockSkew() {
        return this.maxClockSkew;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ResourceRetriever getResourceRetriever() {
        return this.resourceRetriever;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getResponseMode() {
        return this.responseMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isWithState() {
        return this.withState;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, String> getMappedClaims() {
        return this.mappedClaims;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ValueGenerator getStateGenerator() {
        return this.stateGenerator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ValueGenerator getCodeVerifierGenerator() {
        return this.codeVerifierGenerator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ValueRetriever getValueRetriever() {
        return this.valueRetriever;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isExpireSessionWithToken() {
        return this.expireSessionWithToken;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAllowUnsignedIdTokens() {
        return this.allowUnsignedIdTokens;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isIncludeAccessTokenClaimsInProfile() {
        return this.includeAccessTokenClaimsInProfile;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isCallUserInfoEndpoint() {
        return this.callUserInfoEndpoint;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcOpMetadataResolver getOpMetadataResolver() {
        return this.opMetadataResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setSecret(String secret) {
        this.secret = secret;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setDiscoveryURI(String discoveryURI) {
        this.discoveryURI = discoveryURI;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setScope(String scope) {
        this.scope = scope;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setClientAuthenticationMethod(ClientAuthenticationMethod clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setPrivateKeyJWTClientAuthnMethodConfig(PrivateKeyJWTClientAuthnMethodConfig privateKeyJWTClientAuthnMethodConfig) {
        this.privateKeyJWTClientAuthnMethodConfig = privateKeyJWTClientAuthnMethodConfig;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setUseNonce(boolean useNonce) {
        this.useNonce = useNonce;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setDisablePkce(boolean disablePkce) {
        this.disablePkce = disablePkce;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setPkceMethod(CodeChallengeMethod pkceMethod) {
        this.pkceMethod = pkceMethod;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setPreferredJwsAlgorithm(JWSAlgorithm preferredJwsAlgorithm) {
        this.preferredJwsAlgorithm = preferredJwsAlgorithm;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setMaxClockSkew(int maxClockSkew) {
        this.maxClockSkew = maxClockSkew;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setResourceRetriever(ResourceRetriever resourceRetriever) {
        this.resourceRetriever = resourceRetriever;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setResponseMode(String responseMode) {
        this.responseMode = responseMode;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setWithState(boolean withState) {
        this.withState = withState;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setMappedClaims(Map<String, String> mappedClaims) {
        this.mappedClaims = mappedClaims;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setExpireSessionWithToken(boolean expireSessionWithToken) {
        this.expireSessionWithToken = expireSessionWithToken;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setTokenExpirationAdvance(int tokenExpirationAdvance) {
        this.tokenExpirationAdvance = tokenExpirationAdvance;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setAllowUnsignedIdTokens(boolean allowUnsignedIdTokens) {
        this.allowUnsignedIdTokens = allowUnsignedIdTokens;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setIncludeAccessTokenClaimsInProfile(boolean includeAccessTokenClaimsInProfile) {
        this.includeAccessTokenClaimsInProfile = includeAccessTokenClaimsInProfile;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setCallUserInfoEndpoint(boolean callUserInfoEndpoint) {
        this.callUserInfoEndpoint = callUserInfoEndpoint;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration setOpMetadataResolver(OidcOpMetadataResolver opMetadataResolver) {
        this.opMetadataResolver = opMetadataResolver;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "OidcConfiguration(clientId=" + this.clientId + ", discoveryURI=" + this.discoveryURI + ", scope=" + this.scope + ", customParams=" + this.customParams + ", clientAuthenticationMethod=" + this.clientAuthenticationMethod + ", supportedClientAuthenticationMethods=" + this.supportedClientAuthenticationMethods + ", privateKeyJWTClientAuthnMethodConfig=" + this.privateKeyJWTClientAuthnMethodConfig + ", useNonce=" + this.useNonce + ", disablePkce=" + this.disablePkce + ", pkceMethod=" + this.pkceMethod + ", preferredJwsAlgorithm=" + this.preferredJwsAlgorithm + ", maxAge=" + this.maxAge + ", maxClockSkew=" + this.maxClockSkew + ", resourceRetriever=" + this.resourceRetriever + ", responseType=" + this.responseType + ", responseMode=" + this.responseMode + ", logoutUrl=" + this.logoutUrl + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", withState=" + this.withState + ", mappedClaims=" + this.mappedClaims + ", stateGenerator=" + this.stateGenerator + ", codeVerifierGenerator=" + this.codeVerifierGenerator + ", valueRetriever=" + this.valueRetriever + ", expireSessionWithToken=" + this.expireSessionWithToken + ", tokenExpirationAdvance=" + this.tokenExpirationAdvance + ", allowUnsignedIdTokens=" + this.allowUnsignedIdTokens + ", includeAccessTokenClaimsInProfile=" + this.includeAccessTokenClaimsInProfile + ", sslSocketFactory=" + this.sslSocketFactory + ", callUserInfoEndpoint=" + this.callUserInfoEndpoint + ", hostnameVerifier=" + this.hostnameVerifier + ", opMetadataResolver=" + this.opMetadataResolver + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withClientId(String clientId) {
        return this.clientId == clientId ? this : new OidcConfiguration(clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withSecret(String secret) {
        return this.secret == secret ? this : new OidcConfiguration(this.clientId, secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withDiscoveryURI(String discoveryURI) {
        return this.discoveryURI == discoveryURI ? this : new OidcConfiguration(this.clientId, this.secret, discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withScope(String scope) {
        return this.scope == scope ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withCustomParams(Map<String, String> customParams) {
        return this.customParams == customParams ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withClientAuthenticationMethod(ClientAuthenticationMethod clientAuthenticationMethod) {
        return this.clientAuthenticationMethod == clientAuthenticationMethod ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withSupportedClientAuthenticationMethods(Set<ClientAuthenticationMethod> supportedClientAuthenticationMethods) {
        return this.supportedClientAuthenticationMethods == supportedClientAuthenticationMethods ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withPrivateKeyJWTClientAuthnMethodConfig(PrivateKeyJWTClientAuthnMethodConfig privateKeyJWTClientAuthnMethodConfig) {
        return this.privateKeyJWTClientAuthnMethodConfig == privateKeyJWTClientAuthnMethodConfig ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withUseNonce(boolean useNonce) {
        return this.useNonce == useNonce ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withDisablePkce(boolean disablePkce) {
        return this.disablePkce == disablePkce ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withPkceMethod(CodeChallengeMethod pkceMethod) {
        return this.pkceMethod == pkceMethod ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withPreferredJwsAlgorithm(JWSAlgorithm preferredJwsAlgorithm) {
        return this.preferredJwsAlgorithm == preferredJwsAlgorithm ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withMaxAge(Integer maxAge) {
        return this.maxAge == maxAge ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withMaxClockSkew(int maxClockSkew) {
        return this.maxClockSkew == maxClockSkew ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withResourceRetriever(ResourceRetriever resourceRetriever) {
        return this.resourceRetriever == resourceRetriever ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withResponseType(ResponseType responseType) {
        return this.responseType == responseType ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withResponseMode(String responseMode) {
        return this.responseMode == responseMode ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withLogoutUrl(String logoutUrl) {
        return this.logoutUrl == logoutUrl ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withConnectTimeout(int connectTimeout) {
        return this.connectTimeout == connectTimeout ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withReadTimeout(int readTimeout) {
        return this.readTimeout == readTimeout ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withWithState(boolean withState) {
        return this.withState == withState ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withMappedClaims(Map<String, String> mappedClaims) {
        return this.mappedClaims == mappedClaims ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withStateGenerator(ValueGenerator stateGenerator) {
        return this.stateGenerator == stateGenerator ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withCodeVerifierGenerator(ValueGenerator codeVerifierGenerator) {
        return this.codeVerifierGenerator == codeVerifierGenerator ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withValueRetriever(ValueRetriever valueRetriever) {
        return this.valueRetriever == valueRetriever ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withExpireSessionWithToken(boolean expireSessionWithToken) {
        return this.expireSessionWithToken == expireSessionWithToken ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withTokenExpirationAdvance(int tokenExpirationAdvance) {
        return this.tokenExpirationAdvance == tokenExpirationAdvance ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withAllowUnsignedIdTokens(boolean allowUnsignedIdTokens) {
        return this.allowUnsignedIdTokens == allowUnsignedIdTokens ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withIncludeAccessTokenClaimsInProfile(boolean includeAccessTokenClaimsInProfile) {
        return this.includeAccessTokenClaimsInProfile == includeAccessTokenClaimsInProfile ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        return this.sslSocketFactory == sslSocketFactory ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withCallUserInfoEndpoint(boolean callUserInfoEndpoint) {
        return this.callUserInfoEndpoint == callUserInfoEndpoint ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, callUserInfoEndpoint, this.hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withHostnameVerifier(HostnameVerifier hostnameVerifier) {
        return this.hostnameVerifier == hostnameVerifier ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, hostnameVerifier, this.opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration withOpMetadataResolver(OidcOpMetadataResolver opMetadataResolver) {
        return this.opMetadataResolver == opMetadataResolver ? this : new OidcConfiguration(this.clientId, this.secret, this.discoveryURI, this.scope, this.customParams, this.clientAuthenticationMethod, this.supportedClientAuthenticationMethods, this.privateKeyJWTClientAuthnMethodConfig, this.useNonce, this.disablePkce, this.pkceMethod, this.preferredJwsAlgorithm, this.maxAge, this.maxClockSkew, this.resourceRetriever, this.responseType, this.responseMode, this.logoutUrl, this.connectTimeout, this.readTimeout, this.withState, this.mappedClaims, this.stateGenerator, this.codeVerifierGenerator, this.valueRetriever, this.expireSessionWithToken, this.tokenExpirationAdvance, this.allowUnsignedIdTokens, this.includeAccessTokenClaimsInProfile, this.sslSocketFactory, this.callUserInfoEndpoint, this.hostnameVerifier, opMetadataResolver);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration(String clientId, String secret, String discoveryURI, String scope, Map<String, String> customParams, ClientAuthenticationMethod clientAuthenticationMethod, Set<ClientAuthenticationMethod> supportedClientAuthenticationMethods, PrivateKeyJWTClientAuthnMethodConfig privateKeyJWTClientAuthnMethodConfig, boolean useNonce, boolean disablePkce, CodeChallengeMethod pkceMethod, JWSAlgorithm preferredJwsAlgorithm, Integer maxAge, int maxClockSkew, ResourceRetriever resourceRetriever, ResponseType responseType, String responseMode, String logoutUrl, int connectTimeout, int readTimeout, boolean withState, Map<String, String> mappedClaims, ValueGenerator stateGenerator, ValueGenerator codeVerifierGenerator, ValueRetriever valueRetriever, boolean expireSessionWithToken, int tokenExpirationAdvance, boolean allowUnsignedIdTokens, boolean includeAccessTokenClaimsInProfile, SSLSocketFactory sslSocketFactory, boolean callUserInfoEndpoint, HostnameVerifier hostnameVerifier, OidcOpMetadataResolver opMetadataResolver) {
        this.clientId = clientId;
        this.secret = secret;
        this.discoveryURI = discoveryURI;
        this.scope = scope;
        this.customParams = customParams;
        this.clientAuthenticationMethod = clientAuthenticationMethod;
        this.supportedClientAuthenticationMethods = supportedClientAuthenticationMethods;
        this.privateKeyJWTClientAuthnMethodConfig = privateKeyJWTClientAuthnMethodConfig;
        this.useNonce = useNonce;
        this.disablePkce = disablePkce;
        this.pkceMethod = pkceMethod;
        this.preferredJwsAlgorithm = preferredJwsAlgorithm;
        this.maxAge = maxAge;
        this.maxClockSkew = maxClockSkew;
        this.resourceRetriever = resourceRetriever;
        this.responseType = responseType;
        this.responseMode = responseMode;
        this.logoutUrl = logoutUrl;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.withState = withState;
        this.mappedClaims = mappedClaims;
        this.stateGenerator = stateGenerator;
        this.codeVerifierGenerator = codeVerifierGenerator;
        this.valueRetriever = valueRetriever;
        this.expireSessionWithToken = expireSessionWithToken;
        this.tokenExpirationAdvance = tokenExpirationAdvance;
        this.allowUnsignedIdTokens = allowUnsignedIdTokens;
        this.includeAccessTokenClaimsInProfile = includeAccessTokenClaimsInProfile;
        this.sslSocketFactory = sslSocketFactory;
        this.callUserInfoEndpoint = callUserInfoEndpoint;
        this.hostnameVerifier = hostnameVerifier;
        this.opMetadataResolver = opMetadataResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcConfiguration() {
    }
}

