/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.logout;

import com.nimbusds.jwt.JWT;
import com.nimbusds.openid.connect.sdk.LogoutRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.ForbiddenAction;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.http.ajax.AjaxRequestResolver;
import org.pac4j.core.http.ajax.DefaultAjaxRequestResolver;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.exceptions.OidcException;
import org.pac4j.oidc.profile.OidcProfile;

public class OidcLogoutActionBuilder
implements LogoutActionBuilder {
    protected OidcConfiguration configuration;
    private AjaxRequestResolver ajaxRequestResolver = new DefaultAjaxRequestResolver();

    public OidcLogoutActionBuilder(OidcConfiguration configuration) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
    }

    public Optional<RedirectionAction> getLogoutAction(CallContext ctx, UserProfile currentProfile, String targetUrl) {
        String logoutUrl = this.configuration.findLogoutUrl();
        if (CommonHelper.isNotBlank((String)logoutUrl) && currentProfile instanceof OidcProfile) {
            try {
                URI endSessionEndpoint = new URI(logoutUrl);
                JWT idToken = ((OidcProfile)currentProfile).getIdToken();
                LogoutRequest logoutRequest = CommonHelper.isNotBlank((String)targetUrl) ? new LogoutRequest(endSessionEndpoint, idToken, new URI(targetUrl), null) : new LogoutRequest(endSessionEndpoint, idToken);
                WebContext webContext = ctx.webContext();
                if (this.ajaxRequestResolver.isAjax(ctx)) {
                    ctx.sessionStore().set(webContext, "pac4jRequestedUrl", null);
                    webContext.setResponseHeader("Location", logoutRequest.toURI().toString());
                    throw new ForbiddenAction();
                }
                return Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)webContext, (String)logoutRequest.toURI().toString()));
            }
            catch (URISyntaxException e) {
                throw new OidcException(e);
            }
        }
        return Optional.empty();
    }

    public AjaxRequestResolver getAjaxRequestResolver() {
        return this.ajaxRequestResolver;
    }

    public void setAjaxRequestResolver(AjaxRequestResolver ajaxRequestResolver) {
        CommonHelper.assertNotNull((String)"ajaxRequestResolver", (Object)ajaxRequestResolver);
        this.ajaxRequestResolver = ajaxRequestResolver;
    }
}

