/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.transport;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.HTMLEncoder;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.ComponentSupport;
import net.shibboleth.shared.component.DestructableComponent;
import net.shibboleth.shared.component.InitializableComponent;
import net.shibboleth.shared.xml.SerializeSupport;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.AbstractMessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.BindingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.pac4j.saml.transport.Pac4jSAMLResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Pac4jHTTPPostEncoder
extends AbstractMessageEncoder {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Pac4jHTTPPostEncoder.class);
    public static final String DEFAULT_TEMPLATE_ID = "/templates/saml2-post-binding.vm";
    private final Pac4jSAMLResponse responseAdapter;
    private VelocityEngine velocityEngine;
    private String velocityTemplateId;

    public Pac4jHTTPPostEncoder(Pac4jSAMLResponse responseAdapter) {
        this.responseAdapter = responseAdapter;
        this.setVelocityTemplateId(DEFAULT_TEMPLATE_ID);
    }

    protected void doDestroy() {
        this.velocityEngine = null;
        this.velocityTemplateId = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        LOGGER.debug("Initialized {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        if (this.velocityEngine == null) {
            throw new ComponentInitializationException("VelocityEngine must be supplied");
        }
        if (this.velocityTemplateId == null) {
            throw new ComponentInitializationException("Velocity template id must be supplied");
        }
    }

    protected void doEncode() throws MessageEncodingException {
        MessageContext messageContext = this.getMessageContext();
        SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
        if (outboundMessage == null) {
            throw new MessageEncodingException("No outbound SAML message contained in message context");
        }
        String endpointURL = this.getEndpointURL(messageContext).toString();
        this.postEncode(messageContext, endpointURL);
    }

    protected URI getEndpointURL(MessageContext messageContext) throws MessageEncodingException {
        try {
            return SAMLBindingSupport.getEndpointURL((MessageContext)messageContext);
        }
        catch (BindingException e) {
            throw new MessageEncodingException("Could not obtain message endpoint URL", (Exception)((Object)e));
        }
    }

    protected void postEncode(MessageContext messageContext, String endpointURL) throws MessageEncodingException {
        LOGGER.debug("Invoking Velocity template to create POST body");
        try {
            VelocityContext velocityContext = new VelocityContext();
            this.populateVelocityContext(velocityContext, messageContext, endpointURL);
            this.responseAdapter.setContentType("text/html");
            this.responseAdapter.init();
            OutputStreamWriter out = this.responseAdapter.getOutputStreamWriter();
            this.getVelocityEngine().mergeTemplate(this.getVelocityTemplateId(), "UTF-8", (Context)velocityContext, (Writer)out);
            out.flush();
        }
        catch (Exception e) {
            throw new MessageEncodingException("Error creating output document", e);
        }
    }

    public String getVelocityTemplateId() {
        return this.velocityTemplateId;
    }

    public void setVelocityTemplateId(String newVelocityTemplateId) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.velocityTemplateId = newVelocityTemplateId;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine newVelocityEngine) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.velocityEngine = newVelocityEngine;
    }

    protected void populateVelocityContext(VelocityContext velocityContext, MessageContext messageContext, String endpointURL) throws MessageEncodingException {
        String encodedMessage;
        String encodedEndpointURL = HTMLEncoder.encodeForHTMLAttribute((String)endpointURL);
        LOGGER.debug("Encoding action url of '{}' with encoded value '{}'", (Object)endpointURL, (Object)encodedEndpointURL);
        velocityContext.put("action", (Object)encodedEndpointURL);
        velocityContext.put("binding", (Object)this.getBindingURI());
        SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
        LOGGER.debug("Marshalling and Base64 encoding SAML message");
        Element domMessage = this.marshallMessage((XMLObject)outboundMessage);
        String messageXML = SerializeSupport.nodeToString((Node)domMessage);
        LOGGER.trace("Output XML message: {}", (Object)messageXML);
        try {
            encodedMessage = Base64Support.encode((byte[])messageXML.getBytes(StandardCharsets.UTF_8), (boolean)false);
        }
        catch (Exception e) {
            throw new MessageEncodingException(e);
        }
        if (outboundMessage instanceof RequestAbstractType) {
            velocityContext.put("SAMLRequest", (Object)encodedMessage);
        } else if (outboundMessage instanceof StatusResponseType) {
            velocityContext.put("SAMLResponse", (Object)encodedMessage);
        } else {
            throw new MessageEncodingException("SAML message is neither a SAML RequestAbstractType or StatusResponseType");
        }
        String relayState = SAMLBindingSupport.getRelayState((MessageContext)messageContext);
        if (SAMLBindingSupport.checkRelayState((String)relayState)) {
            String encodedRelayState = HTMLEncoder.encodeForHTMLAttribute((String)relayState);
            LOGGER.debug("Setting RelayState parameter to: '{}', encoded as '{}'", (Object)relayState, (Object)encodedRelayState);
            velocityContext.put("RelayState", (Object)encodedRelayState);
        }
    }

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    }

    protected Element marshallMessage(XMLObject message) throws MessageEncodingException {
        LOGGER.debug("Marshalling message");
        try {
            return XMLObjectSupport.marshall((XMLObject)message);
        }
        catch (MarshallingException e) {
            throw new MessageEncodingException("Error marshalling message", (Exception)((Object)e));
        }
    }
}

