/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.writer.FilterCodeWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingCodeWriter
extends FilterCodeWriter {
    private Logger logger = LoggerFactory.getLogger(LoggingCodeWriter.class);
    private boolean verbose;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public LoggingCodeWriter(CodeWriter output, Logger logger, boolean verbose) {
        super(output);
        this.setLogger(logger);
        this.setVerbose(verbose);
    }

    public Writer openSource(JPackage pkg, String fileName) throws IOException {
        if (this.isVerbose()) {
            if (pkg.isUnnamed()) {
                this.getLogger().info("XJC writing: " + fileName);
            } else {
                this.getLogger().info("XJC writing: " + pkg.name().replace('.', File.separatorChar) + File.separatorChar + fileName);
            }
        }
        return this.core.openSource(pkg, fileName);
    }

    public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
        if (this.isVerbose()) {
            if (pkg.isUnnamed()) {
                this.getLogger().info("XJC writing: " + fileName);
            } else {
                this.getLogger().info("XJC writing: " + pkg.name().replace('.', File.separatorChar) + File.separatorChar + fileName);
            }
        }
        return this.core.openBinary(pkg, fileName);
    }

    public void close() throws IOException {
        this.core.close();
    }
}

