/*
 * Decompiled with CFR 0.152.
 */
package pitest.fasterxml.jackson.databind.ext;

import java.io.IOException;
import java.nio.file.Path;
import pitest.fasterxml.jackson.core.JsonGenerator;
import pitest.fasterxml.jackson.core.JsonToken;
import pitest.fasterxml.jackson.core.type.WritableTypeId;
import pitest.fasterxml.jackson.databind.SerializerProvider;
import pitest.fasterxml.jackson.databind.jsontype.TypeSerializer;
import pitest.fasterxml.jackson.databind.ser.std.StdScalarSerializer;

public class NioPathSerializer
extends StdScalarSerializer<Path> {
    private static final long serialVersionUID = 1L;

    public NioPathSerializer() {
        super(Path.class);
    }

    @Override
    public void serialize(Path value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeString(value.toUri().toString());
    }

    @Override
    public void serializeWithType(Path value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId((Object)value, Path.class, JsonToken.VALUE_STRING));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }
}

