/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classinfo;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.pitest.classinfo.BridgeMethodFilter;
import org.pitest.classinfo.ClassIdentifier;
import org.pitest.classinfo.ClassInfoBuilder;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.InfoMethodVisitor;
import org.pitest.functional.F5;

public final class ClassInfoVisitor
extends ClassVisitor {
    private final F5<Integer, String, String, String, String[], Boolean> filter = BridgeMethodFilter.INSTANCE;
    private final ClassInfoBuilder classInfo;

    private ClassInfoVisitor(ClassInfoBuilder classInfo, ClassVisitor writer) {
        super(589824, writer);
        this.classInfo = classInfo;
    }

    public static ClassInfoBuilder getClassInfo(ClassName name, byte[] bytes, long hash) {
        ClassReader reader = new ClassReader(bytes);
        ClassInfoBuilder info = new ClassInfoBuilder();
        info.id = new ClassIdentifier(hash, name);
        reader.accept(new ClassInfoVisitor(info, null), 0);
        return info;
    }

    @Override
    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.classInfo.superClass = superName;
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        super.visitOuterClass(owner, name, desc);
        this.classInfo.outerClass = owner;
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
        if (outerName != null && this.classInfo.id.getName().equals((Object)ClassName.fromString((String)name))) {
            this.classInfo.outerClass = outerName;
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.shouldInstrument(access, name, desc, signature, exceptions)) {
            return this.visitMethodIfRequired(access, name, desc, signature, exceptions);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public MethodVisitor visitMethodIfRequired(int access, String name, String desc, String signature, String[] exceptions) {
        return new InfoMethodVisitor(this.classInfo);
    }

    private boolean shouldInstrument(int access, String name, String desc, String signature, String[] exceptions) {
        return (Boolean)this.filter.apply((Object)access, (Object)name, (Object)desc, (Object)signature, (Object)exceptions);
    }
}

