/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.text.StringEscapeUtils;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.report.xml.Tag;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.Unchecked;

public class XMLReportListener
implements MutationResultListener {
    public static final String MUTATION_MATRIX_TEST_SEPARATOR = "|";
    private final Writer out;
    private final boolean fullMutationMatrix;

    public XMLReportListener(ResultOutputStrategy outputStrategy, boolean fullMutationMatrix) {
        this(outputStrategy.createWriterForFile("mutations.xml"), fullMutationMatrix);
    }

    public XMLReportListener(Writer out, boolean fullMutationMatrix) {
        this.out = out;
        this.fullMutationMatrix = fullMutationMatrix;
    }

    private void writeResult(ClassMutationResults metaData) {
        for (MutationResult mutation : metaData.getMutations()) {
            this.writeMutationResultXML(mutation);
        }
    }

    private void writeMutationResultXML(MutationResult result) {
        this.write(this.makeNode(this.makeMutationNode(result), this.makeMutationAttributes(result), Tag.mutation) + "\n");
    }

    private String makeMutationAttributes(MutationResult result) {
        return "detected='" + result.getStatus().isDetected() + "' status='" + result.getStatus() + "' numberOfTestsRun='" + result.getNumberOfTestsRun() + "'";
    }

    private String makeMutationNode(MutationResult mutation) {
        MutationDetails details = mutation.getDetails();
        return this.makeNode(this.clean(details.getFilename()), Tag.sourceFile) + this.makeNode(this.clean(details.getClassName().asJavaName()), Tag.mutatedClass) + this.makeNode(this.clean(details.getMethod()), Tag.mutatedMethod) + this.makeNode(this.clean(details.getId().getLocation().getMethodDesc()), Tag.methodDescription) + this.makeNode("" + details.getLineNumber(), Tag.lineNumber) + this.makeNode(this.clean(details.getMutator()), Tag.mutator) + this.makeNodes(Tag.indexes, details.getId().getIndexes(), Tag.index) + this.makeNodes(Tag.blocks, details.getBlocks(), Tag.block) + this.makeNodeWhenConditionSatisfied(!this.fullMutationMatrix, this.createKillingTestDesc(mutation.getKillingTest()), Tag.killingTest) + this.makeNodeWhenConditionSatisfied(this.fullMutationMatrix, this.createTestDesc(mutation.getKillingTests()), Tag.killingTests) + this.makeNodeWhenConditionSatisfied(this.fullMutationMatrix, this.createTestDesc(mutation.getSucceedingTests()), Tag.succeedingTests) + this.makeNode(this.clean(details.getDescription()), Tag.description);
    }

    private String clean(String value) {
        return StringEscapeUtils.escapeXml11((String)value);
    }

    private String makeNode(String value, String attributes, Tag tag) {
        if (value != null) {
            return "<" + (Object)((Object)tag) + " " + attributes + ">" + value + "</" + (Object)((Object)tag) + ">";
        }
        return "<" + (Object)((Object)tag) + attributes + "/>";
    }

    private String makeNodeWhenConditionSatisfied(boolean condition, String value, Tag tag) {
        if (!condition) {
            return "";
        }
        return this.makeNode(value, tag);
    }

    private String makeNode(String value, Tag tag) {
        if (value != null) {
            return "<" + (Object)((Object)tag) + ">" + value + "</" + (Object)((Object)tag) + ">";
        }
        return "<" + (Object)((Object)tag) + "/>";
    }

    private String makeNodes(Tag topTag, List<Integer> values, Tag tag) {
        StringBuilder sb = new StringBuilder();
        sb.append("<" + (Object)((Object)topTag) + ">");
        for (Integer each : values) {
            sb.append(this.makeNode("" + each, tag));
        }
        sb.append("</" + (Object)((Object)topTag) + ">");
        return sb.toString();
    }

    private String createKillingTestDesc(Optional<String> killingTest) {
        return killingTest.map(s -> this.createTestDesc(Arrays.asList(s))).orElse(null);
    }

    private String createTestDesc(List<String> tests) {
        if (tests.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String test : tests) {
            builder.append(test);
            builder.append(MUTATION_MATRIX_TEST_SEPARATOR);
        }
        builder.setLength(builder.length() - 1);
        return this.clean(builder.toString());
    }

    private void write(String value) {
        try {
            this.out.write(value);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException((Throwable)e);
        }
    }

    @Override
    public void runStart() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<mutations>\n");
    }

    @Override
    public void handleMutationResult(ClassMutationResults metaData) {
        this.writeResult(metaData);
    }

    @Override
    public void runEnd() {
        try {
            this.write("</mutations>\n");
            this.out.close();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException((Throwable)e);
        }
    }
}

