/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.sequence;

import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Optional;
import org.pitest.sequence.Context;
import org.pitest.sequence.MultiContext;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;
import org.pitest.sequence.SlotWrite;

final class Context1
implements Context {
    private final boolean debug;
    private final Slot<?> slot;
    private final Object value;

    Context1(Slot<?> slot, Object value, boolean debug) {
        this.slot = slot;
        this.value = value;
        this.debug = debug;
    }

    @Override
    public boolean debug() {
        return this.debug;
    }

    @Override
    public <S> Context store(SlotWrite<S> slot, S value) {
        IdentityHashMap<Slot, Object> mutatedSlots = new IdentityHashMap<Slot, Object>();
        mutatedSlots.put(this.slot, this.value);
        mutatedSlots.put(slot.slot(), value);
        return new MultiContext(mutatedSlots, this.debug);
    }

    @Override
    public <S> Optional<S> retrieve(SlotRead<S> read) {
        if (read.slot().equals(this.slot)) {
            return Optional.ofNullable(this.value);
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Context1)) {
            return false;
        }
        Context1 context1 = (Context1)o;
        return this.slot.equals(context1.slot) && Objects.equals(this.value, context1.value);
    }

    public int hashCode() {
        return Objects.hash(this.slot, this.value);
    }
}

