/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationResult;

public final class MutationMetaData {
    private final List<MutationResult> mutations;

    public MutationMetaData(List<MutationResult> mutations) {
        this.mutations = mutations;
    }

    public Collection<MutationResult> getMutations() {
        return this.mutations;
    }

    public Collection<ClassMutationResults> toClassResults() {
        this.mutations.sort(MutationMetaData.comparator());
        ArrayList<ClassMutationResults> cmrs = new ArrayList<ClassMutationResults>();
        ArrayList<MutationResult> buffer = new ArrayList<MutationResult>();
        ClassName cn = null;
        for (MutationResult each : this.mutations) {
            if (cn != null && !each.getDetails().getClassName().equals((Object)cn)) {
                cmrs.add(new ClassMutationResults(buffer));
                buffer.clear();
            }
            cn = each.getDetails().getClassName();
            buffer.add(each);
        }
        if (!buffer.isEmpty()) {
            cmrs.add(new ClassMutationResults(buffer));
        }
        return cmrs;
    }

    private static Comparator<MutationResult> comparator() {
        return Comparator.comparing(arg0 -> arg0.getDetails().getId());
    }

    public int hashCode() {
        return Objects.hash(this.mutations);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MutationMetaData other = (MutationMetaData)obj;
        return Objects.equals(this.mutations, other.mutations);
    }
}

