/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.util.Map;
import java.util.logging.Logger;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.util.Log;
import org.pitest.util.ReceiveStrategy;
import org.pitest.util.SafeDataInputStream;

class Receive
implements ReceiveStrategy {
    private static final Logger LOG = Log.getLogger();
    private final Map<MutationIdentifier, MutationStatusTestPair> idMap;

    Receive(Map<MutationIdentifier, MutationStatusTestPair> idMap) {
        this.idMap = idMap;
    }

    public void apply(byte control, SafeDataInputStream is) {
        switch (control) {
            case 1: {
                this.handleDescribe(is);
                break;
            }
            case 2: {
                this.handleReport(is);
                break;
            }
            default: {
                LOG.severe("Unknown control byte " + control);
            }
        }
    }

    private void handleReport(SafeDataInputStream is) {
        MutationIdentifier mutation = (MutationIdentifier)is.read(MutationIdentifier.class);
        MutationStatusTestPair value = (MutationStatusTestPair)is.read(MutationStatusTestPair.class);
        this.idMap.put(mutation, value);
        LOG.fine(mutation + " " + value);
    }

    private void handleDescribe(SafeDataInputStream is) {
        MutationIdentifier mutation = (MutationIdentifier)is.read(MutationIdentifier.class);
        this.idMap.put(mutation, MutationStatusTestPair.notAnalysed((int)1, (DetectionStatus)DetectionStatus.STARTED, null));
    }
}

