/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pitest.util.ExitCode;
import org.pitest.util.Log;
import org.pitest.util.ReceiveStrategy;
import org.pitest.util.SafeDataOutputStream;
import org.pitest.util.SocketReadingCallable;

public final class CommunicationThread {
    private static final Logger LOG = Log.getLogger();
    private final Consumer<SafeDataOutputStream> sendInitialData;
    private final ReceiveStrategy receive;
    private final ServerSocket socket;
    private FutureTask<ExitCode> future;

    public CommunicationThread(ServerSocket socket, Consumer<SafeDataOutputStream> sendInitialData, ReceiveStrategy receive) {
        this.socket = socket;
        this.sendInitialData = sendInitialData;
        this.receive = receive;
    }

    public void start() throws IOException, InterruptedException {
        this.future = this.createFuture();
    }

    private FutureTask<ExitCode> createFuture() {
        FutureTask<ExitCode> newFuture = new FutureTask<ExitCode>(new SocketReadingCallable(this.socket, this.sendInitialData, this.receive));
        Thread thread = new Thread(newFuture);
        thread.setDaemon(true);
        thread.setName("pit communication");
        thread.start();
        return newFuture;
    }

    public Optional<ExitCode> waitToFinish(int pollSeconds) {
        try {
            return Optional.of(this.future.get(pollSeconds, TimeUnit.SECONDS));
        }
        catch (ExecutionException e) {
            LOG.log(Level.WARNING, "Error while watching child process", e);
            return Optional.of(ExitCode.UNKNOWN_ERROR);
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, "interrupted while waiting for child process", e);
            return Optional.of(ExitCode.UNKNOWN_ERROR);
        }
        catch (TimeoutException e) {
            return Optional.empty();
        }
    }
}

