/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers;

import java.lang.reflect.Method;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import net.bytebuddy.description.method.MethodDescription;
import org.powermock.PowerMockInternalException;
import org.powermock.core.transformers.MethodSignatureWriter;

public enum MethodSignatures {
    ByteBuddy{

        public MethodSignatureWriter<MethodDescription> methodSignatureWriter() {
            return new ByteBuddyMethodSignatureWriterWriter();
        }
    }
    ,
    Javassist{

        public MethodSignatureWriter<CtMethod> methodSignatureWriter() {
            return new JavassistMethodSignatureWriterWriter();
        }
    };


    public abstract <T> MethodSignatureWriter<T> methodSignatureWriter();

    private static class JavassistMethodSignatureWriterWriter
    implements MethodSignatureWriter<CtMethod> {
        private JavassistMethodSignatureWriterWriter() {
        }

        @Override
        public String signatureFor(CtMethod m) {
            try {
                CtClass[] paramTypes = m.getParameterTypes();
                String[] paramTypeNames = new String[paramTypes.length];
                for (int i = 0; i < paramTypeNames.length; ++i) {
                    paramTypeNames[i] = paramTypes[i].getSimpleName();
                }
                return this.createSignature(m.getDeclaringClass().getSimpleName(), m.getReturnType().getSimpleName(), m.getName(), paramTypeNames);
            }
            catch (NotFoundException e) {
                throw new PowerMockInternalException(e);
            }
        }

        @Override
        public String signatureForReflection(Method m) {
            Class<?>[] paramTypes = m.getParameterTypes();
            String[] paramTypeNames = new String[paramTypes.length];
            for (int i = 0; i < paramTypeNames.length; ++i) {
                paramTypeNames[i] = paramTypes[i].getSimpleName();
            }
            return this.createSignature(m.getDeclaringClass().getSimpleName(), m.getReturnType().getSimpleName(), m.getName(), paramTypeNames);
        }

        private String createSignature(String testClass, String returnType, String methodName, String[] paramTypes) {
            StringBuilder builder = new StringBuilder(testClass).append('\n').append(returnType).append('\n').append(methodName);
            for (String param : paramTypes) {
                builder.append('\n').append(param);
            }
            return builder.toString();
        }
    }

    private static class ByteBuddyMethodSignatureWriterWriter
    implements MethodSignatureWriter<MethodDescription> {
        private ByteBuddyMethodSignatureWriterWriter() {
        }

        @Override
        public String signatureFor(MethodDescription method) {
            return method.toGenericString();
        }

        @Override
        public String signatureForReflection(Method method) {
            return method.toString();
        }
    }
}

