/*
 * Decompiled with CFR 0.152.
 */
package lombok.maven;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.delombok.Delombok;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractDelombokMojo
extends AbstractMojo {
    @Parameter(property="lombok.delombok.skip", defaultValue="false", required=true)
    protected boolean skip;
    @Parameter(property="lombok.encoding", defaultValue="${project.build.sourceEncoding}", required=true)
    protected String encoding;
    @Parameter(property="lombok.verbose", defaultValue="false", required=true)
    protected boolean verbose;
    @Parameter(property="lombok.addOutputDirectory", defaultValue="true", required=true)
    protected boolean addOutputDirectory;
    @Parameter
    protected Map<String, String> formatPreferences;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="plugin.artifacts", required=true, readonly=true)
    private List<Artifact> pluginArtifacts;

    protected abstract String getGoalDescription();

    protected abstract File getOutputDirectory();

    protected abstract File getSourceDirectory();

    protected abstract String getSourcePath();

    protected abstract void addSourceRoot(String var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        Log logger = this.getLog();
        assert (null != logger);
        String goal = this.getGoalDescription();
        logger.debug((CharSequence)("Starting " + goal));
        File outputDirectory = this.getOutputDirectory();
        logger.debug((CharSequence)("outputDirectory: " + outputDirectory));
        File sourceDirectory = this.getSourceDirectory();
        logger.debug((CharSequence)("sourceDirectory: " + sourceDirectory));
        String sourcePath = this.getSourcePath();
        logger.debug((CharSequence)("sourcePath: " + sourcePath));
        if (this.skip) {
            logger.warn((CharSequence)("Skipping " + goal));
            return;
        }
        if (sourceDirectory.exists()) {
            StringBuilder classPathBuilder = new StringBuilder();
            for (Object e : this.project.getArtifacts()) {
                classPathBuilder.append(((Artifact)e).getFile()).append(File.pathSeparatorChar);
            }
            for (Artifact artifact : this.pluginArtifacts) {
                classPathBuilder.append(artifact.getFile()).append(File.pathSeparatorChar);
            }
            String classPath = classPathBuilder.toString();
            logger.debug((CharSequence)("classpath: " + classPath));
            Delombok delombok = new Delombok();
            delombok.setVerbose(this.verbose);
            delombok.setClasspath(classPath);
            if (StringUtils.isNotBlank((CharSequence)this.encoding)) {
                try {
                    delombok.setCharset(this.encoding);
                }
                catch (UnsupportedCharsetException e) {
                    logger.error((CharSequence)"The encoding parameter is invalid; Please check!", (Throwable)e);
                    throw new MojoExecutionException("Unknown charset: " + this.encoding, (Exception)e);
                }
            } else {
                logger.warn((CharSequence)("No encoding specified; using default: " + Charset.defaultCharset()));
            }
            if (null != this.formatPreferences && !this.formatPreferences.isEmpty()) {
                try {
                    ArrayList<String> formatOptions = new ArrayList<String>(this.formatPreferences.size());
                    for (Map.Entry<String, String> entry : this.formatPreferences.entrySet()) {
                        String key = entry.getKey();
                        formatOptions.add("pretty".equalsIgnoreCase(key) ? key : key + ':' + entry.getValue());
                    }
                    delombok.setFormatPreferences(Delombok.formatOptionsToMap(formatOptions));
                }
                catch (Delombok.InvalidFormatOptionException e) {
                    logger.error((CharSequence)"The formatPreferences parameter is invalid; Please check!", (Throwable)e);
                    throw new MojoExecutionException("Invalid formatPreferences: " + this.formatPreferences, (Exception)((Object)e));
                }
            }
            try {
                delombok.setOutput(outputDirectory);
                delombok.setSourcepath(this.getSourcePath());
                delombok.addDirectory(sourceDirectory);
                delombok.delombok();
                logger.info((CharSequence)(goal + " complete."));
                if (!this.addOutputDirectory) return;
                this.addSourceRoot(outputDirectory.getCanonicalPath());
                return;
            }
            catch (IOException e) {
                logger.error((CharSequence)"Unable to delombok!", (Throwable)e);
                throw new MojoExecutionException("I/O problem during delombok", (Exception)e);
            }
        }
        logger.warn((CharSequence)("Skipping " + goal + "; no source to process."));
    }
}

