/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.protocol;

import java.util.Set;
import org.projectodd.stilts.stomp.DefaultHeaders;
import org.projectodd.stilts.stomp.Headers;
import org.projectodd.stilts.stomp.protocol.StompFrame;

public class FrameHeader {
    private StompFrame.Command command;
    private DefaultHeaders headers = new DefaultHeaders();

    public FrameHeader() {
    }

    public FrameHeader(StompFrame.Command command) {
        this.command = command;
    }

    public FrameHeader(StompFrame.Command command, Headers headers) {
        this.command = command;
        this.headers.putAll(headers);
    }

    public boolean isContentFrame() {
        return this.command.hasContent();
    }

    public void setCommand(StompFrame.Command command) {
        this.command = command;
    }

    public StompFrame.Command getCommand() {
        return this.command;
    }

    public void set(String name, String value) {
        this.headers.put(name, value);
    }

    public String get(String name) {
        return this.headers.get(name);
    }

    public Set<String> getNames() {
        return this.headers.keySet();
    }

    public Headers getMap() {
        return this.headers;
    }

    public int getContentLength() {
        String value = this.get("content-length".toString());
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String toString() {
        return "[FrameHeader: command=" + this.command + "; headers=" + this.headers + "]";
    }
}

