/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.python.core.JyAttribute;
import org.python.core.Py;
import org.python.core.PyInstance;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequenceList;
import org.python.core.PyString;
import org.python.core.Traverseproc;
import org.python.core.TraverseprocDerived;
import org.python.core.Untraversable;
import org.python.core.Visitproc;
import org.python.core.finalization.FinalizeTrigger;
import org.python.modules._weakref.GlobalRef;

public class gc {
    public static final int UNKNOWN_COUNT = -2;
    public static final short MONITOR_GLOBAL = 1;
    public static final short DONT_FINALIZE_CYCLIC_GARBAGE = 2;
    public static final short PRESERVE_WEAKREFS_ON_RESURRECTION = 4;
    public static final short DONT_FINALIZE_RESURRECTED_OBJECTS = 8;
    public static final short DONT_TRAVERSE_BY_REFLECTION = 16;
    public static final short SUPPRESS_TRAVERSE_BY_REFLECTION_WARNING = 32;
    public static final short USE_PY_WRITE_DEBUG = 64;
    public static final short VERBOSE_COLLECT = 128;
    public static final short VERBOSE_WEAKREF = 256;
    public static final short VERBOSE_DELAYED = 512;
    public static final short VERBOSE_FINALIZE = 1024;
    public static final short VERBOSE = 1920;
    public static final int DEBUG_STATS = 1;
    public static final int DEBUG_COLLECTABLE = 2;
    public static final int DEBUG_UNCOLLECTABLE = 4;
    public static final int DEBUG_INSTANCES = 8;
    public static final int DEBUG_OBJECTS = 16;
    public static final int DEBUG_SAVEALL = 32;
    public static final int DEBUG_LEAK = 62;
    private static short gcFlags = (short)16;
    private static int debugFlags = 0;
    private static boolean monitorNonTraversable = false;
    private static boolean waitingForFinalizers = false;
    private static AtomicBoolean gcRunning = new AtomicBoolean(false);
    private static HashSet<WeakReferenceGC> monitoredObjects;
    private static ReferenceQueue<Object> gcTrash;
    private static int finalizeWaitCount;
    private static int initWaitTime;
    private static int defaultWaitFactor;
    private static long lastRemoveTimeStamp;
    private static long maxWaitTime;
    private static int gcMonitoredRunCount;
    public static long gcRecallTime;
    public static PyList garbage;
    private static List<Runnable> preFinalizationProcess;
    private static List<Runnable> postFinalizationProcess;
    private static List<Runnable> preFinalizationProcessRemove;
    private static List<Runnable> postFinalizationProcessRemove;
    private static Thread postFinalizationProcessor;
    private static long postFinalizationTimeOut;
    private static long postFinalizationTimestamp;
    private static int openFinalizeCount;
    private static boolean postFinalizationPending;
    private static boolean lockPostFinalization;
    private static IdentityHashMap<PyObject, PyObject> delayedFinalizables;
    private static IdentityHashMap<PyObject, PyObject> resurrectionCritics;
    private static int abortedCyclicFinalizers;
    private static final byte DO_NOTHING_SPECIAL = 0;
    private static final byte MARK_REACHABLE_CRITICS = 1;
    private static final byte NOTIFY_FOR_RERUN = 2;
    private static byte delayedFinalizationMode;
    private static boolean notifyRerun;
    public static final String __doc__ = "This module provides access to the garbage collector for reference cycles.\n\nenable() -- Enable automatic garbage collection (does nothing in Jython).\ndisable() -- Disable automatic garbage collection (raises NotImplementedError in Jython).\nisenabled() -- Returns True because Java garbage collection cannot be disabled.\ncollect() -- Do a full collection right now (potentially expensive).\nget_count() -- Return the current collection counts (raises NotImplementedError in Jython).\nset_debug() -- Set debugging flags.\nget_debug() -- Get debugging flags.\nset_threshold() -- Set the collection thresholds (raise NotImplementedError in Jython).\nget_threshold() -- Return the current the collection thresholds (raise NotImplementedError in Jython).\nget_objects() -- Return a list of all objects tracked by the collector (raises NotImplementedError in Jython).\nis_tracked() -- Returns true if a given object is tracked (i.e. monitored in Jython).\nget_referrers() -- Return the list of objects that refer to an object (only finds monitored referrers in Jython).\nget_referents() -- Return the list of objects that an object refers to.\n";
    public static final String __name__ = "gc";
    public static final PyString __doc__enable;
    public static final PyString __doc__disable;
    public static final PyString __doc__isenabled;
    public static final PyString __doc__collect;
    public static final PyString __doc__get_count;
    public static final PyString __doc__set_debug;
    public static final PyString __doc__get_debug;
    public static final PyString __doc__set_thresh;
    public static final PyString __doc__get_thresh;
    public static final PyString __doc__get_objects;
    public static final PyString __doc__is_tracked;
    public static final PyString __doc__get_referrers;
    public static final PyString __doc__get_referents;

    public static void writeDebug(String type, String msg) {
        if ((gcFlags & 0x40) != 0) {
            Py.writeDebug(type, msg);
        } else {
            System.err.println(type + ": " + msg);
        }
    }

    public static boolean delayedFinalizationEnabled() {
        return (gcFlags & 0xC) != 0;
    }

    private static void updateDelayedFinalizationState() {
        if (gc.delayedFinalizationEnabled()) {
            gc.resumeDelayedFinalization();
        } else if (gc.indexOfPostFinalizationProcess(DelayedFinalizationProcess.defaultInstance) != -1) {
            gc.suspendDelayedFinalization();
        }
        if ((gcFlags & 4) == 0 && GlobalRef.hasDelayedCallbacks()) {
            Thread dlcProcess = new Thread(){

                @Override
                public void run() {
                    GlobalRef.processDelayedCallbacks();
                }
            };
            dlcProcess.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resumeDelayedFinalization() {
        if (delayedFinalizables == null) {
            delayedFinalizables = new IdentityHashMap();
        }
        if (resurrectionCritics == null) {
            resurrectionCritics = new IdentityHashMap();
        }
        try {
            List<Runnable> list = postFinalizationProcessRemove;
            synchronized (list) {
                postFinalizationProcessRemove.remove(DelayedFinalizationProcess.defaultInstance);
                if (postFinalizationProcessRemove.isEmpty()) {
                    postFinalizationProcessRemove = null;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (gc.indexOfPostFinalizationProcess(DelayedFinalizationProcess.defaultInstance) == -1) {
            gc.registerPostFinalizationProcess(DelayedFinalizationProcess.defaultInstance);
        }
    }

    private static void suspendDelayedFinalization() {
        gc.unregisterPostFinalizationProcessAfterNextRun(DelayedFinalizationProcess.defaultInstance);
    }

    private static boolean isResurrectionCritic(PyObject ob) {
        return gc.isTraversable(ob) && FinalizeTrigger.hasActiveTrigger(ob);
    }

    public static void registerForDelayedFinalization(PyObject ob) {
        if (gc.isResurrectionCritic(ob)) {
            resurrectionCritics.put(ob, ob);
        } else {
            delayedFinalizables.put(ob, ob);
        }
    }

    public static void registerPreFinalizationProcess(Runnable process) {
        gc.registerPreFinalizationProcess(process, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPreFinalizationProcess(Runnable process, int index) {
        while (true) {
            try {
                List<Runnable> list = preFinalizationProcess;
                synchronized (list) {
                    preFinalizationProcess.add(index < 0 ? index + preFinalizationProcess.size() + 1 : index, process);
                }
                return;
            }
            catch (NullPointerException npe) {
                preFinalizationProcess = new ArrayList<Runnable>(1);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int indexOfPreFinalizationProcess(Runnable process) {
        try {
            List<Runnable> list = preFinalizationProcess;
            synchronized (list) {
                return preFinalizationProcess.indexOf(process);
            }
        }
        catch (NullPointerException npe) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregisterPreFinalizationProcess(Runnable process) {
        try {
            List<Runnable> list = preFinalizationProcess;
            synchronized (list) {
                boolean result = preFinalizationProcess.remove(process);
                if (result && preFinalizationProcess.isEmpty()) {
                    preFinalizationProcess = null;
                }
                return result;
            }
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterPreFinalizationProcessAfterNextRun(Runnable process) {
        while (true) {
            try {
                List<Runnable> list = preFinalizationProcessRemove;
                synchronized (list) {
                    preFinalizationProcessRemove.add(process);
                }
                return;
            }
            catch (NullPointerException npe) {
                preFinalizationProcessRemove = new ArrayList<Runnable>(1);
                continue;
            }
            break;
        }
    }

    public static void registerPostFinalizationProcess(Runnable process) {
        gc.registerPostFinalizationProcess(process, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPostFinalizationProcess(Runnable process, int index) {
        while (true) {
            try {
                List<Runnable> list = postFinalizationProcess;
                synchronized (list) {
                    postFinalizationProcess.add(index < 0 ? index + postFinalizationProcess.size() + 1 : index, process);
                }
                return;
            }
            catch (NullPointerException npe) {
                postFinalizationProcess = new ArrayList<Runnable>(1);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int indexOfPostFinalizationProcess(Runnable process) {
        try {
            List<Runnable> list = postFinalizationProcess;
            synchronized (list) {
                return postFinalizationProcess.indexOf(process);
            }
        }
        catch (NullPointerException npe) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregisterPostFinalizationProcess(Runnable process) {
        try {
            List<Runnable> list = postFinalizationProcess;
            synchronized (list) {
                boolean result = postFinalizationProcess.remove(process);
                if (result && postFinalizationProcess.isEmpty()) {
                    postFinalizationProcess = null;
                }
                return result;
            }
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterPostFinalizationProcessAfterNextRun(Runnable process) {
        while (true) {
            try {
                List<Runnable> list = postFinalizationProcessRemove;
                synchronized (list) {
                    postFinalizationProcessRemove.add(process);
                }
                return;
            }
            catch (NullPointerException npe) {
                postFinalizationProcessRemove = new ArrayList<Runnable>(1);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyPreFinalization() {
        ++openFinalizeCount;
        if (System.currentTimeMillis() - postFinalizationTimestamp < postFinalizationTimeOut) {
            return;
        }
        try {
            List<Runnable> list = preFinalizationProcess;
            synchronized (list) {
                for (Runnable r : preFinalizationProcess) {
                    try {
                        r.run();
                    }
                    catch (Exception preProcessError) {
                        Py.writeError(__name__, "Finalization preprocess " + r + " caused error: " + preProcessError);
                    }
                }
                try {
                    List<Runnable> i$ = preFinalizationProcessRemove;
                    synchronized (i$) {
                        preFinalizationProcess.removeAll(preFinalizationProcessRemove);
                        preFinalizationProcessRemove = null;
                    }
                    if (preFinalizationProcess.isEmpty()) {
                        preFinalizationProcess = null;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException npe) {
            preFinalizationProcessRemove = null;
        }
        try {
            List<Runnable> npe = postFinalizationProcess;
            synchronized (npe) {
                if (!postFinalizationProcess.isEmpty() && postFinalizationProcessor == null) {
                    postFinalizationPending = true;
                    postFinalizationProcessor = new Thread(PostFinalizationProcessor.defaultInstance);
                    postFinalizationProcessor.start();
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void notifyPostFinalization() {
        postFinalizationTimestamp = System.currentTimeMillis();
        if (--openFinalizeCount == 0 && postFinalizationProcessor != null) {
            postFinalizationProcessor.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void postFinalizationProcess() {
        try {
            List<Runnable> list = postFinalizationProcess;
            synchronized (list) {
                for (Runnable r : postFinalizationProcess) {
                    try {
                        r.run();
                    }
                    catch (Exception postProcessError) {
                        System.err.println("Finalization postprocess " + r + " caused error:");
                        System.err.println(postProcessError);
                    }
                }
                try {
                    List<Runnable> i$ = postFinalizationProcessRemove;
                    synchronized (i$) {
                        postFinalizationProcess.removeAll(postFinalizationProcessRemove);
                        postFinalizationProcessRemove = null;
                    }
                    if (postFinalizationProcess.isEmpty()) {
                        postFinalizationProcess = null;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException npe) {
            postFinalizationProcessRemove = null;
        }
    }

    public static void monitorObject(PyObject ob) {
        gc.monitorObject(ob, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void monitorObject(PyObject ob, boolean initString) {
        if (ob == garbage) {
            return;
        }
        if (!(monitorNonTraversable || gc.isTraversable(ob) || JyAttribute.hasAttr(ob, (byte)127))) {
            return;
        }
        if (gcTrash == null) {
            gcTrash = new ReferenceQueue();
        }
        while (true) {
            try {
                HashSet<WeakReferenceGC> hashSet = monitoredObjects;
                synchronized (hashSet) {
                    if (!gc.isMonitored(ob)) {
                        CycleMarkAttr cm = new CycleMarkAttr();
                        JyAttribute.setAttr(ob, (byte)4, cm);
                        WeakReferenceGC refPut = new WeakReferenceGC(ob, gcTrash);
                        if (initString) {
                            refPut.initStr(ob);
                        }
                        monitoredObjects.add(refPut);
                        cm.monitored = true;
                    }
                }
                return;
            }
            catch (NullPointerException npe) {
                monitoredObjects = new HashSet();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WeakReferenceGC getMonitorReference(PyObject ob) {
        try {
            HashSet<WeakReferenceGC> hashSet = monitoredObjects;
            synchronized (hashSet) {
                for (WeakReferenceGC ref : monitoredObjects) {
                    if (!ref.equals(ob)) continue;
                    return ref;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMonitoring() {
        try {
            HashSet<WeakReferenceGC> hashSet = monitoredObjects;
            synchronized (hashSet) {
                return !monitoredObjects.isEmpty();
            }
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMonitored(PyObject ob) {
        try {
            HashSet<WeakReferenceGC> hashSet = monitoredObjects;
            synchronized (hashSet) {
                WeakrefGCCompareDummy.defaultInstance.setCompare(ob);
                boolean result = monitoredObjects.contains(WeakrefGCCompareDummy.defaultInstance);
                WeakrefGCCompareDummy.defaultInstance.compare = null;
                return result;
            }
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unmonitorObject(PyObject ob) {
        try {
            HashSet<WeakReferenceGC> hashSet = monitoredObjects;
            synchronized (hashSet) {
                WeakrefGCCompareDummy.defaultInstance.setCompare(ob);
                WeakReferenceGC rem = gc.getMonitorReference(ob);
                if (rem != null) {
                    rem.clear();
                }
                boolean result = monitoredObjects.remove(WeakrefGCCompareDummy.defaultInstance);
                WeakrefGCCompareDummy.defaultInstance.compare = null;
                JyAttribute.delAttr(ob, (byte)4);
                FinalizeTrigger ft = (FinalizeTrigger)JyAttribute.getAttr(ob, (byte)127);
                if (ft != null) {
                    ft.flags = (byte)(ft.flags & 0xFFFFFFFE);
                }
                return result;
            }
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmonitorAll() {
        try {
            HashSet<WeakReferenceGC> hashSet = monitoredObjects;
            synchronized (hashSet) {
                for (WeakReferenceGC mo : monitoredObjects) {
                    PyObject rfrt = (PyObject)mo.get();
                    if (rfrt != null) {
                        JyAttribute.delAttr(rfrt, (byte)4);
                        FinalizeTrigger ft = (FinalizeTrigger)JyAttribute.getAttr(rfrt, (byte)127);
                        if (ft != null) {
                            ft.flags = (byte)(ft.flags & 0xFFFFFFFE);
                        }
                    }
                    mo.clear();
                }
                monitoredObjects.clear();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void stopMonitoring() {
        gc.setMonitorGlobal(false);
        if (monitoredObjects != null) {
            gc.unmonitorAll();
            monitoredObjects = null;
        }
    }

    public static boolean getMonitorGlobal() {
        return PyObject.gcMonitorGlobal;
    }

    public static void setMonitorGlobal(boolean flag) {
        gcFlags = flag ? (short)(gcFlags | 1) : (short)(gcFlags & 0xFFFFFFFE);
        PyObject.gcMonitorGlobal = flag;
    }

    public static short getJythonGCFlags() {
        if ((gcFlags & 1) != 0 != PyObject.gcMonitorGlobal) {
            gcFlags = PyObject.gcMonitorGlobal ? (short)(gcFlags | 1) : (short)(gcFlags & 0xFFFFFFFE);
        }
        return gcFlags;
    }

    public static void setJythonGCFlags(short flags) {
        gcFlags = flags;
        PyObject.gcMonitorGlobal = (gcFlags & 1) != 0;
        gc.updateDelayedFinalizationState();
    }

    public static void addJythonGCFlags(short flags) {
        PyObject.gcMonitorGlobal = ((gcFlags = (short)(gcFlags | flags)) & 1) != 0;
        gc.updateDelayedFinalizationState();
    }

    public static void removeJythonGCFlags(short flags) {
        PyObject.gcMonitorGlobal = ((gcFlags = (short)(gcFlags & ~flags)) & 1) != 0;
        gc.updateDelayedFinalizationState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void notifyFinalize(PyObject finalized) {
        if (--finalizeWaitCount != 0 || !waitingForFinalizers) return;
        Class<GCSentinel> clazz = GCSentinel.class;
        synchronized (GCSentinel.class) {
            GCSentinel.class.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void notifyAbortFinalize(PyObject abort, boolean cyclic) {
        if (cyclic) {
            ++abortedCyclicFinalizers;
        }
        gc.notifyFinalize(abort);
    }

    public static void enable() {
    }

    public static void disable() {
        throw Py.NotImplementedError("can't disable Java GC");
    }

    public static boolean isenabled() {
        return true;
    }

    public static int collect(int generation) {
        return gc.collect();
    }

    private static boolean needsTrashPrinting() {
        return !((debugFlags & 2) == 0 && (debugFlags & 4) == 0 || (debugFlags & 8) == 0 && (debugFlags & 0x10) == 0);
    }

    private static boolean needsCollectBuffer() {
        return (debugFlags & 1) != 0 || gc.needsTrashPrinting();
    }

    public static int collect() {
        try {
            return gc.collect_intern();
        }
        catch (ConcurrentModificationException cme) {
            cme.printStackTrace();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        return -1;
    }

    private static int collect_intern() {
        int result;
        long t1 = 0L;
        if ((debugFlags & 1) != 0) {
            t1 = System.currentTimeMillis();
        }
        if (!gc.isMonitoring()) {
            if ((debugFlags & 1) != 0) {
                gc.writeDebug(__name__, "collecting generation x...");
                gc.writeDebug(__name__, "objects in each generation: unknown");
            }
            if ((gcFlags & 0x80) != 0) {
                gc.writeDebug(__name__, "no monitoring; perform ordinary async System.gc...");
            }
            System.gc();
            result = -2;
        } else {
            if (!gcRunning.compareAndSet(false, true)) {
                if ((gcFlags & 0x80) != 0) {
                    gc.writeDebug(__name__, "collect already running...");
                }
                return -1;
            }
            if ((gcFlags & 0x80) != 0) {
                gc.writeDebug(__name__, "perform monitored sync gc run...");
            }
            if (gc.needsTrashPrinting() || (gcFlags & 0x780) != 0) {
                ArrayList<WeakReferenceGC> lst = new ArrayList<WeakReferenceGC>();
                for (WeakReferenceGC wr : monitoredObjects) {
                    if (wr.str != null) continue;
                    lst.add(wr);
                }
                for (WeakReferenceGC ol : lst) {
                    ol.initStr(null);
                }
                lst.clear();
            }
            ++gcMonitoredRunCount;
            delayedFinalizationMode = 1;
            notifyRerun = false;
            int[] stat = new int[]{0, 0};
            gc.syncCollect(stat, (debugFlags & 1) != 0);
            delayedFinalizationMode = (byte)2;
            if (notifyRerun) {
                if ((gcFlags & 0x80) != 0) {
                    gc.writeDebug(__name__, "initial sync collect done.");
                }
                while (notifyRerun) {
                    notifyRerun = false;
                    if ((gcFlags & 0x80) != 0) {
                        gc.writeDebug(__name__, "rerun gc...");
                    }
                    gc.syncCollect(stat, false);
                }
                if ((gcFlags & 0x80) != 0) {
                    gc.writeDebug(__name__, "all sync collect runs done.");
                }
            } else if ((gcFlags & 0x80) != 0) {
                gc.writeDebug(__name__, "sync collect done.");
            }
            delayedFinalizationMode = 0;
            gcRunning.set(false);
            result = stat[0];
            if ((debugFlags & 1) != 0 && result != -2) {
                StringBuilder sb = new StringBuilder("done, ");
                sb.append(stat[0]);
                sb.append(" unreachable, ");
                sb.append(stat[1]);
                sb.append(" uncollectable");
                if (t1 != 0L) {
                    sb.append(", ");
                    sb.append((double)(System.currentTimeMillis() - t1) / 1000.0);
                    sb.append("s elapsed");
                }
                sb.append(".");
                gc.writeDebug(__name__, sb.toString());
            }
        }
        if ((debugFlags & 1) != 0 && result == -2) {
            StringBuilder sb = new StringBuilder("done");
            if (t1 != 0L) {
                sb.append(", ");
                sb.append((double)(System.currentTimeMillis() - t1) / 1000.0);
                sb.append("s elapsed");
            }
            sb.append(".");
            gc.writeDebug(__name__, sb.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void syncCollect(int[] stat, boolean debugStat) {
        Serializable obj;
        FinalizeTrigger ft;
        Reference<Object> trash;
        abortedCyclicFinalizers = 0;
        lockPostFinalization = true;
        try {
            trash = gcTrash.remove(initWaitTime);
            if (trash != null && (gcFlags & 0x80) != 0) {
                gc.writeDebug(__name__, "monitored objects from previous gc-run found.");
            }
        }
        catch (InterruptedException ie) {
            trash = null;
        }
        HashSet<WeakReferenceGC> hashSet = monitoredObjects;
        // MONITORENTER : hashSet
        if (trash != null) {
            while (trash != null) {
                monitoredObjects.remove(trash);
                try {
                    trash = gcTrash.remove(initWaitTime);
                }
                catch (InterruptedException ie) {
                    trash = null;
                }
            }
            if ((gcFlags & 0x80) != 0) {
                gc.writeDebug(__name__, "cleaned up previous trash.");
            }
        }
        for (WeakReferenceGC wrg : monitoredObjects) {
            wrg.updateHasFinalizer();
            if (!wrg.hasFinalizer) continue;
            ft = (FinalizeTrigger)JyAttribute.getAttr((PyObject)wrg.get(), (byte)127);
            ft.flags = (byte)(ft.flags | 1);
        }
        IdentityHashMap<PyObject, WeakReferenceGC> cyclicLookup = gc.removeNonCyclicWeakRefs(monitoredObjects);
        HashSet<WeakReferenceGC> cyclic = new HashSet<WeakReferenceGC>(cyclicLookup.values());
        if (debugStat) {
            gc.writeDebug(__name__, "collecting generation x...");
            gc.writeDebug(__name__, "objects in each generation: " + cyclic.size());
        }
        if ((debugFlags & 0x20) != 0 || (gcFlags & 8) != 0) {
            cyclic.retainAll(monitoredObjects);
            for (WeakReferenceGC wrg : cyclic) {
                if (wrg.hasFinalizer) continue;
                obj = (PyObject)wrg.get();
                FinalizeTrigger.ensureFinalizer(obj);
                wrg.updateHasFinalizer();
                ft = (FinalizeTrigger)JyAttribute.getAttr(obj, (byte)127);
                ft.flags = (byte)(ft.flags | 8);
                ft.flags = (byte)(ft.flags | 1);
            }
        }
        // MONITOREXIT : hashSet
        maxWaitTime = initWaitTime;
        WeakReference<Object> sentRef = new WeakReference<Object>(new GCSentinel(Thread.currentThread()), gcTrash);
        lastRemoveTimeStamp = System.currentTimeMillis();
        if (finalizeWaitCount != 0) {
            System.err.println("Finalize wait count should be initially 0!");
            finalizeWaitCount = 0;
        }
        try {
            trash = gcTrash.remove(initWaitTime);
            if (trash != null && (gcFlags & 0x80) != 0) {
                gc.writeDebug(__name__, "monitored objects from interferring gc-run found.");
            }
        }
        catch (InterruptedException ie) {
            trash = null;
        }
        if (trash != null) {
            while (trash != null) {
                monitoredObjects.remove(trash);
                if (cyclic.remove(trash) && (gcFlags & 0x80) != 0) {
                    gc.writeDebug(__name__, "cyclic interferring trash: " + trash);
                } else if ((gcFlags & 0x80) != 0) {
                    gc.writeDebug(__name__, "interferring trash: " + trash);
                }
                try {
                    trash = gcTrash.remove(initWaitTime);
                }
                catch (InterruptedException ie) {
                    trash = null;
                }
            }
            if ((gcFlags & 0x80) != 0) {
                gc.writeDebug(__name__, "cleaned up interferring trash.");
            }
        }
        if ((gcFlags & 0x80) != 0) {
            gc.writeDebug(__name__, "call System.gc.");
        }
        cyclicLookup = null;
        System.gc();
        ArrayList<WeakReferenceGC> collectBuffer = null;
        if (gc.needsCollectBuffer()) {
            collectBuffer = new ArrayList<WeakReferenceGC>();
        }
        try {
            while (true) {
                long removeTime;
                if ((removeTime = System.currentTimeMillis() - lastRemoveTimeStamp) > maxWaitTime) {
                    maxWaitTime = removeTime;
                }
                lastRemoveTimeStamp = System.currentTimeMillis();
                trash = gcTrash.remove(Math.max(gcRecallTime, maxWaitTime * (long)defaultWaitFactor));
                if (trash != null) {
                    if (trash instanceof WeakReferenceGC) {
                        obj = monitoredObjects;
                        // MONITORENTER : obj
                        monitoredObjects.remove(trash);
                        // MONITOREXIT : obj
                        if (cyclic.contains(trash) && !((WeakReferenceGC)trash).cls.contains("Java")) {
                            stat[0] = stat[0] + 1;
                            if (collectBuffer != null) {
                                collectBuffer.add((WeakReferenceGC)trash);
                            }
                            if ((gcFlags & 0x80) != 0) {
                                gc.writeDebug(__name__, "Collected cyclic object: " + trash);
                            }
                        }
                        if (!((WeakReferenceGC)trash).hasFinalizer) continue;
                        ++finalizeWaitCount;
                        if ((gcFlags & 0x400) == 0) continue;
                        gc.writeDebug(__name__, "Collected finalizable object: " + trash);
                        gc.writeDebug(__name__, "New finalizeWaitCount: " + finalizeWaitCount);
                        continue;
                    }
                    if (trash != sentRef || (gcFlags & 0x80) == 0) continue;
                    gc.writeDebug(__name__, "Sentinel collected.");
                    continue;
                }
                System.gc();
            }
        }
        catch (InterruptedException iex2) {
            block67: {
                block69: {
                    block68: {
                        Class iex2;
                        if ((gcFlags & 0x80) != 0) {
                            gc.writeDebug(__name__, "all objects from run enqueud in trash queue.");
                            gc.writeDebug(__name__, "pending finalizers: " + finalizeWaitCount);
                        }
                        lockPostFinalization = false;
                        if (postFinalizationProcessor != null) {
                            postFinalizationProcessor.interrupt();
                        }
                        waitingForFinalizers = true;
                        if (finalizeWaitCount != 0) {
                            if ((gcFlags & 0x80) != 0) {
                                gc.writeDebug(__name__, "waiting for " + finalizeWaitCount + " pending finalizers.");
                                if (finalizeWaitCount < 0) {
                                    Py.writeError(__name__, "There should never be less than zero pending finalizers!");
                                }
                            }
                            iex2 = GCSentinel.class;
                            // MONITORENTER : org.python.modules.gc$GCSentinel.class
                            while (finalizeWaitCount != 0) {
                                try {
                                    GCSentinel.class.wait();
                                }
                                catch (InterruptedException ie2) {}
                            }
                            // MONITOREXIT : iex2
                            if ((gcFlags & 0x80) != 0) {
                                gc.writeDebug(__name__, "no more finalizers pending.");
                            }
                        }
                        waitingForFinalizers = false;
                        if (postFinalizationPending) {
                            if ((gcFlags & 0x80) != 0) {
                                gc.writeDebug(__name__, "waiting for pending post-finalization process.");
                            }
                            iex2 = PostFinalizationProcessor.class;
                            // MONITORENTER : org.python.modules.gc$PostFinalizationProcessor.class
                            while (postFinalizationPending) {
                                try {
                                    PostFinalizationProcessor.class.wait();
                                }
                                catch (InterruptedException ie3) {}
                            }
                            // MONITOREXIT : iex2
                            if ((gcFlags & 0x80) != 0) {
                                gc.writeDebug(__name__, "post-finalization finished.");
                            }
                        }
                        if (collectBuffer == null) break block67;
                        if ((debugFlags & 2) != 0 && ((debugFlags & 0x10) != 0 || (debugFlags & 8) != 0)) break block68;
                        if ((debugFlags & 1) != 0) {
                            for (WeakReferenceGC wrg : collectBuffer) {
                                if (!wrg.cycleMark.isUncollectable()) continue;
                                stat[1] = stat[1] + 1;
                            }
                        }
                        break block69;
                    }
                    for (WeakReferenceGC wrg : collectBuffer) {
                        if (!wrg.cycleMark.isUncollectable()) {
                            if (wrg.isInstance) {
                                gc.writeDebug(__name__, "collectable " + ((debugFlags & 8) != 0 ? wrg.inst_str : wrg.str));
                                continue;
                            }
                            if ((debugFlags & 0x10) == 0) continue;
                            gc.writeDebug(__name__, "collectable " + wrg.str);
                            continue;
                        }
                        stat[1] = stat[1] + 1;
                    }
                }
                if ((debugFlags & 4) != 0 && ((debugFlags & 0x10) != 0 || (debugFlags & 8) != 0)) {
                    for (WeakReferenceGC wrg : collectBuffer) {
                        if (!wrg.cycleMark.isUncollectable()) continue;
                        if (wrg.isInstance) {
                            gc.writeDebug(__name__, "uncollectable " + ((debugFlags & 8) != 0 ? wrg.inst_str : wrg.str));
                            continue;
                        }
                        if ((debugFlags & 0x10) == 0) continue;
                        gc.writeDebug(__name__, "uncollectable " + wrg.str);
                    }
                }
            }
            if ((gcFlags & 0x80) != 0) {
                gc.writeDebug(__name__, abortedCyclicFinalizers + " finalizers aborted.");
            }
            stat[0] = stat[0] - abortedCyclicFinalizers;
            stat[1] = stat[1] - abortedCyclicFinalizers;
            return;
        }
    }

    public static PyObject get_count() {
        throw Py.NotImplementedError("not applicable to Java GC");
    }

    public static void set_debug(int flags) {
        debugFlags = flags;
    }

    public static int get_debug() {
        return debugFlags;
    }

    public static void set_threshold(PyObject[] args, String[] kwargs) {
        throw Py.NotImplementedError("not applicable to Java GC");
    }

    public static PyObject get_threshold() {
        throw Py.NotImplementedError("not applicable to Java GC");
    }

    public static PyObject get_objects() {
        throw Py.NotImplementedError("not applicable to Java GC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PyObject get_referrers(PyObject[] args, String[] kwargs) {
        if (!gc.isMonitoring()) {
            throw Py.NotImplementedError("not applicable in Jython if gc module is not monitoring PyObjects");
        }
        if (args == null) {
            return Py.None;
        }
        PyList result = new PyList();
        PyObject[] coll = new PyObject[]{null, result};
        HashSet<WeakReferenceGC> hashSet = monitoredObjects;
        synchronized (hashSet) {
            for (PyObject ob : args) {
                for (WeakReferenceGC src0 : monitoredObjects) {
                    PyObject src = (PyObject)src0.get();
                    if (src instanceof Traverseproc) {
                        try {
                            if (!((Traverseproc)((Object)src)).refersDirectlyTo(ob)) continue;
                            ((PyObject)result).__add__(src);
                        }
                        catch (UnsupportedOperationException uoe) {
                            coll[0] = ob;
                            gc.traverse(ob, ReferrerFinder.defaultInstance, coll);
                        }
                        continue;
                    }
                    if (!gc.isTraversable(src)) continue;
                    coll[0] = ob;
                    gc.traverse(ob, ReferrerFinder.defaultInstance, coll);
                }
            }
        }
        return result;
    }

    public static PyObject get_referents(PyObject[] args, String[] kwargs) {
        if (args == null) {
            return Py.None;
        }
        PyList result = new PyList();
        for (PyObject ob : args) {
            gc.traverse(ob, ReferentsFinder.defaultInstance, result);
        }
        return result;
    }

    public static PyObject is_tracked(PyObject[] args, String[] kwargs) {
        if (gc.isTraversable(args[0]) && (monitoredObjects == null || gc.isMonitored(args[0]))) {
            return Py.True;
        }
        return Py.False;
    }

    private static IdentityHashMap<PyObject, WeakReferenceGC> removeNonCyclicWeakRefs(Iterable<WeakReferenceGC> pool) {
        IdentityHashMap tmp;
        PyObject referent;
        IdentityHashMap[] pools = new IdentityHashMap[]{new IdentityHashMap(), new IdentityHashMap()};
        if (monitorNonTraversable) {
            for (WeakReferenceGC ref : pool) {
                referent = (PyObject)ref.get();
                if (referent == null || !gc.isTraversable(referent)) continue;
                pools[0].put(referent, ref);
            }
        } else {
            for (WeakReferenceGC ref : pool) {
                referent = (PyObject)ref.get();
                if (referent == null) continue;
                pools[0].put(referent, ref);
            }
        }
        IdentityHashMap toProcess = new IdentityHashMap();
        for (WeakReferenceGC ref : pools[0].values()) {
            gc.traverse((PyObject)ref.get(), ReachableFinderWeakRefs.defaultInstance, pools);
        }
        while (!pools[1].isEmpty()) {
            tmp = pools[1];
            pools[1] = toProcess;
            toProcess = tmp;
            pools[0].putAll(toProcess);
            for (WeakReferenceGC ref : toProcess.values()) {
                gc.traverse((PyObject)ref.get(), ReachableFinderWeakRefs.defaultInstance, pools);
            }
            toProcess.clear();
        }
        boolean done = false;
        while (!done) {
            done = true;
            for (Object ref : pools[0].values()) {
                RefInListFinder.defaultInstance.found = false;
                referent = (PyObject)((Reference)ref).get();
                gc.traverse(referent, RefInListFinder.defaultInstance, pools);
                if (RefInListFinder.defaultInstance.found) continue;
                toProcess.put(referent, ref);
                done = false;
            }
            for (Object ref : toProcess.keySet()) {
                pools[1].remove(ref);
            }
            toProcess.clear();
            done = done && pools[0].size() == pools[1].size();
            tmp = pools[0];
            tmp.clear();
            pools[0] = pools[1];
            pools[1] = tmp;
        }
        return pools[0];
    }

    private static Set<PyObject> findReachables(Iterable<PyObject> pool) {
        IdentityHashMap[] pools = new IdentityHashMap[]{new IdentityHashMap(), new IdentityHashMap()};
        IdentityHashMap toProcess = new IdentityHashMap();
        for (PyObject obj : pool) {
            if (!gc.isTraversable(obj)) continue;
            gc.traverse(obj, ReachableFinder.defaultInstance, pools);
        }
        while (!pools[1].isEmpty()) {
            IdentityHashMap tmp = pools[1];
            pools[1] = toProcess;
            toProcess = tmp;
            pools[0].putAll(toProcess);
            for (PyObject obj : toProcess.keySet()) {
                gc.traverse(obj, ReachableFinder.defaultInstance, pools);
            }
            toProcess.clear();
        }
        return pools[0].keySet();
    }

    private static Set<PyObject> removeNonCyclic(Iterable<PyObject> pool) {
        IdentityHashMap tmp;
        IdentityHashMap[] pools = new IdentityHashMap[]{new IdentityHashMap(), new IdentityHashMap()};
        if (monitorNonTraversable) {
            for (PyObject obj : pool) {
                if (!gc.isTraversable(obj)) continue;
                pools[0].put(obj, obj);
            }
        } else {
            for (PyObject obj : pool) {
                pools[0].put(obj, obj);
            }
        }
        IdentityHashMap toProcess = new IdentityHashMap();
        for (PyObject obj : pools[0].keySet()) {
            gc.traverse(obj, ReachableFinder.defaultInstance, pools);
        }
        while (!pools[1].isEmpty()) {
            tmp = pools[1];
            pools[1] = toProcess;
            toProcess = tmp;
            pools[0].putAll(toProcess);
            for (PyObject obj : toProcess.keySet()) {
                gc.traverse(obj, ReachableFinder.defaultInstance, pools);
            }
            toProcess.clear();
        }
        boolean done = false;
        while (!done) {
            done = true;
            for (PyObject obj : pools[0].keySet()) {
                ObjectInListFinder.defaultInstance.found = false;
                gc.traverse(obj, ObjectInListFinder.defaultInstance, pools);
                if (ObjectInListFinder.defaultInstance.found) continue;
                toProcess.put(obj, obj);
                done = false;
            }
            for (PyObject obj : toProcess.keySet()) {
                pools[1].remove(obj);
            }
            toProcess.clear();
            done = done && pools[0].size() == pools[1].size();
            tmp = pools[0];
            tmp.clear();
            pools[0] = pools[1];
            pools[1] = tmp;
        }
        return pools[0].keySet();
    }

    public static void markCyclicObjects(PyObject start, boolean uncollectable) {
        Set<PyObject> search = gc.findCyclicObjects(start);
        if (search == null) {
            return;
        }
        for (PyObject obj : search) {
            CycleMarkAttr cm = (CycleMarkAttr)JyAttribute.getAttr(obj, (byte)4);
            if (cm == null) {
                cm = new CycleMarkAttr(true, uncollectable);
                JyAttribute.setAttr(obj, (byte)4, cm);
                continue;
            }
            cm.setFlags(true, uncollectable);
        }
    }

    public static Set<PyObject> findCyclicObjects(PyObject start) {
        IdentityHashMap<PyObject, PyObject> map = gc.findCyclicObjectsIntern(start);
        return map == null ? null : map.keySet();
    }

    private static IdentityHashMap<PyObject, PyObject> findCyclicObjectsIntern(PyObject start) {
        if (!gc.isTraversable(start)) {
            return null;
        }
        IdentityHashMap[] reachSearch = new IdentityHashMap[]{new IdentityHashMap(), new IdentityHashMap()};
        IdentityHashMap search = new IdentityHashMap();
        gc.traverse(start, ReachableFinder.defaultInstance, reachSearch);
        IdentityHashMap tmp = search;
        search = reachSearch[1];
        tmp.clear();
        reachSearch[1] = tmp;
        while (!search.isEmpty()) {
            reachSearch[0].putAll(search);
            for (PyObject obj : search.keySet()) {
                gc.traverse(obj, ReachableFinder.defaultInstance, reachSearch);
            }
            tmp = search;
            search = reachSearch[1];
            tmp.clear();
            reachSearch[1] = tmp;
        }
        if (!reachSearch[0].containsKey(start)) {
            return null;
        }
        search.clear();
        search.put(start, start);
        boolean changed = true;
        while (changed) {
            changed = false;
            for (PyObject obj : reachSearch[0].keySet()) {
                if (gc.traverse(obj, RefersToSetFinder.defaultInstance, search.keySet()) != 1) continue;
                changed = true;
                tmp.put(obj, obj);
            }
            search.putAll(tmp);
            for (PyObject key : tmp.keySet()) {
                reachSearch[0].remove(key);
            }
            tmp.clear();
        }
        return search;
    }

    public static int traverse(PyObject ob, Visitproc visit, Object arg) {
        int retVal;
        boolean traversed = false;
        if (ob instanceof Traverseproc) {
            retVal = ((Traverseproc)((Object)ob)).traverse(visit, arg);
            traversed = true;
            if (retVal != 0) {
                return retVal;
            }
        }
        if (ob instanceof TraverseprocDerived) {
            retVal = ((TraverseprocDerived)((Object)ob)).traverseDerived(visit, arg);
            traversed = true;
            if (retVal != 0) {
                return retVal;
            }
        }
        if (!((gcFlags & 0x20) != 0 || ob instanceof Traverseproc || ob instanceof TraverseprocDerived || ob.getClass() == PyObject.class || ob.getClass().isAnnotationPresent(Untraversable.class))) {
            Py.writeWarning(__name__, "The PyObject-subclass " + ob.getClass().getName() + "\n" + "should either implement Traverseproc or be marked with the\n" + "@Untraversable annotation. See the instructions\n" + "in javadoc of org.python.core.Traverseproc.java.");
        }
        if ((gcFlags & 0x10) != 0) {
            return 0;
        }
        Class<?> cls = ob.getClass();
        if (traversed || cls == PyObject.class || cls.isAnnotationPresent(Untraversable.class)) {
            return 0;
        }
        if ((gcFlags & 0x20) == 0) {
            Py.writeWarning(__name__, "Traverse by reflection: " + ob.getClass().getName() + "\n" + "This is an inefficient procedure. It is recommended to\n" + "implement the traverseproc mechanism properly.");
        }
        return gc.traverseByReflection(ob, visit, arg);
    }

    public static int traverseByReflection(Object ob, Visitproc visit, Object arg) {
        IdentityHashMap<Object, Object> alreadyTraversed = new IdentityHashMap<Object, Object>();
        alreadyTraversed.put(ob, ob);
        return gc.traverseByReflectionIntern(ob, alreadyTraversed, visit, arg);
    }

    private static int traverseByReflectionIntern(Object ob, IdentityHashMap<Object, Object> alreadyTraversed, Visitproc visit, Object arg) {
        Class<?> cls = ob.getClass();
        if (cls.isArray() && gc.canLinkToPyObject(cls.getComponentType(), false)) {
            for (int i = 0; i < Array.getLength(ob); ++i) {
                Object element = Array.get(ob, i);
                if (element == null || alreadyTraversed.containsKey(element)) continue;
                alreadyTraversed.put(element, element);
                int result = element instanceof PyObject ? visit.visit((PyObject)element, arg) : gc.traverseByReflectionIntern(element, alreadyTraversed, visit, arg);
                if (result == 0) continue;
                return result;
            }
        } else {
            while (cls != Object.class && cls != PyObject.class) {
                Field[] declFields = cls.getDeclaredFields();
                for (int i = 0; i < declFields.length; ++i) {
                    if (Modifier.isStatic(declFields[i].getModifiers()) || declFields[i].getType().isPrimitive()) continue;
                    if (!declFields[i].isAccessible()) {
                        declFields[i].setAccessible(true);
                    }
                    if (!gc.canLinkToPyObject(declFields[i].getType(), false)) continue;
                    try {
                        Object element = declFields[i].get(ob);
                        if (alreadyTraversed.containsKey(element)) continue;
                        alreadyTraversed.put(element, element);
                        int result = element instanceof PyObject ? visit.visit((PyObject)element, arg) : gc.traverseByReflectionIntern(element, alreadyTraversed, visit, arg);
                        if (result == 0) continue;
                        return result;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                cls = cls.getSuperclass();
            }
        }
        return 0;
    }

    public static boolean canLinkToPyObject(Class<?> cls, boolean actual) {
        int fieldCount;
        if (gc.quickCheckCannotLinkToPyObject(cls)) {
            return false;
        }
        if (!actual && !Modifier.isFinal(cls.getModifiers())) {
            return true;
        }
        if (gc.quickCheckCanLinkToPyObject(cls)) {
            return true;
        }
        if (cls.isInterface() || Modifier.isAbstract(cls.getModifiers())) {
            return true;
        }
        if (cls.isArray()) {
            return gc.canLinkToPyObject(cls.getComponentType(), false);
        }
        Class<?> cls2 = cls;
        for (fieldCount = cls2.getDeclaredFields().length; fieldCount == 0 && cls2 != Object.class; cls2 = cls2.getSuperclass(), fieldCount += cls.getDeclaredFields().length) {
        }
        if (fieldCount == 0) {
            return false;
        }
        IdentityHashMap alreadyChecked = new IdentityHashMap();
        alreadyChecked.put(cls, cls);
        for (cls2 = cls; cls2 != Object.class; cls2 = cls2.getSuperclass()) {
            for (Field f : cls2.getDeclaredFields()) {
                Class<?> ft;
                if (Modifier.isStatic(f.getModifiers()) || (ft = f.getType()).isPrimitive() || alreadyChecked.containsKey(ft)) continue;
                alreadyChecked.put(ft, ft);
                if (!gc.canLinkToPyObjectIntern(ft, alreadyChecked)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean quickCheckCanLinkToPyObject(Class<?> cls) {
        if (!Modifier.isFinal(cls.getModifiers())) {
            return true;
        }
        if (cls.isAssignableFrom(PyObject.class)) {
            return true;
        }
        if (PyObject.class.isAssignableFrom(cls)) {
            return true;
        }
        if (cls.isArray()) {
            return gc.quickCheckCanLinkToPyObject(cls.getComponentType());
        }
        return false;
    }

    private static boolean quickCheckCannotLinkToPyObject(Class<?> cls) {
        if (cls.isPrimitive()) {
            return true;
        }
        if (cls == String.class || cls == Class.class || cls == Field.class || cls == Method.class) {
            return true;
        }
        if (cls.isArray()) {
            return gc.quickCheckCannotLinkToPyObject(cls.getComponentType());
        }
        return false;
    }

    private static boolean canLinkToPyObjectIntern(Class<?> cls, IdentityHashMap<Class<?>, Class<?>> alreadyChecked) {
        if (gc.quickCheckCanLinkToPyObject(cls)) {
            return true;
        }
        if (gc.quickCheckCannotLinkToPyObject(cls)) {
            return false;
        }
        if (cls.isArray()) {
            return gc.canLinkToPyObjectIntern(cls.getComponentType(), alreadyChecked);
        }
        for (Class<?> cls2 = cls; cls2 != Object.class; cls2 = cls2.getSuperclass()) {
            for (Field f : cls2.getDeclaredFields()) {
                Class<?> ft;
                if (Modifier.isStatic(f.getModifiers()) || (ft = f.getType()).isPrimitive() || alreadyChecked.containsKey(ft)) continue;
                alreadyChecked.put(ft, ft);
                if (!gc.canLinkToPyObjectIntern(ft, alreadyChecked)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTraversable(PyObject ob) {
        if (ob == null) {
            return false;
        }
        if (ob instanceof Traverseproc || ob instanceof TraverseprocDerived) {
            return true;
        }
        if ((gcFlags & 0x10) != 0) {
            return false;
        }
        Class<?> cls = ob.getClass();
        return cls != PyObject.class && !cls.isAnnotationPresent(Untraversable.class);
    }

    static {
        finalizeWaitCount = 0;
        initWaitTime = 10;
        defaultWaitFactor = 2;
        lastRemoveTimeStamp = -1L;
        maxWaitTime = initWaitTime;
        gcMonitoredRunCount = 0;
        gcRecallTime = 4000L;
        garbage = new PyList();
        postFinalizationTimeOut = 100L;
        postFinalizationTimestamp = System.currentTimeMillis() - 2L * postFinalizationTimeOut;
        openFinalizeCount = 0;
        postFinalizationPending = false;
        lockPostFinalization = false;
        abortedCyclicFinalizers = 0;
        delayedFinalizationMode = 0;
        notifyRerun = false;
        __doc__enable = new PyString("enable() -> None\n\nEnable automatic garbage collection.\n(does nothing in Jython)\n");
        __doc__disable = new PyString("disable() -> None\n\nDisable automatic garbage collection.\n(raises NotImplementedError in Jython)\n");
        __doc__isenabled = new PyString("isenabled() -> status\n\nReturns true if automatic garbage collection is enabled.\n");
        __doc__collect = new PyString("collect([generation]) -> n\n\nWith no arguments, run a full collection.  The optional argument\nmay be an integer specifying which generation to collect.  A ValueError\nis raised if the generation number is invalid.\n\nThe number of unreachable objects is returned.\n(Jython emulates CPython cyclic trash counting if objects are monitored.\nIf no objects are monitored, returns -2\n");
        __doc__get_count = new PyString("get_count() -> (count0, count1, count2)\n\nReturn the current collection counts\n(raises NotImplementedError in Jython)\n");
        __doc__set_debug = new PyString("set_debug(flags) -> None\n\nSet the garbage collection debugging flags. Debugging information is\nwritten to sys.stderr.\n\nflags is an integer and can have the following bits turned on:\n\n  DEBUG_STATS - Print statistics during collection.\n  DEBUG_COLLECTABLE - Print collectable objects found.\n  DEBUG_UNCOLLECTABLE - Print unreachable but uncollectable objects found.\n  DEBUG_INSTANCES - Print instance objects.\n  DEBUG_OBJECTS - Print objects other than instances.\n  DEBUG_SAVEALL - Save objects to gc.garbage rather than freeing them.\n  DEBUG_LEAK - Debug leaking programs (everything but STATS).\n");
        __doc__get_debug = new PyString("get_debug() -> flags\n\nGet the garbage collection debugging flags.\n");
        __doc__set_thresh = new PyString("set_threshold(threshold0, [threshold1, threshold2]) -> None\n\nSets the collection thresholds.  Setting threshold0 to zero disables\ncollection.\n(raises NotImplementedError in Jython)\n");
        __doc__get_thresh = new PyString("get_threshold() -> (threshold0, threshold1, threshold2)\n\nReturn the current collection thresholds\n(raises NotImplementedError in Jython)\n");
        __doc__get_objects = new PyString("get_objects() -> [...]\n\nReturn a list of objects tracked by the collector (excluding the list\nreturned).\n(raises NotImplementedError in Jython)\n");
        __doc__is_tracked = new PyString("is_tracked(obj) -> bool\n\nReturns true if the object is tracked by the garbage collector.\n(i.e. monitored in Jython)\n");
        __doc__get_referrers = new PyString("get_referrers(*objs) -> list\nReturn the list of objects that directly refer to any of objs.\n(only finds monitored referrers in Jython)");
        __doc__get_referents = new PyString("get_referents(*objs) -> list\nReturn the list of objects that are directly referred to by objs.");
    }

    static class ObjectInListFinder
    implements Visitproc {
        public static ObjectInListFinder defaultInstance = new ObjectInListFinder();
        public boolean found = false;

        ObjectInListFinder() {
        }

        @Override
        public int visit(PyObject object, Object arg) {
            IdentityHashMap[] pools = (IdentityHashMap[])arg;
            if (pools[0].containsKey(object)) {
                pools[1].put(object, object);
                this.found = true;
            }
            return 0;
        }
    }

    static class RefInListFinder
    implements Visitproc {
        public static RefInListFinder defaultInstance = new RefInListFinder();
        public boolean found = false;

        RefInListFinder() {
        }

        @Override
        public int visit(PyObject object, Object arg) {
            IdentityHashMap[] pools = (IdentityHashMap[])arg;
            WeakReferenceGC ref = (WeakReferenceGC)pools[0].get(object);
            if (ref != null) {
                pools[1].put(object, ref);
                this.found = true;
            }
            return 0;
        }
    }

    static class RefersToSetFinder
    implements Visitproc {
        public static RefersToSetFinder defaultInstance = new RefersToSetFinder();

        RefersToSetFinder() {
        }

        @Override
        public int visit(PyObject object, Object arg) {
            return ((Set)arg).contains(object) ? 1 : 0;
        }
    }

    static class ReferrerFinder
    implements Visitproc {
        public static ReferrerFinder defaultInstance = new ReferrerFinder();

        ReferrerFinder() {
        }

        @Override
        public int visit(PyObject object, Object arg) {
            if (((PyObject[])arg)[0].__eq__(object).__nonzero__()) {
                ((PySequenceList)((PyObject[])arg)[1]).pyadd(object);
            }
            return 0;
        }
    }

    static class ReachableFinderWeakRefs
    implements Visitproc {
        public static ReachableFinderWeakRefs defaultInstance = new ReachableFinderWeakRefs();

        ReachableFinderWeakRefs() {
        }

        @Override
        public int visit(PyObject object, Object arg) {
            IdentityHashMap[] pools;
            WeakReferenceGC ref;
            if (gc.isTraversable(object) && (ref = (WeakReferenceGC)(pools = (IdentityHashMap[])arg)[0].get(object)) == null) {
                ref = new WeakReferenceGC(object);
                pools[1].put(object, ref);
            }
            return 0;
        }
    }

    static class ReachableFinder
    implements Visitproc {
        public static ReachableFinder defaultInstance = new ReachableFinder();

        ReachableFinder() {
        }

        @Override
        public int visit(PyObject object, Object arg) {
            IdentityHashMap[] reachSearch = (IdentityHashMap[])arg;
            if (gc.isTraversable(object) && !reachSearch[0].containsKey(object)) {
                reachSearch[1].put(object, object);
            }
            return 0;
        }
    }

    static class ReferentsFinder
    implements Visitproc {
        public static ReferentsFinder defaultInstance = new ReferentsFinder();

        ReferentsFinder() {
        }

        @Override
        public int visit(PyObject object, Object arg) {
            ((PySequenceList)arg).pyadd(object);
            return 0;
        }
    }

    protected static class PostFinalizationProcessor
    implements Runnable {
        protected static PostFinalizationProcessor defaultInstance = new PostFinalizationProcessor();

        protected PostFinalizationProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long current = System.currentTimeMillis();
            while (lockPostFinalization || openFinalizeCount != 0 || current - postFinalizationTimestamp <= postFinalizationTimeOut) {
                try {
                    long time = postFinalizationTimeOut - current + postFinalizationTimestamp;
                    if (openFinalizeCount != 0 || lockPostFinalization || time < 0L) {
                        time = gcRecallTime;
                    }
                    Thread.sleep(time);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                current = System.currentTimeMillis();
            }
            postFinalizationProcessor = null;
            gc.postFinalizationProcess();
            Class<PostFinalizationProcessor> clazz = PostFinalizationProcessor.class;
            synchronized (PostFinalizationProcessor.class) {
                postFinalizationPending = false;
                PostFinalizationProcessor.class.notify();
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
        }
    }

    private static class DelayedFinalizationProcess
    implements Runnable {
        static DelayedFinalizationProcess defaultInstance = new DelayedFinalizationProcess();

        private DelayedFinalizationProcess() {
        }

        private void performFinalization(PyObject del) {
            FinalizeTrigger ft;
            if ((gcFlags & 0x200) != 0) {
                gc.writeDebug(gc.__name__, "delayed finalize of " + del);
            }
            if ((ft = (FinalizeTrigger)JyAttribute.getAttr(del, (byte)127)) != null) {
                ft.performFinalization();
            } else if ((gcFlags & 0x200) != 0) {
                gc.writeDebug(gc.__name__, "no FinalizeTrigger");
            }
        }

        private void restoreFinalizer(PyObject obj, boolean cyclic) {
            CycleMarkAttr cm;
            FinalizeTrigger ft = (FinalizeTrigger)JyAttribute.getAttr(obj, (byte)127);
            FinalizeTrigger.ensureFinalizer(obj);
            boolean notify = false;
            if (ft != null) {
                ((FinalizeTrigger)JyAttribute.getAttr((PyObject)obj, (byte)127)).flags = ft.flags;
                boolean bl = notify = (ft.flags & 1) != 0;
            }
            if ((gcFlags & 0x200) != 0 || (gcFlags & 0x400) != 0) {
                gc.writeDebug(gc.__name__, "restore finalizer of " + obj + ";  cyclic? " + cyclic);
            }
            if ((cm = (CycleMarkAttr)JyAttribute.getAttr(obj, (byte)4)) != null && cm.monitored) {
                gc.monitorObject(obj, true);
            }
            if (notify) {
                if ((gcFlags & 0x200) != 0 || (gcFlags & 0x400) != 0) {
                    gc.writeDebug(gc.__name__, "notify finalizer abort.");
                }
                gc.notifyAbortFinalize(obj, cyclic);
            }
        }

        @Override
        public void run() {
            FinalizeTrigger fn;
            if ((gcFlags & 0x200) != 0) {
                gc.writeDebug(gc.__name__, "run delayed finalization. Index: " + gcMonitoredRunCount);
            }
            Set critics = resurrectionCritics.keySet();
            Set cyclicCritics = gc.removeNonCyclic(critics);
            cyclicCritics.retainAll(critics);
            critics.removeAll(cyclicCritics);
            Set criticReachablePool = gc.findReachables(critics);
            ArrayList<PyObject> criticReachables = new ArrayList<PyObject>();
            if (delayedFinalizationMode == 1) {
                for (PyObject obj : criticReachablePool) {
                    fn = (FinalizeTrigger)JyAttribute.getAttr(obj, (byte)127);
                    if (fn == null || !fn.isActive() || !fn.isFinalized()) continue;
                    criticReachables.add(obj);
                    JyAttribute.setAttr(obj, (byte)5, gcMonitoredRunCount);
                }
            } else {
                for (PyObject obj : criticReachablePool) {
                    fn = (FinalizeTrigger)JyAttribute.getAttr(obj, (byte)127);
                    if (fn == null || !fn.isActive() || !fn.isFinalized()) continue;
                    criticReachables.add(obj);
                }
            }
            critics.removeAll(criticReachables);
            if ((gcFlags & 4) != 0) {
                if ((gcFlags & 0x200) != 0) {
                    gc.writeDebug(gc.__name__, "restore potentially resurrected weak references...");
                }
                for (PyObject rst : criticReachablePool) {
                    GlobalRef toRestore = (GlobalRef)JyAttribute.getAttr(rst, (byte)0);
                    if (toRestore == null) continue;
                    toRestore.restore(rst);
                }
                GlobalRef.processDelayedCallbacks();
            }
            criticReachablePool.clear();
            if ((gcFlags & 8) != 0) {
                if ((gcFlags & 0x200) != 0) {
                    gc.writeDebug(gc.__name__, "restore " + criticReachables.size() + " potentially resurrected finalizers...");
                }
                for (PyObject obj : criticReachables) {
                    CycleMarkAttr cm = (CycleMarkAttr)JyAttribute.getAttr(obj, (byte)4);
                    if (cm != null && cm.isUncollectable()) {
                        this.restoreFinalizer(obj, true);
                        continue;
                    }
                    gc.markCyclicObjects(obj, true);
                    cm = (CycleMarkAttr)JyAttribute.getAttr(obj, (byte)4);
                    this.restoreFinalizer(obj, cm != null && cm.isUncollectable());
                }
            } else {
                if ((gcFlags & 0x200) != 0) {
                    gc.writeDebug(gc.__name__, "delayed finalization of " + criticReachables.size() + " potentially resurrected finalizers...");
                }
                for (PyObject del : criticReachables) {
                    this.performFinalization(del);
                }
            }
            cyclicCritics.removeAll(criticReachables);
            if ((gcFlags & 0x200) != 0 && !delayedFinalizables.isEmpty()) {
                gc.writeDebug(gc.__name__, "process " + delayedFinalizables.size() + " delayed finalizers...");
            }
            for (PyObject del : delayedFinalizables.keySet()) {
                this.performFinalization(del);
            }
            if ((gcFlags & 0x200) != 0 && !cyclicCritics.isEmpty()) {
                gc.writeDebug(gc.__name__, "process " + cyclicCritics.size() + " cyclic delayed finalizers...");
            }
            for (PyObject del : cyclicCritics) {
                this.performFinalization(del);
            }
            if ((gcFlags & 0x200) != 0 && !critics.isEmpty()) {
                gc.writeDebug(gc.__name__, "calling " + critics.size() + " critic finalizers not reachable by other critic finalizers...");
            }
            if (delayedFinalizationMode == 1 && !critics.isEmpty() && !criticReachables.isEmpty()) {
                notifyRerun = true;
            }
            if (delayedFinalizationMode == 2 && !notifyRerun) {
                for (PyObject del : critics) {
                    Object m;
                    if (!notifyRerun && (m = JyAttribute.getAttr(del, (byte)5)) != null && (Integer)m == gcMonitoredRunCount) {
                        notifyRerun = true;
                    }
                    this.performFinalization(del);
                }
            } else {
                for (PyObject del : critics) {
                    this.performFinalization(del);
                }
            }
            delayedFinalizables.clear();
            resurrectionCritics.clear();
            if ((gcFlags & 0x200) != 0) {
                gc.writeDebug(gc.__name__, "delayed finalization run done");
            }
        }
    }

    private static class GCSentinel {
        Thread waiting;

        public GCSentinel(Thread notifyOnFinalize) {
            this.waiting = notifyOnFinalize;
        }

        protected void finalize() throws Throwable {
            if ((gcFlags & 0x80) != 0) {
                gc.writeDebug(gc.__name__, "Sentinel finalizer called...");
            }
            if (lastRemoveTimeStamp != -1L) {
                long diff = maxWaitTime * (long)defaultWaitFactor - System.currentTimeMillis() + lastRemoveTimeStamp;
                while (diff > 0L) {
                    try {
                        Thread.sleep(diff);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    diff = maxWaitTime * (long)defaultWaitFactor - System.currentTimeMillis() + lastRemoveTimeStamp;
                }
            }
            if (this.waiting != null) {
                this.waiting.interrupt();
            }
            if ((gcFlags & 0x80) != 0) {
                gc.writeDebug(gc.__name__, "Sentinel finalizer done");
            }
        }
    }

    private static class WeakrefGCCompareDummy {
        public static WeakrefGCCompareDummy defaultInstance = new WeakrefGCCompareDummy();
        PyObject compare;
        int hashCode;

        private WeakrefGCCompareDummy() {
        }

        public void setCompare(PyObject compare) {
            this.compare = compare;
            this.hashCode = System.identityHashCode(compare);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object ob) {
            if (ob instanceof Reference) {
                return this.compare.equals(((Reference)ob).get());
            }
            if (ob instanceof WeakrefGCCompareDummy) {
                return this.compare.equals(((WeakrefGCCompareDummy)ob).compare);
            }
            return this.compare.equals(ob);
        }
    }

    private static class WeakReferenceGC
    extends WeakReference<PyObject> {
        int hashCode;
        public String str = null;
        public String inst_str = null;
        public String cls;
        boolean isInstance;
        boolean hasFinalizer = false;
        CycleMarkAttr cycleMark;

        WeakReferenceGC(PyObject referent) {
            super(referent);
            this.isInstance = referent instanceof PyInstance;
            this.cycleMark = (CycleMarkAttr)JyAttribute.getAttr(referent, (byte)4);
            this.hashCode = System.identityHashCode(referent);
            this.cls = referent.getClass().getName();
            this.updateHasFinalizer();
        }

        WeakReferenceGC(PyObject referent, ReferenceQueue<Object> q) {
            super(referent, q);
            this.isInstance = referent instanceof PyInstance;
            this.cycleMark = (CycleMarkAttr)JyAttribute.getAttr(referent, (byte)4);
            this.hashCode = System.identityHashCode(referent);
            this.cls = referent.getClass().getName();
            this.updateHasFinalizer();
        }

        public void updateHasFinalizer() {
            PyObject gt = (PyObject)this.get();
            Object fn = JyAttribute.getAttr(gt, (byte)127);
            this.hasFinalizer = fn != null && ((FinalizeTrigger)fn).isActive();
        }

        public void initStr(PyObject referent) {
            PyObject ref = referent;
            if (referent == null) {
                ref = (PyObject)this.get();
            }
            try {
                if (ref instanceof PyInstance) {
                    String name = ((PyInstance)ref).fastGetClass().__name__;
                    if (name == null) {
                        name = "?";
                    }
                    this.inst_str = String.format("<%.100s instance at %s>", name, Py.idstr(ref));
                }
                this.str = String.format("<%.100s %s>", ref.getType().getName(), Py.idstr(ref));
            }
            catch (Exception e) {
                this.str = "<" + ref.getClass().getSimpleName() + " " + System.identityHashCode(ref) + ">";
            }
        }

        public String toString() {
            return this.str;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object ob) {
            if (ob instanceof WeakReferenceGC) {
                return ((PyObject)((WeakReferenceGC)ob).get()).equals(this.get()) && ((WeakReferenceGC)ob).hashCode() == this.hashCode();
            }
            if (ob instanceof WeakrefGCCompareDummy) {
                return ((WeakrefGCCompareDummy)ob).compare != null && ((WeakrefGCCompareDummy)ob).compare.equals(this.get());
            }
            return false;
        }
    }

    public static class CycleMarkAttr {
        private boolean cyclic = false;
        private boolean uncollectable = false;
        public boolean monitored = false;

        CycleMarkAttr() {
        }

        CycleMarkAttr(boolean cyclic, boolean uncollectable) {
            this.cyclic = cyclic;
            this.uncollectable = uncollectable;
        }

        public boolean isCyclic() {
            return this.cyclic || this.uncollectable;
        }

        public boolean isUncollectable() {
            return this.uncollectable;
        }

        public void setFlags(boolean cyclic, boolean uncollectable) {
            this.cyclic = cyclic;
            this.uncollectable = uncollectable;
        }
    }
}

