#!/usr/bin/env python
# -*- coding: ascii -*-
# vim:ts=4:sw=4:softtabstop=4:smarttab:expandtab
"""Test suite for jyjdbc and Apache Derby.

Uses/requires old/original http://stuartbishop.net/Software/DBAPI20TestSuite/
(also see https://launchpad.net/dbapi-compliance).

Does not use the newer (http://code.google.com/p/acute-dbapi/)

For use with Jython 2.5.x. Although also works with patched Jython 2.2 from
https://bitbucket.org/clach04/jython/downloads

Tested with version 10.8.1.2 derby.jar from http://db.apache.org/derby/

Sample usage:

    set CLASSPATH=derby.jar;derbytools.jar
    
    java org.apache.derby.tools.ij
        connect 'jdbc:derby:unittest.derby;create=true';
        exit
        exit;
    
    c:\jython2.5.2\jython test_jyjdbcderby_dbapi20.py
    c:\jython2.5.2\jython test_jyjdbcderby_dbapi20.py test_JyJdbcDerby.test_DATETIME
    c:\jython2.5.2\jython test_jyjdbcderby_dbapi20.py -v test_JyJdbcDerby.test_fetchone
    c:\jython2.5.2\jython test_jyjdbcderby_dbapi20.py -v
    c:\jython2.5.2\jython test_jyjdbcderby_dbapi20.py -v > derbyjyres.txt 2>&1

"""

import unittest
import os
import sys

import mydbapi

import jyjdbc

derby_dbname = 'unittest.derby'
DATABASE_NAME = 'jdbc:derby:%s;create=true' % derby_dbname
# Using memory on my machines gets same results and no difference
# in execution time. Benefit is no temp disk space used.
DATABASE_NAME = 'jdbc:derby:memory:%s;create=true' % derby_dbname
driver_class = 'org.apache.derby.jdbc.EmbeddedDriver'


# assume/hope jdbc driver is in the current directory
tmp_jdbc_jar_path = os.path.join('derby.jar')

# try and add JDBC jar file to CLASSPATH automatically
jarLoad = jyjdbc.classPathHacker()
a = jarLoad.addFile(tmp_jdbc_jar_path)

# Import will fail if classpath is not set correctly (i.e. this is a diagnostic)
from org.apache.derby.jdbc import EmbeddedDriver

if not DATABASE_NAME.startswith('jdbc:derby:memory'):
    print 'TODO rm -rf %s' % derby_dbname
    #os.removedirs(derby_dbname)


class test_JyJdbcDerby(mydbapi.MyDatabaseAPITest):
    driver = jyjdbc
    connect_args = ()
    connect_kw_args = {
                        'dsn': DATABASE_NAME,
                        'driver_name': driver_class,
                        #'debug': True,
                        }
    sql_types = {
                'BLOB': 'BLOB',
                'CLOB': 'CLOB',
                }
    
    def _connect(self):
        result = mydbapi.MyDatabaseAPITest._connect(self)
        timeout_num_secs = 1
        timeout_num_secs = 0  # do NOT timeout
        if timeout_num_secs:
            """Set a very quick time out in case of errors (so failures
            occur sooner and do not delay test completion).
            
            Default run time with zxJDBC and out of box (embedded) settings
            means (52 test) test suite could takes 2223.112s == 37 mins.
            This is NOT an issue with jyjdbc, same hardware with jyjdbc takes
            181 secs (3 mins) as there are no locking issues (and more tests
            pass)"""
            curs = result.cursor()
            curs.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.locks.waitTimeout', '%d')" % timeout_num_secs)
            curs.close()
            del(curs)
        return result
    
    def test_callproc(self):
        self.skip('FIXME needs a Java procedure, see http://wiki.apache.org/db-derby/DerbySQLroutines')


if __name__ == '__main__':
    mydbapi.main()
