#!/usr/bin/env python
# -*- coding: ascii -*-
# vim:ts=4:sw=4:softtabstop=4:smarttab:expandtab
"""Test suite for jyjdbc and SQLite.

Uses/requires old/original http://stuartbishop.net/Software/DBAPI20TestSuite/
(also see https://launchpad.net/dbapi-compliance).

Does not use the newer (http://code.google.com/p/acute-dbapi/)

For use with Jython 2.5.x. Although also works with patched Jython 2.2 from
https://bitbucket.org/clach04/jython/downloads

Suggest running test with Xerial SQLiteJDBC, e.g. sqlite-jdbc-3.7.2.jar
There are other implementations of SQLite for the JVM:

  * original Zentus pure Java sqlitejdbc-v056.jar jyjdbc was originally
    tested with this driver but Xerial is now used as test_simple_blob()
    fails with original Zentus v056. Zentus sqlitejdbc may not be available
    anymore from http://www.zentus.com/sqlitejdbc/
  * http://www.xerial.org/trac/Xerial/wiki/SQLiteJDBC - which is based
    on Zentus pure Java version but also has JNI (C) sqlite implementations
    for some platforms, always falls back to pure Java version if there is
    no native shared library option.
  * http://www.ch-werner.de/javasqlite/ - JNI only (and only supplies source
    code or Win32 binaries). Untested with jyjdbc

Sample usage:

    wget http://www.xerial.org/maven/repository/artifact/org/xerial/sqlite-jdbc/3.7.2/sqlite-jdbc-3.7.2.jar
    
    set CLASSPATH=sqlite-jdbc-3.7.2.jar
    set JYTHONPATH=%CLASSPATH%
    c:\jython2.5.2\jython test_jyjdbcsqlite_dbapi20.py
    
    export CLASSPATH=sqlite-jdbc-3.7.2.jar
    export JYTHONPATH=$CLASSPATH
    jython test_jyjdbcsqlite_dbapi20.py
    
    jython test_jyjdbcsqlite_dbapi20.py -v test_JyjdbcSQLite.test_simple_blob
    java -jar jython.jar test_jyjdbcsqlite_dbapi20.py -v test_JyjdbcSQLite.test_simple_blob
    /usr/lib/jvm/java-6-sun-1.6.0.26/bin/java -jar jython.jar test_jyjdbcsqlite_dbapi20.py -v test_JyjdbcSQLite.test_simple_blob


    java -Dpython.console=org.python.util.InteractiveConsole -Xmx512m -Xss1152k  -classpath "C:\jython2.5.2\jython.jar;%CLASSPATH%" org.python.util.jython  test_jyjdbcsqlite_dbapi20.py
    
    etc.

"""

import os
import sys

import mydbapi

try:
    import jyjdbc
except ImportError:
    # If this is for testing Python sqlite3 module
    # this isn't a problem
    jyjdbc = None

# assume/hope jdbc driver is in the current directory
tmp_jdbc_jar_path = os.path.join('sqlite-jdbc-3.7.2.jar')

# try and add JDBC jar file to CLASSPATH automatically
jarLoad = jyjdbc.classPathHacker()
a = jarLoad.addFile(tmp_jdbc_jar_path)

# Import will fail if classpath is not set correctly (i.e. this is a diagnostic)
from org.sqlite import JDBC


# global database name
DATABASE_NAME = 'jdbc:sqlite::memory:'  # one test needs a persistent connection
DATABASE_NAME = 'jdbc:sqlite:unittest.sqlite3'  # persistent database needed for test_close_rollback


class test_JyjdbcSQLite(mydbapi.MyDatabaseAPITest):
    """Expected failures, due to the way sqlite3 behaves:
    
    TODO implement "pass" tests for below?
      * test_description - typeless so no string type specified
        from JDBC (and jyjdbc deliberately does NOT default to string)
      * test_ROWID - typeless so no ROWID type 
      * test_Binary - typeless so no ROWID type
    """
    driver = jyjdbc
    connect_args = ()
    connect_kw_args = {
                        'dsn': DATABASE_NAME,
                        'driver_name': None,  # Name is optional
                        #'driver_name': 'org.sqlite.JDBC',
                        #'debug': True,
                        }
    sql_types = {
                'BLOB': 'BLOB',
                'CLOB': 'CLOB',
                }
    
    def test_callproc(self):
        self.skip('SQLite does not support Stored Procedures')
    
    def test_interval_type_day_to_second(self):
        self.skip('SQLite does not support INTERVAL types')


if __name__ == '__main__':
    mydbapi.main()
