/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.ejb;

import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBMetaData;
import jakarta.ejb.EJBObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EJBInvokerJob
implements Job {
    public static final String EJB_JNDI_NAME_KEY = "ejb";
    public static final String EJB_METHOD_KEY = "method";
    public static final String EJB_ARG_TYPES_KEY = "argTypes";
    public static final String EJB_ARGS_KEY = "args";
    public static final String INITIAL_CONTEXT_FACTORY = "java.naming.factory.initial";
    public static final String PROVIDER_URL = "java.naming.provider.url";
    public static final String PRINCIPAL = "java.naming.security.principal";
    public static final String CREDENTIALS = "java.naming.security.credentials";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getMergedJobDataMap();
        String ejb = dataMap.getString(EJB_JNDI_NAME_KEY);
        String method = dataMap.getString(EJB_METHOD_KEY);
        Object[] arguments = (Object[])dataMap.get((Object)EJB_ARGS_KEY);
        if (arguments == null) {
            arguments = new Object[]{};
        }
        if (ejb == null) {
            throw new JobExecutionException();
        }
        InitialContext jndiContext = null;
        try {
            jndiContext = this.getInitialContext(dataMap);
        }
        catch (NamingException ne) {
            throw new JobExecutionException((Throwable)ne);
        }
        try {
            Object value = null;
            try {
                value = jndiContext.lookup(ejb);
            }
            catch (NamingException ne) {
                throw new JobExecutionException((Throwable)ne);
            }
            EJBHome ejbHome = (EJBHome)PortableRemoteObject.narrow((Object)value, EJBHome.class);
            EJBMetaData metaData = null;
            try {
                metaData = ejbHome.getEJBMetaData();
            }
            catch (RemoteException re) {
                throw new JobExecutionException((Throwable)re);
            }
            Class homeClass = metaData.getHomeInterfaceClass();
            Class remoteClass = metaData.getRemoteInterfaceClass();
            ejbHome = (EJBHome)PortableRemoteObject.narrow((Object)ejbHome, (Class)homeClass);
            Method methodCreate = null;
            try {
                methodCreate = homeClass.getMethod("create", null);
            }
            catch (NoSuchMethodException nsme) {
                throw new JobExecutionException((Throwable)nsme);
            }
            EJBObject remoteObj = null;
            try {
                remoteObj = (EJBObject)methodCreate.invoke((Object)ejbHome, (Object[])null);
            }
            catch (IllegalAccessException iae) {
                throw new JobExecutionException((Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                throw new JobExecutionException((Throwable)ite);
            }
            Method methodExecute = null;
            try {
                Class[] argTypes = (Class[])dataMap.get((Object)EJB_ARG_TYPES_KEY);
                if (argTypes == null) {
                    argTypes = new Class[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        argTypes[i] = arguments[i].getClass();
                    }
                }
                methodExecute = remoteClass.getMethod(method, argTypes);
            }
            catch (NoSuchMethodException nsme) {
                throw new JobExecutionException((Throwable)nsme);
            }
            try {
                Object returnObj = methodExecute.invoke((Object)remoteObj, arguments);
                context.setResult(returnObj);
            }
            catch (IllegalAccessException iae) {
                throw new JobExecutionException((Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                throw new JobExecutionException((Throwable)ite);
            }
        }
        finally {
            if (jndiContext != null) {
                try {
                    jndiContext.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    protected InitialContext getInitialContext(JobDataMap jobDataMap) throws NamingException {
        String credentials;
        String principal;
        String providerUrl;
        Hashtable<String, String> params = new Hashtable<String, String>(2);
        String initialContextFactory = jobDataMap.getString(INITIAL_CONTEXT_FACTORY);
        if (initialContextFactory != null) {
            params.put(INITIAL_CONTEXT_FACTORY, initialContextFactory);
        }
        if ((providerUrl = jobDataMap.getString(PROVIDER_URL)) != null) {
            params.put(PROVIDER_URL, providerUrl);
        }
        if ((principal = jobDataMap.getString(PRINCIPAL)) != null) {
            params.put(PRINCIPAL, principal);
        }
        if ((credentials = jobDataMap.getString(CREDENTIALS)) != null) {
            params.put(CREDENTIALS, credentials);
        }
        return params.size() == 0 ? new InitialContext() : new InitialContext(params);
    }
}

