/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.core;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.MimeMultipart;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.raml.jaxrs.codegen.core.Configuration;
import org.raml.jaxrs.codegen.core.Context;
import org.raml.jaxrs.codegen.core.Generator;
import org.raml.jaxrs.codegen.core.Names;
import org.raml.jaxrs.codegen.core.Types;
import org.raml.jaxrs.codegen.core.ext.GeneratorExtension;
import org.raml.jaxrs.codegen.core.ext.InterfaceNameBuilderExtension;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.Response;
import org.raml.model.parameter.AbstractParam;
import org.raml.model.parameter.FormParameter;
import org.raml.parser.loader.ClassPathResourceLoader;
import org.raml.parser.loader.CompositeResourceLoader;
import org.raml.parser.loader.FileResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.loader.UrlResourceLoader;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlDocumentBuilder;
import org.raml.parser.visitor.RamlValidationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenerator {
    protected static final String DEFAULT_ANNOTATION_PARAMETER = "value";
    protected static final Logger LOGGER = LoggerFactory.getLogger(Generator.class);
    protected Context context;
    protected Types types;
    protected List<GeneratorExtension> extensions;

    private ResourceLoader[] prepareResourceLoaders(Configuration configuration, String location) {
        String sourceDirAbsPath;
        File sourceDirectory = configuration.getSourceDirectory();
        ArrayList<ResourceLoader> loaderList = new ArrayList<ResourceLoader>(Arrays.asList(new UrlResourceLoader(), new ClassPathResourceLoader()));
        if (sourceDirectory != null) {
            sourceDirAbsPath = sourceDirectory.getAbsolutePath();
            loaderList.add((ResourceLoader)new FileResourceLoader(sourceDirAbsPath));
        }
        if (location != null && location.length() > 0) {
            String fl;
            sourceDirAbsPath = sourceDirectory.getAbsolutePath();
            if (sourceDirAbsPath.endsWith(fl = new File(location).getParent())) {
                sourceDirAbsPath = sourceDirAbsPath.substring(0, sourceDirAbsPath.length() - fl.length());
                loaderList.add((ResourceLoader)new FileResourceLoader(sourceDirAbsPath));
                loaderList.add((ResourceLoader)new FileResourceLoader(sourceDirectory){

                    public InputStream fetchResource(String resourceName) {
                        File includedFile = new File(resourceName);
                        InputStream inputStream = null;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(String.format("Looking for resource: %s on directory: %s...", resourceName));
                        }
                        try {
                            return new FileInputStream(includedFile);
                        }
                        catch (FileNotFoundException e) {
                            return inputStream;
                        }
                    }
                });
            } else {
                loaderList.add((ResourceLoader)new FileResourceLoader(location));
                loaderList.add((ResourceLoader)new FileResourceLoader(""));
            }
        }
        ResourceLoader[] loaderArray = loaderList.toArray(new ResourceLoader[loaderList.size()]);
        return loaderArray;
    }

    private void validate(Configuration configuration) {
        Validate.notNull((Object)configuration, (String)"configuration can't be null");
        File outputDirectory = configuration.getOutputDirectory();
        Validate.notNull((Object)outputDirectory, (String)"outputDirectory can't be null");
        Validate.isTrue((boolean)outputDirectory.isDirectory(), (String)(outputDirectory + " is not a pre-existing directory"));
        Validate.isTrue((boolean)outputDirectory.canWrite(), (String)(outputDirectory + " can't be written to"));
        if (outputDirectory.listFiles().length > 0) {
            LOGGER.warn("Directory " + outputDirectory + " is not empty, generation will work but pre-existing files may remain and produce unexpected results");
        }
        Validate.notEmpty((String)configuration.getBasePackageName(), (String)"base package name can't be empty");
    }

    public Set<String> run(Reader raml, Configuration configuration) throws Exception {
        System.out.println("relative includes are not supported in this mode!");
        return this.run(raml, configuration, "");
    }

    protected Set<String> run(Raml raml, Configuration configuration) throws Exception {
        this.validate(configuration);
        this.extensions = configuration.getExtensions();
        this.context = new Context(configuration, raml);
        this.types = new Types(this.context);
        for (GeneratorExtension e : this.extensions) {
            e.setRaml(raml);
            e.setCodeModel(this.context.getCodeModel());
        }
        Collection<Resource> resources = raml.getResources().values();
        this.types.generateClassesFromXmlSchemas(resources);
        for (Resource resource : resources) {
            this.createResourceInterface(resource, raml, configuration);
        }
        return this.context.generate();
    }

    protected void createResourceInterface(Resource resource, Raml raml, Configuration config) throws Exception {
        String resourceInterfaceName = null;
        for (GeneratorExtension e : this.extensions) {
            InterfaceNameBuilderExtension inbe;
            if (e instanceof InterfaceNameBuilderExtension && (resourceInterfaceName = (inbe = (InterfaceNameBuilderExtension)e).buildResourceInterfaceName(resource)) != null) break;
        }
        if (resourceInterfaceName == null) {
            resourceInterfaceName = Names.buildResourceInterfaceName(resource, config);
        }
        JDefinedClass resourceInterface = this.context.createResourceInterface(resourceInterfaceName);
        this.context.setCurrentResourceInterface(resourceInterface);
        String path = StringUtils.strip((String)resource.getRelativeUri(), (String)"/");
        resourceInterface.annotate(Path.class).param(DEFAULT_ANNOTATION_PARAMETER, StringUtils.defaultIfBlank((String)path, (String)"/"));
        if (StringUtils.isNotBlank((String)resource.getDescription())) {
            resourceInterface.javadoc().add((Object)resource.getDescription());
        }
        this.addResourceMethods(resource, resourceInterface, path);
        for (GeneratorExtension e : this.extensions) {
            e.onCreateResourceInterface(resourceInterface, resource);
        }
    }

    protected void addResourceMethods(Resource resource, JDefinedClass resourceInterface, String resourceInterfacePath) throws Exception {
        for (Action action : resource.getActions().values()) {
            if (!action.hasBody()) {
                this.addResourceMethods(resourceInterface, resource, resourceInterfacePath, action, null, false);
                continue;
            }
            if (action.getBody().size() == 1) {
                MimeType bodyMimeType = (MimeType)action.getBody().values().iterator().next();
                this.addResourceMethods(resourceInterface, resource, resourceInterfacePath, action, bodyMimeType, false);
                continue;
            }
            for (MimeType bodyMimeType : action.getBody().values()) {
                this.addResourceMethods(resourceInterface, resource, resourceInterfacePath, action, bodyMimeType, true);
            }
        }
        for (Resource childResource : resource.getResources().values()) {
            this.addResourceMethods(childResource, resourceInterface, resourceInterfacePath);
        }
    }

    protected Collection<MimeType> getUniqueResponseMimeTypes(Action action) {
        HashMap<String, MimeType> responseMimeTypes = new HashMap<String, MimeType>();
        for (Response response : action.getResponses().values()) {
            if (!response.hasBody()) continue;
            for (MimeType responseMimeType : response.getBody().values()) {
                if (responseMimeType == null) continue;
                responseMimeTypes.put(responseMimeType.getType(), responseMimeType);
            }
        }
        return responseMimeTypes.values();
    }

    protected abstract void addResourceMethod(JDefinedClass var1, Resource var2, String var3, Action var4, MimeType var5, boolean var6, Collection<MimeType> var7) throws Exception;

    protected void addParamAnnotation(String resourceInterfacePath, Action action, JMethod method) {
        String path = StringUtils.substringAfter((String)action.getResource().getUri(), (String)(resourceInterfacePath + "/"));
        if (StringUtils.isNotBlank((String)path)) {
            method.annotate(Path.class).param(DEFAULT_ANNOTATION_PARAMETER, path);
        }
    }

    private void addCatchAllFormParametersArgument(MimeType bodyMimeType, JMethod method, JDocComment javadoc, JType argumentType) {
        method.param(argumentType, "entity");
        Map formParameters = bodyMimeType.getFormParameters();
        if (formParameters != null) {
            for (Map.Entry namedFormParameters : formParameters.entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append((String)namedFormParameters.getKey()).append(": ");
                for (FormParameter formParameter : (List)namedFormParameters.getValue()) {
                    this.appendParameterJavadocDescription((AbstractParam)formParameter, sb);
                }
                javadoc.addParam("entity").add((Object)sb.toString());
            }
        }
    }

    protected void addParameterJavaDoc(AbstractParam parameter, String parameterName, JDocComment javadoc) {
        javadoc.addParam(parameterName).add((Object)(StringUtils.defaultString((String)parameter.getDescription()) + this.getPrefixedExampleOrBlank(parameter.getExample())));
    }

    protected String getPrefixedExampleOrBlank(String example) {
        return StringUtils.isNotBlank((String)example) ? " e.g. " + example : "";
    }

    protected void appendParameterJavadocDescription(AbstractParam param, StringBuilder sb) {
        if (StringUtils.isNotBlank((String)param.getDisplayName())) {
            sb.append(param.getDisplayName());
        }
        if (StringUtils.isNotBlank((String)param.getDescription())) {
            if (sb.length() > 0) {
                sb.append(" - ");
            }
            sb.append(param.getDescription());
        }
        if (StringUtils.isNotBlank((String)param.getExample())) {
            sb.append(" e.g. ").append(param.getExample());
        }
        sb.append("<br/>\n");
    }

    private void addPlainBodyArgument(MimeType bodyMimeType, JMethod method, JDocComment javadoc) throws IOException {
        method.param(this.types.getRequestEntityClass(bodyMimeType), "entity");
        javadoc.addParam("entity").add((Object)this.getPrefixedExampleOrBlank(bodyMimeType.getExample()));
    }

    private boolean hasAMultiTypeFormParameter(MimeType bodyMimeType) {
        for (List formParameters : bodyMimeType.getFormParameters().values()) {
            if (formParameters.size() <= 1) continue;
            return true;
        }
        return false;
    }

    protected void addFormParameters(MimeType bodyMimeType, JMethod method, JDocComment javadoc) throws Exception {
        if (this.hasAMultiTypeFormParameter(bodyMimeType)) {
            JClass type = this.types.getGeneratorClass(MultivaluedMap.class).narrow(new Class[]{String.class, String.class});
            this.addCatchAllFormParametersArgument(bodyMimeType, method, javadoc, (JType)type);
        } else {
            for (Map.Entry namedFormParameters : bodyMimeType.getFormParameters().entrySet()) {
                this.addParameter((String)namedFormParameters.getKey(), (AbstractParam)((List)namedFormParameters.getValue()).get(0), FormParam.class, method, javadoc);
            }
        }
    }

    protected void addConsumesAnnotation(MimeType bodyMimeType, JMethod method) {
        if (bodyMimeType != null) {
            method.annotate(Consumes.class).param(DEFAULT_ANNOTATION_PARAMETER, bodyMimeType.getType());
        }
    }

    protected void addProducesAnnotation(Collection<MimeType> uniqueResponseMimeTypes, JMethod method) {
        if (uniqueResponseMimeTypes.isEmpty()) {
            return;
        }
        JAnnotationArrayMember paramArray = method.annotate(Produces.class).paramArray(DEFAULT_ANNOTATION_PARAMETER);
        for (MimeType responseMimeType : uniqueResponseMimeTypes) {
            paramArray.param(responseMimeType.getType());
        }
    }

    protected void addBodyParameters(MimeType bodyMimeType, JMethod method, JDocComment javadoc) throws Exception {
        if (bodyMimeType == null) {
            return;
        }
        if ("application/x-www-form-urlencoded".equals(bodyMimeType.getType())) {
            this.addFormParameters(bodyMimeType, method, javadoc);
        } else if ("multipart/form-data".equals(bodyMimeType.getType())) {
            this.addCatchAllFormParametersArgument(bodyMimeType, method, javadoc, this.types.getGeneratorType(MimeMultipart.class));
        } else {
            this.addPlainBodyArgument(bodyMimeType, method, javadoc);
        }
    }

    protected void addPathParameters(Action action, JMethod method, JDocComment javadoc) throws Exception {
        this.addAllResourcePathParameters(action.getResource(), method, javadoc);
    }

    private void addAllResourcePathParameters(Resource resource, JMethod method, JDocComment javadoc) throws Exception {
        for (Map.Entry namedUriParameter : resource.getUriParameters().entrySet()) {
            this.addParameter((String)namedUriParameter.getKey(), (AbstractParam)namedUriParameter.getValue(), PathParam.class, method, javadoc);
        }
        Resource parentResource = resource.getParentResource();
        if (parentResource != null) {
            this.addAllResourcePathParameters(parentResource, method, javadoc);
        }
    }

    protected void addHeaderParameters(Action action, JMethod method, JDocComment javadoc) throws Exception {
        for (Map.Entry namedHeaderParameter : action.getHeaders().entrySet()) {
            this.addParameter((String)namedHeaderParameter.getKey(), (AbstractParam)namedHeaderParameter.getValue(), HeaderParam.class, method, javadoc);
        }
    }

    protected JDocComment addBaseJavaDoc(Action action, JMethod method) {
        JDocComment javadoc = method.javadoc();
        if (StringUtils.isNotBlank((String)action.getDescription())) {
            javadoc.add((Object)action.getDescription());
        }
        return javadoc;
    }

    protected void addQueryParameters(Action action, JMethod method, JDocComment javadoc) throws Exception {
        for (Map.Entry namedQueryParameter : action.getQueryParameters().entrySet()) {
            this.addParameter((String)namedQueryParameter.getKey(), (AbstractParam)namedQueryParameter.getValue(), QueryParam.class, method, javadoc);
        }
    }

    private void addParameter(String name, AbstractParam parameter, Class<? extends Annotation> annotationClass, JMethod method, JDocComment javadoc) throws Exception {
        if (this.context.getConfiguration().getIgnoredParameterNames().contains(name)) {
            return;
        }
        for (GeneratorExtension e : this.extensions) {
            if (e.AddParameterFilter(name, parameter, annotationClass, method)) continue;
            return;
        }
        String argumentName = Names.buildVariableName(name);
        JVar argumentVariable = method.param(this.types.buildParameterType(parameter, argumentName), argumentName);
        argumentVariable.annotate(annotationClass).param(DEFAULT_ANNOTATION_PARAMETER, name);
        if (parameter.getDefaultValue() != null) {
            argumentVariable.annotate(DefaultValue.class).param(DEFAULT_ANNOTATION_PARAMETER, parameter.getDefaultValue());
        }
        if (this.context.getConfiguration().isUseJsr303Annotations()) {
            this.addJsr303Annotations(parameter, argumentVariable);
        }
        this.addParameterJavaDoc(parameter, argumentVariable.name(), javadoc);
    }

    private void addJsr303Annotations(AbstractParam parameter, JVar argumentVariable) {
        BigDecimal maximum;
        BigDecimal minimum;
        if (StringUtils.isNotBlank((String)parameter.getPattern())) {
            JAnnotationUse patternAnnotation = argumentVariable.annotate(Pattern.class);
            patternAnnotation.param("regexp", parameter.getPattern());
        }
        Integer minLength = parameter.getMinLength();
        Integer maxLength = parameter.getMaxLength();
        if (minLength != null || maxLength != null) {
            JAnnotationUse sizeAnnotation = argumentVariable.annotate(Size.class);
            if (minLength != null) {
                sizeAnnotation.param("min", minLength.intValue());
            }
            if (maxLength != null) {
                sizeAnnotation.param("max", maxLength.intValue());
            }
        }
        if ((minimum = parameter.getMinimum()) != null) {
            this.addMinMaxConstraint(parameter, "minimum", Min.class, minimum, argumentVariable);
        }
        if ((maximum = parameter.getMaximum()) != null) {
            this.addMinMaxConstraint(parameter, "maximum", Max.class, maximum, argumentVariable);
        }
        if (parameter.isRequired()) {
            argumentVariable.annotate(NotNull.class);
        }
    }

    private void addMinMaxConstraint(AbstractParam parameter, String name, Class<? extends Annotation> clazz, BigDecimal value, JVar argumentVariable) {
        try {
            long boundary = value.longValueExact();
            argumentVariable.annotate(clazz).param(DEFAULT_ANNOTATION_PARAMETER, boundary);
        }
        catch (ArithmeticException ae) {
            LOGGER.info("Non integer " + name + " constraint ignored for parameter: " + ToStringBuilder.reflectionToString((Object)parameter, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE));
        }
    }

    private void addResourceMethods(JDefinedClass resourceInterface, Resource resource, String resourceInterfacePath, Action action, MimeType bodyMimeType, boolean addBodyMimeTypeInMethodName) throws Exception {
        Collection<MimeType> uniqueResponseMimeTypes = this.getUniqueResponseMimeTypes(action);
        this.addResourceMethod(resourceInterface, resource, resourceInterfacePath, action, bodyMimeType, addBodyMimeTypeInMethodName, uniqueResponseMimeTypes);
    }

    protected static String toDetailedString(ValidationResult item) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t");
        stringBuilder.append(item.getLevel());
        stringBuilder.append(" ");
        stringBuilder.append(item.getMessage());
        if (item.getLine() != -1) {
            stringBuilder.append(" (line ");
            stringBuilder.append(item.getLine());
            if (item.getStartColumn() != -1) {
                stringBuilder.append(", col ");
                stringBuilder.append(item.getStartColumn());
                if (item.getEndColumn() != item.getStartColumn()) {
                    stringBuilder.append(" to ");
                    stringBuilder.append(item.getEndColumn());
                }
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public Set<String> run(Reader ramlReader, Configuration configuration, String readerLocation) throws Exception {
        if (StringUtils.isNotBlank((String)configuration.getAsyncResourceTrait()) && configuration.getJaxrsVersion() == Configuration.JaxrsVersion.JAXRS_1_1) {
            throw new IllegalArgumentException("Asynchronous resources are not supported in JAX-RS 1.1");
        }
        String ramlBuffer = IOUtils.toString((Reader)ramlReader);
        String folder = new File(readerLocation).getParent();
        ResourceLoader[] loaderArray = this.prepareResourceLoaders(configuration, folder);
        List results = RamlValidationService.createDefault((ResourceLoader)new CompositeResourceLoader(loaderArray), (TagResolver[])new TagResolver[0]).validate(ramlBuffer, readerLocation);
        if (ValidationResult.areValid((List)results)) {
            return this.run((Raml)new RamlDocumentBuilder((ResourceLoader)new CompositeResourceLoader(loaderArray), new TagResolver[0]).build(ramlBuffer, readerLocation), configuration);
        }
        List validationErrors = Lists.transform((List)results, (Function)new Function<ValidationResult, String>(){

            public String apply(ValidationResult vr) {
                return AbstractGenerator.toDetailedString(vr);
            }
        });
        throw new IllegalArgumentException("Invalid RAML definition:\n" + StringUtils.join((Collection)validationErrors, (String)"\n"));
    }
}

