/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.core;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.raml.jaxrs.codegen.core.AbstractGenerator;
import org.raml.jaxrs.codegen.core.Names;
import org.raml.jaxrs.codegen.core.ext.GeneratorExtension;
import org.raml.jaxrs.codegen.core.ext.MethodNameBuilderExtension;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Resource;

public class ClientGenerator
extends AbstractGenerator {
    @Override
    protected void addResourceMethod(JDefinedClass resourceInterface, Resource resource, String resourceInterfacePath, Action action, MimeType bodyMimeType, boolean addBodyMimeTypeInMethodName, Collection<MimeType> uniqueResponseMimeTypes) throws Exception {
        MimeType actualBodyMimeType = addBodyMimeTypeInMethodName ? bodyMimeType : null;
        String methodName = null;
        if (this.extensions != null) {
            for (GeneratorExtension ext : this.extensions) {
                if (!(ext instanceof MethodNameBuilderExtension)) continue;
                methodName = ((MethodNameBuilderExtension)ext).buildResourceMethodName(action, actualBodyMimeType, resource);
                break;
            }
        }
        if (methodName == null) {
            methodName = Names.buildResourceMethodName(action, actualBodyMimeType);
        }
        JType resourceMethodReturnType = this.getResourceMethodReturnType(methodName, action, uniqueResponseMimeTypes.isEmpty(), false, resourceInterface);
        JMethod method = this.context.createResourceMethod(resourceInterface, methodName, resourceMethodReturnType);
        this.context.addHttpMethodAnnotation(action.getType().toString(), (JAnnotatable)method);
        this.addParamAnnotation(resourceInterfacePath, action, method);
        this.addConsumesAnnotation(bodyMimeType, method);
        this.addProducesAnnotation(uniqueResponseMimeTypes, method);
        JDocComment javadoc = this.addBaseJavaDoc(action, method);
        this.addParameters(action, bodyMimeType, method, javadoc);
        for (GeneratorExtension e : this.extensions) {
            e.onAddResourceMethod(method, action, bodyMimeType, uniqueResponseMimeTypes);
        }
    }

    private void addParameters(Action action, MimeType bodyMimeType, JMethod method, JDocComment javadoc) throws Exception {
        this.addPathParameters(action, method, javadoc);
        this.addHeaderParameters(action, method, javadoc);
        this.addQueryParameters(action, method, javadoc);
        this.addBodyParameters(bodyMimeType, method, javadoc);
    }

    private JType getResourceMethodReturnType(String methodName, Action action, boolean empty, boolean async, JDefinedClass resourceInterface) {
        if (empty && this.context.getConfiguration().isEmptyResponseReturnVoid()) {
            return this.types.getGeneratorType(Response.Status.class);
        }
        return this.context.ref(Response.class.getName());
    }
}

