/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.DefaultGenerationConfig;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.NoopAnnotator;
import org.raml.jaxrs.codegen.core.ext.GeneratorExtension;

public class Configuration {
    private File outputDirectory;
    private JaxrsVersion jaxrsVersion = JaxrsVersion.JAXRS_1_1;
    private String basePackageName;
    private String modelPackageName = "model";
    private boolean useJsr303Annotations = false;
    private AnnotationStyle jsonMapper = AnnotationStyle.JACKSON1;
    private File sourceDirectory;
    private Class methodThrowException = Exception.class;
    private Map<String, String> jsonMapperConfiguration;
    private String asyncResourceTrait;
    private boolean emptyResponseReturnVoid;
    private boolean generateClientInterface;
    private Class customAnnotator = NoopAnnotator.class;
    private String restIFPackageName = "resource";
    private String interfaceNameSuffix = "Resource";
    private ArrayList<String> ignoredParameterNames = new ArrayList();
    private boolean useTitlePropertyWhenPossible;
    private List<GeneratorExtension> extensions = new ArrayList<GeneratorExtension>();

    public ArrayList<String> getIgnoredParameterNames() {
        return this.ignoredParameterNames;
    }

    public void setIgnoredParameterNames(ArrayList<String> ignoredParameterNames) {
        this.ignoredParameterNames = ignoredParameterNames;
    }

    public boolean isUseTitlePropertyWhenPossible() {
        return this.useTitlePropertyWhenPossible;
    }

    public void setUseTitlePropertyWhenPossible(boolean useTitlePropertyWhenPossible) {
        this.useTitlePropertyWhenPossible = useTitlePropertyWhenPossible;
    }

    public boolean isGenerateClientInterface() {
        return this.generateClientInterface;
    }

    public void setGenerateClientInterface(boolean generateClientInterface) {
        this.generateClientInterface = generateClientInterface;
    }

    public String getAsyncResourceTrait() {
        return this.asyncResourceTrait;
    }

    public void setAsyncResourceTrait(String asyncResourceTrait) {
        this.asyncResourceTrait = asyncResourceTrait;
    }

    public GenerationConfig createJsonSchemaGenerationConfig() {
        return new DefaultGenerationConfig(){

            public AnnotationStyle getAnnotationStyle() {
                return Configuration.this.jsonMapper;
            }

            public boolean isIncludeJsr303Annotations() {
                return Configuration.this.useJsr303Annotations;
            }

            public boolean isUseCommonsLang3() {
                return this.getConfiguredValue("useCommonsLang3", false);
            }

            public boolean isGenerateBuilders() {
                return this.getConfiguredValue("generateBuilders", true);
            }

            public boolean isIncludeHashcodeAndEquals() {
                return this.getConfiguredValue("includeHashcodeAndEquals", false);
            }

            public Class getCustomAnnotator() {
                return Configuration.this.customAnnotator;
            }

            public boolean isIncludeToString() {
                return this.getConfiguredValue("includeToString", false);
            }

            public boolean isUseLongIntegers() {
                return this.getConfiguredValue("useLongIntegers", false);
            }

            public boolean isIncludeConstructors() {
                return this.getConfiguredValue("includeConstructors", super.isIncludeConstructors());
            }

            public boolean isConstructorsRequiredPropertiesOnly() {
                return this.getConfiguredValue("constructorsRequiredPropertiesOnly", super.isConstructorsRequiredPropertiesOnly());
            }

            public boolean isIncludeAccessors() {
                return this.getConfiguredValue("includeAccessors", super.isIncludeAccessors());
            }

            private boolean getConfiguredValue(String key, boolean def) {
                if (Configuration.this.jsonMapperConfiguration == null || Configuration.this.jsonMapperConfiguration.isEmpty()) {
                    return def;
                }
                String val = (String)Configuration.this.jsonMapperConfiguration.get(key);
                return val != null ? Boolean.parseBoolean(val) : def;
            }
        };
    }

    public Class getCustomAnnotator() {
        return this.customAnnotator;
    }

    public void setCustomAnnotator(Class customAnnotator) {
        this.customAnnotator = customAnnotator;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public JaxrsVersion getJaxrsVersion() {
        return this.jaxrsVersion;
    }

    public void setJaxrsVersion(JaxrsVersion jaxrsVersion) {
        this.jaxrsVersion = jaxrsVersion;
    }

    public String getBasePackageName() {
        return this.basePackageName;
    }

    public void setBasePackageName(String basePackageName) {
        this.basePackageName = basePackageName;
    }

    public String getModelPackageName() {
        return this.modelPackageName;
    }

    public void setModelPackageName(String modelPackageName) {
        this.modelPackageName = modelPackageName;
    }

    public boolean isUseJsr303Annotations() {
        return this.useJsr303Annotations;
    }

    public void setUseJsr303Annotations(boolean useJsr303Annotations) {
        this.useJsr303Annotations = useJsr303Annotations;
    }

    public AnnotationStyle getJsonMapper() {
        return this.jsonMapper;
    }

    public void setJsonMapper(AnnotationStyle jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    public Class getMethodThrowException() {
        return this.methodThrowException;
    }

    public void setMethodThrowException(Class methodThrowException) {
        this.methodThrowException = methodThrowException;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public Map<String, String> getJsonMapperConfiguration() {
        return this.jsonMapperConfiguration;
    }

    public void setJsonMapperConfiguration(Map<String, String> jsonMapperConfiguration) {
        this.jsonMapperConfiguration = jsonMapperConfiguration;
    }

    public boolean isEmptyResponseReturnVoid() {
        return this.emptyResponseReturnVoid;
    }

    public void setEmptyResponseReturnVoid(boolean emptyResponseReturnVoid) {
        this.emptyResponseReturnVoid = emptyResponseReturnVoid;
    }

    public List<GeneratorExtension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<GeneratorExtension> extensions) {
        this.extensions = extensions;
    }

    public String getRestIFPackageName() {
        return this.restIFPackageName;
    }

    public void setRestIFPackageName(String restIFPackageName) {
        this.restIFPackageName = restIFPackageName;
    }

    public String getInterfaceNameSuffix() {
        return this.interfaceNameSuffix;
    }

    public void setInterfaceNameSuffix(String interfaceNameSuffix) {
        this.interfaceNameSuffix = interfaceNameSuffix;
    }

    public static enum JaxrsVersion {
        JAXRS_1_1("1.1"),
        JAXRS_2_0("2.0");

        private final String alias;

        private JaxrsVersion(String alias) {
            this.alias = alias;
        }

        public static JaxrsVersion fromAlias(String alias) {
            ArrayList<String> supportedAliases = new ArrayList<String>();
            for (JaxrsVersion jaxrsVersion : JaxrsVersion.values()) {
                if (jaxrsVersion.alias.equals(alias)) {
                    return jaxrsVersion;
                }
                supportedAliases.add(jaxrsVersion.alias);
            }
            throw new IllegalArgumentException(alias + " is not a supported JAX-RS version (" + StringUtils.join(supportedAliases, (char)',') + ")");
        }
    }
}

