/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.core;

import com.google.common.io.Files;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.ModelLoader;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.util.ErrorReceiverFilter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.HttpMethod;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.AnnotatorFactory;
import org.jsonschema2pojo.CompositeAnnotator;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.SchemaStore;
import org.jsonschema2pojo.rules.RuleFactory;
import org.raml.jaxrs.codegen.core.Configuration;
import org.raml.jaxrs.codegen.core.Constants;
import org.raml.model.Raml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

class Context {
    private static final Logger LOGGER = LoggerFactory.getLogger(Context.class);
    private final Configuration configuration;
    private final Raml raml;
    private final JCodeModel codeModel;
    private final Map<String, Set<String>> resourcesMethods;
    private final Map<String, Object> httpMethodAnnotations;
    private final SchemaMapper schemaMapper;
    private boolean shouldGenerateResponseWrapper = false;
    private JDefinedClass currentResourceInterface;
    private final File globalSchemaStore;

    public JType ref(String name) {
        return this.codeModel.ref(name);
    }

    public Context(Configuration configuration, Raml raml) throws IOException {
        Validate.notNull((Object)configuration, (String)"configuration can't be null");
        Validate.notNull((Object)raml, (String)"raml can't be null");
        this.configuration = configuration;
        this.raml = raml;
        this.codeModel = new JCodeModel();
        this.resourcesMethods = new HashMap<String, Set<String>>();
        this.httpMethodAnnotations = new HashMap<String, Object>();
        for (Class<? extends Annotation> clazz : Constants.JAXRS_HTTP_METHODS) {
            this.httpMethodAnnotations.put(clazz.getSimpleName(), clazz);
        }
        this.globalSchemaStore = Files.createTempDir();
        for (Map.Entry entry : raml.getConsolidatedSchemas().entrySet()) {
            File schemaFile = new File(this.globalSchemaStore, (String)entry.getKey());
            FileUtils.writeStringToFile((File)schemaFile, (String)((String)entry.getValue()));
        }
        GenerationConfig jsonSchemaGenerationConfig = configuration.createJsonSchemaGenerationConfig();
        this.schemaMapper = new SchemaMapper(new RuleFactory(jsonSchemaGenerationConfig, Context.getAnnotator(jsonSchemaGenerationConfig), new SchemaStore()), new SchemaGenerator());
    }

    private static Annotator getAnnotator(GenerationConfig config) {
        Annotator coreAnnotator = new AnnotatorFactory().getAnnotator(config.getAnnotationStyle());
        if (config.getCustomAnnotator() != null) {
            Annotator customAnnotator = new AnnotatorFactory().getAnnotator(config.getCustomAnnotator());
            return new CompositeAnnotator(new Annotator[]{coreAnnotator, customAnnotator});
        }
        return coreAnnotator;
    }

    public Set<String> generate() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)baos);
        this.codeModel.build(this.configuration.getOutputDirectory(), ps);
        ps.close();
        HashSet<String> generatedFiles = new HashSet<String>();
        if (this.shouldGenerateResponseWrapper) {
            generatedFiles.add(this.generateResponseWrapper());
        }
        generatedFiles.addAll(Arrays.asList(StringUtils.split((String)baos.toString())));
        try {
            FileUtils.deleteDirectory((File)this.globalSchemaStore);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to delete temporary directory: " + this.globalSchemaStore);
        }
        return generatedFiles;
    }

    public Map.Entry<File, String> getSchemaFile(String schemaNameOrContent) throws IOException {
        if (this.raml.getConsolidatedSchemas().containsKey(schemaNameOrContent)) {
            return new AbstractMap.SimpleEntry<File, String>(new File(this.globalSchemaStore, schemaNameOrContent), schemaNameOrContent);
        }
        String schemaFileName = "schema" + schemaNameOrContent.hashCode();
        File schemaFile = new File(this.globalSchemaStore, schemaFileName);
        FileUtils.writeStringToFile((File)schemaFile, (String)schemaNameOrContent);
        return new AbstractMap.SimpleEntry<File, Object>(schemaFile, null);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public JDefinedClass getCurrentResourceInterface() {
        return this.currentResourceInterface;
    }

    public void setCurrentResourceInterface(JDefinedClass currentResourceInterface) {
        this.currentResourceInterface = currentResourceInterface;
    }

    private String generateResponseWrapper() throws IOException {
        String template = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/org/raml/templates/ResponseWrapper." + this.configuration.getJaxrsVersion().toString().toLowerCase() + ".template"));
        File supportPackageOutputDirectory = new File(this.configuration.getOutputDirectory(), this.getSupportPackage().replace('.', File.separatorChar));
        supportPackageOutputDirectory.mkdirs();
        File sourceOutputFile = new File(supportPackageOutputDirectory, "ResponseWrapper.java");
        String source = template.replace("${codegen.support.package}", this.getSupportPackage());
        FileWriter fileWriter = new FileWriter(sourceOutputFile);
        IOUtils.write((String)source, (Writer)fileWriter);
        IOUtils.closeQuietly((Writer)fileWriter);
        return this.getSupportPackage().replace('.', '/') + "/ResponseWrapper.java";
    }

    public JClass getResponseWrapperType() {
        this.shouldGenerateResponseWrapper = true;
        return this.codeModel.directClass(this.getSupportPackage() + ".ResponseWrapper");
    }

    public JDefinedClass createResourceInterface(String name) throws Exception {
        String actualName;
        int i = -1;
        while (this.resourcesMethods.containsKey(actualName = name + (++i == 0 ? "" : Integer.toString(i)))) {
        }
        this.resourcesMethods.put(actualName, new HashSet());
        JPackage pkg = this.codeModel._package(this.configuration.getBasePackageName() + "." + this.configuration.getRestIFPackageName());
        return pkg._interface(actualName);
    }

    public JMethod createResourceMethod(JDefinedClass resourceInterface, String methodName, JType returnType) {
        String actualMethodName;
        Set<String> existingMethodNames = this.resourcesMethods.get(resourceInterface.name());
        int i = -1;
        while (existingMethodNames.contains(actualMethodName = methodName + (++i == 0 ? "" : Integer.toString(i)))) {
        }
        existingMethodNames.add(actualMethodName);
        return resourceInterface.method(0, returnType, actualMethodName);
    }

    public JDefinedClass createResourceEnum(JDefinedClass resourceInterface, String name, List<String> values) throws Exception {
        JClass[] listClasses;
        for (JClass c : listClasses = resourceInterface.listClasses()) {
            if (!c.name().equals(name)) continue;
            return (JDefinedClass)c;
        }
        JDefinedClass _enum = resourceInterface._enum(name);
        for (String value : values) {
            _enum.enumConstant(value);
        }
        return _enum;
    }

    public JClass getGeneratorClass(String clazzFQN) {
        return this.codeModel.ref(clazzFQN);
    }

    public Context addHttpMethodAnnotation(String httpMethod, JAnnotatable annotatable) throws Exception {
        Object annotationClass = this.httpMethodAnnotations.get(httpMethod.toUpperCase());
        if (annotationClass == null) {
            JDefinedClass annotationClazz = this.createCustomHttpMethodAnnotation(httpMethod);
            annotatable.annotate((JClass)annotationClazz);
        } else if (annotationClass instanceof JClass) {
            annotatable.annotate((JClass)annotationClass);
        } else if (annotationClass instanceof Class) {
            annotatable.annotate((Class)annotationClass);
        } else {
            throw new IllegalStateException("Found annotation: " + annotationClass + " for HTTP method: " + httpMethod);
        }
        return this;
    }

    public JType getGeneratorType(Class<?> clazz) {
        return clazz.isPrimitive() ? JType.parse((JCodeModel)this.codeModel, (String)clazz.getSimpleName()) : this.codeModel.ref(clazz);
    }

    public JClass generateClassFromJsonSchema(String className, URL schemaUrl) throws IOException {
        return this.schemaMapper.generate(this.codeModel, className, this.getModelPackage(), schemaUrl).boxify();
    }

    private JDefinedClass createCustomHttpMethodAnnotation(String httpMethod) throws JClassAlreadyExistsException {
        JPackage pkg = this.codeModel._package(this.getSupportPackage());
        JDefinedClass annotationClazz = pkg._annotationTypeDeclaration(httpMethod);
        annotationClazz.annotate(Target.class).param("value", (Enum)ElementType.METHOD);
        annotationClazz.annotate(Retention.class).param("value", (Enum)RetentionPolicy.RUNTIME);
        annotationClazz.annotate(HttpMethod.class).param("value", httpMethod);
        annotationClazz.javadoc().add((Object)("Custom JAX-RS support for HTTP " + httpMethod + "."));
        this.httpMethodAnnotations.put(httpMethod.toUpperCase(), annotationClazz);
        return annotationClazz;
    }

    private String getModelPackage() {
        return this.configuration.getBasePackageName().concat(".").concat(this.configuration.getModelPackageName());
    }

    private String getSupportPackage() {
        return this.configuration.getBasePackageName() + "." + this.configuration.getRestIFPackageName() + ".support";
    }

    public Map<String, JClass> generateClassesFromXmlSchemas(Map<String, File> schemaFiles) {
        HashMap<String, JClass> result = new HashMap<String, JClass>();
        if (schemaFiles == null || schemaFiles.isEmpty()) {
            return result;
        }
        HashMap<String, String> classNameToKeyMap = new HashMap<String, String>();
        for (Map.Entry<String, File> entry : schemaFiles.entrySet()) {
            String className;
            String key = entry.getKey();
            File file = entry.getValue();
            List<JDefinedClass> classes = this.generateClassesFromXmlSchemas(new JCodeModel(), file);
            if (classes == null || classes.isEmpty() || (className = classes.get(0).name()) == null) continue;
            classNameToKeyMap.put(className, key);
        }
        File[] fileArray = schemaFiles.values().toArray(new File[schemaFiles.size()]);
        List<JDefinedClass> classList = this.generateClassesFromXmlSchemas(this.codeModel, fileArray);
        for (JDefinedClass cl : classList) {
            String name = cl.name();
            String key = (String)classNameToKeyMap.get(name);
            if (key == null) continue;
            result.put(key, (JClass)cl);
        }
        return result;
    }

    private List<JDefinedClass> generateClassesFromXmlSchemas(JCodeModel codeModel, File ... schemaFiles) {
        ArrayList<JDefinedClass> classList = new ArrayList<JDefinedClass>();
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-mark-generated");
        argList.add("-p");
        argList.add(this.getModelPackage());
        for (File f : schemaFiles) {
            argList.add(f.getAbsolutePath());
        }
        String[] args = argList.toArray(new String[argList.size()]);
        final Options opt = new Options();
        opt.setSchemaLanguage(Language.XMLSCHEMA);
        try {
            opt.parseArguments(args);
        }
        catch (Exception e) {
            // empty catch block
        }
        ErrorReceiverFilter receiver = new ErrorReceiverFilter(){

            public void info(SAXParseException exception) {
                if (opt.verbose) {
                    super.info(exception);
                }
            }

            public void warning(SAXParseException exception) {
                if (!opt.quiet) {
                    super.warning(exception);
                }
            }
        };
        try {
            Model model = ModelLoader.load((Options)opt, (JCodeModel)codeModel, (ErrorReceiver)receiver);
            Outline outline = model.generateCode(opt, (ErrorReceiver)receiver);
            for (ClassOutline co : outline.getClasses()) {
                JDefinedClass cl = co.implClass;
                if (cl.outer() != null) continue;
                classList.add(cl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classList;
    }

    public JCodeModel getCodeModel() {
        return this.codeModel;
    }
}

