/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.core;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.raml.jaxrs.codegen.core.AbstractGenerator;
import org.raml.jaxrs.codegen.core.Configuration;
import org.raml.jaxrs.codegen.core.Names;
import org.raml.jaxrs.codegen.core.Types;
import org.raml.jaxrs.codegen.core.ext.GeneratorExtension;
import org.raml.jaxrs.codegen.core.ext.InterfaceNameBuilderExtension;
import org.raml.jaxrs.codegen.core.ext.MethodNameBuilderExtension;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.parameter.AbstractParam;
import org.raml.model.parameter.Header;

public class Generator
extends AbstractGenerator {
    @Override
    protected void createResourceInterface(Resource resource, Raml raml, Configuration config) throws Exception {
        InterfaceNameBuilderExtension inbe;
        GeneratorExtension e;
        String resourceInterfaceName = null;
        Iterator iterator = this.extensions.iterator();
        while (iterator.hasNext() && (!((e = (GeneratorExtension)iterator.next()) instanceof InterfaceNameBuilderExtension) || (resourceInterfaceName = (inbe = (InterfaceNameBuilderExtension)e).buildResourceInterfaceName(resource)) == null)) {
        }
        if (resourceInterfaceName == null) {
            resourceInterfaceName = Names.buildResourceInterfaceName(resource, config);
        }
        JDefinedClass resourceInterface = this.context.createResourceInterface(resourceInterfaceName);
        this.context.setCurrentResourceInterface(resourceInterface);
        String path = StringUtils.strip((String)resource.getRelativeUri(), (String)"/");
        resourceInterface.annotate(Path.class).param("value", StringUtils.defaultIfBlank((String)path, (String)"/"));
        if (StringUtils.isNotBlank((String)resource.getDescription())) {
            resourceInterface.javadoc().add((Object)resource.getDescription());
        }
        this.addResourceMethods(resource, resourceInterface, path);
        for (GeneratorExtension e2 : this.extensions) {
            e2.onCreateResourceInterface(resourceInterface, resource);
        }
    }

    @Override
    protected void addResourceMethod(JDefinedClass resourceInterface, Resource resource, String resourceInterfacePath, Action action, MimeType bodyMimeType, boolean addBodyMimeTypeInMethodName, Collection<MimeType> uniqueResponseMimeTypes) throws Exception {
        Configuration configuration;
        String asyncResourceTrait;
        MimeType actualBodyMimeType = addBodyMimeTypeInMethodName ? bodyMimeType : null;
        String methodName = null;
        if (this.extensions != null) {
            for (GeneratorExtension ext : this.extensions) {
                if (!(ext instanceof MethodNameBuilderExtension)) continue;
                methodName = ((MethodNameBuilderExtension)ext).buildResourceMethodName(action, actualBodyMimeType, resource);
                break;
            }
        }
        if (methodName == null) {
            methodName = Names.buildResourceMethodName(action, actualBodyMimeType);
        }
        boolean asyncMethod = StringUtils.isNotBlank((String)(asyncResourceTrait = (configuration = this.context.getConfiguration()).getAsyncResourceTrait())) && action.getIs().contains(asyncResourceTrait);
        JType resourceMethodReturnType = this.getResourceMethodReturnType(methodName, action, uniqueResponseMimeTypes.isEmpty(), asyncMethod, resourceInterface);
        JMethod method = this.context.createResourceMethod(resourceInterface, methodName, resourceMethodReturnType);
        if (configuration.getMethodThrowException() != null) {
            method._throws(configuration.getMethodThrowException());
        }
        this.context.addHttpMethodAnnotation(action.getType().toString(), (JAnnotatable)method);
        this.addParamAnnotation(resourceInterfacePath, action, method);
        this.addConsumesAnnotation(bodyMimeType, method);
        this.addProducesAnnotation(uniqueResponseMimeTypes, method);
        JDocComment javadoc = this.addBaseJavaDoc(action, method);
        this.addPathParameters(action, method, javadoc);
        this.addHeaderParameters(action, method, javadoc);
        this.addQueryParameters(action, method, javadoc);
        this.addBodyParameters(bodyMimeType, method, javadoc);
        if (asyncMethod) {
            this.addAsyncResponseParameter(asyncResourceTrait, method, javadoc);
        }
        for (GeneratorExtension e : this.extensions) {
            e.onAddResourceMethod(method, action, bodyMimeType, uniqueResponseMimeTypes);
        }
    }

    private JType getResourceMethodReturnType(String methodName, Action action, boolean returnsVoid, boolean asyncMethod, JDefinedClass resourceInterface) throws Exception {
        if (asyncMethod) {
            this.createResourceMethodReturnType(methodName, action, resourceInterface);
            return this.types.getGeneratorType(Void.TYPE);
        }
        if (returnsVoid && this.context.getConfiguration().isEmptyResponseReturnVoid()) {
            return this.types.getGeneratorType(Void.TYPE);
        }
        return this.createResourceMethodReturnType(methodName, action, resourceInterface);
    }

    private void addAsyncResponseParameter(String asyncResourceTrait, JMethod method, JDocComment javadoc) throws Exception {
        String argumentName = Names.buildVariableName(asyncResourceTrait);
        JVar argumentVariable = method.param((JType)this.types.getGeneratorClass("javax.ws.rs.container.AsyncResponse"), argumentName);
        argumentVariable.annotate(this.types.getGeneratorClass("javax.ws.rs.container.Suspended"));
        javadoc.addParam(argumentVariable.name()).add((Object)asyncResourceTrait);
    }

    private JDefinedClass createResourceMethodReturnType(String methodName, Action action, JDefinedClass resourceInterface) throws Exception {
        JDefinedClass responseClass = resourceInterface._class(StringUtils.capitalize((String)methodName) + "Response")._extends(this.context.getResponseWrapperType());
        JMethod responseClassConstructor = responseClass.constructor(4);
        responseClassConstructor.param(Response.class, "delegate");
        responseClassConstructor.body().invoke("super").arg((JExpression)JExpr.ref((String)"delegate"));
        for (Map.Entry<String, org.raml.model.Response> entry : action.getResponses().entrySet()) {
            this.createResponseBuilderInResourceMethodReturnType(action, responseClass, entry);
        }
        return responseClass;
    }

    private void createResponseBuilderInResourceMethodReturnType(Action action, JDefinedClass responseClass, Map.Entry<String, org.raml.model.Response> statusCodeAndResponse) throws Exception {
        int statusCode = NumberUtils.toInt((String)statusCodeAndResponse.getKey());
        org.raml.model.Response response = statusCodeAndResponse.getValue();
        if (!response.hasBody()) {
            this.createResponseBuilderInResourceMethodReturnType(responseClass, statusCode, response, null);
        } else {
            for (MimeType mimeType : response.getBody().values()) {
                this.createResponseBuilderInResourceMethodReturnType(responseClass, statusCode, response, mimeType);
            }
        }
    }

    private void createResponseBuilderInResourceMethodReturnType(JDefinedClass responseClass, int statusCode, org.raml.model.Response response, MimeType responseMimeType) throws Exception {
        String responseBuilderMethodName = Names.buildResponseMethodName(statusCode, responseMimeType);
        JMethod responseBuilderMethod = responseClass.method(17, (JType)responseClass, responseBuilderMethodName);
        JDocComment javadoc = responseBuilderMethod.javadoc();
        if (StringUtils.isNotBlank((String)response.getDescription())) {
            javadoc.add((Object)response.getDescription());
        }
        if (responseMimeType != null && StringUtils.isNotBlank((String)responseMimeType.getExample())) {
            javadoc.add((Object)(" e.g. " + responseMimeType.getExample()));
        }
        JInvocation builderArgument = this.types.getGeneratorClass(Response.class).staticInvoke("status").arg(JExpr.lit((int)statusCode));
        if (responseMimeType != null) {
            builderArgument = builderArgument.invoke("header").arg("Content-Type").arg(responseMimeType.getType());
        }
        StringBuilder freeFormHeadersDescription = new StringBuilder();
        for (Map.Entry namedHeaderParameter : response.getHeaders().entrySet()) {
            String headerName = (String)namedHeaderParameter.getKey();
            Header header = (Header)namedHeaderParameter.getValue();
            if (headerName.contains("{?}")) {
                this.appendParameterJavadocDescription((AbstractParam)header, freeFormHeadersDescription);
                continue;
            }
            String argumentName = Names.buildVariableName(headerName);
            if (!header.isRepeat()) {
                builderArgument = builderArgument.invoke("header").arg(headerName).arg((JExpression)JExpr.ref((String)argumentName));
            }
            this.addParameterJavaDoc((AbstractParam)header, argumentName, javadoc);
            responseBuilderMethod.param(this.types.buildParameterType((AbstractParam)header, argumentName), argumentName);
        }
        JBlock responseBuilderMethodBody = responseBuilderMethod.body();
        JVar builderVariable = responseBuilderMethodBody.decl(this.types.getGeneratorType(Response.ResponseBuilder.class), "responseBuilder", (JExpression)builderArgument);
        if (freeFormHeadersDescription.length() > 0) {
            JClass listOfObjectsClass = this.types.getGeneratorClass(List.class).narrow(Object.class);
            JClass headersArgument = this.types.getGeneratorClass(Map.class).narrow(new JClass[]{this.types.getGeneratorClass(String.class), listOfObjectsClass});
            builderArgument = responseBuilderMethodBody.invoke("headers").arg((JExpression)JExpr.ref((String)"headers")).arg((JExpression)builderVariable);
            JVar param = responseBuilderMethod.param((JType)headersArgument, "headers");
            javadoc.addParam(param).add((Object)freeFormHeadersDescription.toString());
        }
        if (responseMimeType != null) {
            responseBuilderMethodBody.invoke((JExpression)builderVariable, "entity").arg((JExpression)JExpr.ref((String)"entity"));
            responseBuilderMethod.param(this.types.getResponseEntityClass(responseMimeType), "entity");
            javadoc.addParam("entity").add((Object)StringUtils.defaultString((String)responseMimeType.getExample()));
        }
        for (Map.Entry namedHeaderParameter : response.getHeaders().entrySet()) {
            String headerName = (String)namedHeaderParameter.getKey();
            Header header = (Header)namedHeaderParameter.getValue();
            String argumentName = Names.buildVariableName(headerName);
            if (!header.isRepeat()) continue;
            JBlock body = responseBuilderMethod.body().forEach(this.context.getGeneratorType(Types.getJavaType((AbstractParam)header)), "h", (JExpression)JExpr.ref((String)argumentName)).body();
            body.add((JStatement)JExpr.invoke((JExpression)JExpr.ref((String)"responseBuilder"), (String)"header").arg(headerName).arg((JExpression)JExpr.ref((String)"h")));
        }
        responseBuilderMethodBody._return((JExpression)JExpr._new((JClass)responseClass).arg((JExpression)builderVariable.invoke("build")));
    }
}

