/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.jsonschema2pojo.AnnotationStyle;
import org.raml.jaxrs.codegen.core.Configuration;
import org.raml.jaxrs.codegen.core.GeneratorProxy;
import org.raml.jaxrs.codegen.core.ext.GeneratorExtension;

public class Launcher {
    public static void main(String[] args) {
        Map<String, String> argMap = Launcher.createArgMap(args);
        Configuration configuration = Launcher.createConfiguration(argMap);
        boolean removeOldOutput = false;
        String removeOldOutputStringValue = argMap.get("removeOldOutput");
        if (removeOldOutputStringValue != null) {
            removeOldOutput = Boolean.parseBoolean(removeOldOutputStringValue);
        }
        boolean generateClient = false;
        String generateClientStringValue = argMap.get("generateClientProxy");
        if (generateClientStringValue != null) {
            generateClient = Boolean.parseBoolean(generateClientStringValue);
        }
        configuration.setGenerateClientInterface(generateClient);
        Collection<File> ramlFiles = Launcher.getRamlFiles(argMap);
        if (ramlFiles.isEmpty()) {
            return;
        }
        if (removeOldOutput) {
            try {
                FileUtils.cleanDirectory((File)configuration.getOutputDirectory());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        GeneratorProxy generator = new GeneratorProxy();
        for (File ramlFile : ramlFiles) {
            try {
                generator.run(new FileReader(ramlFile), configuration, ramlFile.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Collection<File> getRamlFiles(Map<String, String> argMap) {
        String sourcePaths = argMap.get("sourcePaths");
        String sourceDirectoryPath = argMap.get("sourceDirectory");
        if (!Launcher.isEmptyString(sourcePaths)) {
            String[] split;
            ArrayList<File> sourceFiles = new ArrayList<File>();
            for (String str : split = sourcePaths.split(System.getProperty("path.separator"))) {
                sourceFiles.add(new File(str));
            }
            return sourceFiles;
        }
        File sourceDirectory = new File(sourceDirectoryPath);
        if (!sourceDirectory.isDirectory()) {
            throw new RuntimeException("The provided path doesn't refer to a valid directory: " + sourceDirectory);
        }
        return FileUtils.listFiles((File)sourceDirectory, (String[])new String[]{"raml", "yaml"}, (boolean)false);
    }

    private static Configuration createConfiguration(Map<String, String> argMap) {
        Configuration configuration = new Configuration();
        File rootDirectory = new File(System.getProperty("user.dir"));
        File outputDirectory = new File(rootDirectory, "generated-sources/raml-jaxrs");
        File sourceDirectory = new File(rootDirectory, "src/main/raml");
        String basePackageName = null;
        String jaxrsVersion = "1.1";
        boolean useJsr303Annotations = false;
        boolean mapToVoid = false;
        String jsonMapper = "jackson1";
        boolean generateClientProxy = false;
        boolean useTitlePropertyForSchemaNames = false;
        String modelPackageName = "model";
        String asyncResourceTrait = null;
        String customAnnotator = null;
        ArrayList<GeneratorExtension> extensions = null;
        HashMap<String, String> jsonMapperConfiguration = new HashMap<String, String>();
        String restIFPackageName = "resource";
        String interfaceNameSuffix = "Resource";
        for (Map.Entry<String, String> entry : argMap.entrySet()) {
            String argName = entry.getKey();
            String argValue = entry.getValue();
            if (argName.equals("outputDirectory")) {
                outputDirectory = new File(argValue);
                continue;
            }
            if (argName.equals("sourceDirectory")) {
                sourceDirectory = new File(argValue);
                continue;
            }
            if (argName.equals("jaxrsVersion")) {
                jaxrsVersion = argValue;
                continue;
            }
            if (argName.equals("mapToVoid")) {
                mapToVoid = Boolean.parseBoolean(argValue);
                continue;
            }
            if (argName.equals("basePackageName")) {
                basePackageName = argValue;
                continue;
            }
            if (argName.equals("useJsr303Annotations")) {
                useJsr303Annotations = Boolean.parseBoolean(argValue);
                continue;
            }
            if (argName.equals("jsonMapper")) {
                jsonMapper = argValue;
                continue;
            }
            if (argName.equals("generateClientProxy")) {
                generateClientProxy = Boolean.parseBoolean(argValue);
                continue;
            }
            if (argName.equals("useTitlePropertyForSchemaNames")) {
                useTitlePropertyForSchemaNames = Boolean.parseBoolean(argValue);
                continue;
            }
            if (argName.equals("modelPackageName")) {
                modelPackageName = argValue;
                continue;
            }
            if (argName.equals("restIFPackageName")) {
                restIFPackageName = argValue;
                continue;
            }
            if (argName.equals("interfaceNameSuffix")) {
                interfaceNameSuffix = argValue;
                continue;
            }
            if (argName.equals("asyncResourceTrait")) {
                asyncResourceTrait = argValue;
                continue;
            }
            if (argName.equals("customAnnotator")) {
                customAnnotator = argValue;
                continue;
            }
            if (argName.equals("extensions")) {
                String[] extensionClasses;
                extensions = new ArrayList<GeneratorExtension>();
                for (String s : extensionClasses = argValue.split(",")) {
                    s = s.trim();
                    try {
                        extensions.add((GeneratorExtension)Class.forName(s).newInstance());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("unknown extension " + s);
                    }
                }
                continue;
            }
            if (!argName.startsWith("jsonschema2pojo.")) continue;
            String name = argName.substring("jsonschema2pojo.".length());
            jsonMapperConfiguration.put(name, argValue);
        }
        if (basePackageName == null) {
            throw new RuntimeException("Base package must be specified.");
        }
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        if (!outputDirectory.isDirectory()) {
            throw new RuntimeException("Output destination must be a directory: " + outputDirectory);
        }
        configuration.setBasePackageName(basePackageName);
        configuration.setJaxrsVersion(Configuration.JaxrsVersion.fromAlias(jaxrsVersion));
        configuration.setOutputDirectory(outputDirectory);
        configuration.setUseJsr303Annotations(useJsr303Annotations);
        configuration.setJsonMapper(AnnotationStyle.valueOf((String)jsonMapper.toUpperCase()));
        configuration.setSourceDirectory(sourceDirectory);
        configuration.setGenerateClientInterface(generateClientProxy);
        configuration.setEmptyResponseReturnVoid(mapToVoid);
        configuration.setUseTitlePropertyWhenPossible(useTitlePropertyForSchemaNames);
        configuration.setModelPackageName(modelPackageName);
        configuration.setRestIFPackageName(restIFPackageName);
        configuration.setInterfaceNameSuffix(interfaceNameSuffix);
        configuration.setAsyncResourceTrait(asyncResourceTrait);
        if (extensions != null) {
            configuration.setExtensions(extensions);
        }
        if (!jsonMapperConfiguration.isEmpty()) {
            configuration.setJsonMapperConfiguration(jsonMapperConfiguration);
        }
        if (customAnnotator != null && !customAnnotator.trim().isEmpty()) {
            try {
                configuration.setCustomAnnotator(Class.forName(customAnnotator));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return configuration;
    }

    private static Map<String, String> createArgMap(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String argValue;
            String argName = args[i];
            if (!argName.startsWith("-")) continue;
            argName = argName.substring(1);
            if (i + 1 >= args.length || (argValue = args[i + 1]).startsWith("-")) continue;
            map.put(argName, argValue);
            ++i;
        }
        return map;
    }

    private static boolean isEmptyString(String str) {
        return str == null || str.trim().isEmpty();
    }
}

