/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.raml.jaxrs.codegen.core.Configuration;
import org.raml.jaxrs.codegen.core.Constants;
import org.raml.jaxrs.codegen.core.ext.GeneratorExtension;
import org.raml.jaxrs.codegen.core.ext.NestedSchemaNameComputer;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Resource;

public class Names {
    public static final String GENERIC_PAYLOAD_ARGUMENT_NAME = "entity";
    public static final String MULTIPLE_RESPONSE_HEADERS_ARGUMENT_NAME = "headers";
    public static final String EXAMPLE_PREFIX = " e.g. ";

    public static String buildResourceInterfaceName(Resource resource, Configuration config) {
        String resourceInterfaceName = Names.buildJavaFriendlyName(StringUtils.defaultIfBlank((String)resource.getDisplayName(), (String)resource.getRelativeUri()));
        return StringUtils.isBlank((String)resourceInterfaceName) ? "Root" : resourceInterfaceName.concat(config.getInterfaceNameSuffix());
    }

    public static String buildVariableName(String source) {
        String name = StringUtils.uncapitalize((String)Names.buildJavaFriendlyName(source));
        return Constants.JAVA_KEYWORDS.contains(name) ? "$" + name : name;
    }

    public static String buildJavaFriendlyName(String source) {
        String baseName = source.replaceAll("[\\W_]", " ");
        String friendlyName = WordUtils.capitalize((String)baseName).replaceAll("[\\W_]", "");
        if (NumberUtils.isDigits((String)StringUtils.left((String)friendlyName, (int)1))) {
            friendlyName = "_" + friendlyName;
        }
        return friendlyName;
    }

    public static String buildResourceMethodName(Action action, MimeType bodyMimeType) {
        String methodBaseName = Names.buildJavaFriendlyName(action.getResource().getUri().replace("{", " By "));
        return action.getType().toString().toLowerCase() + Names.buildMimeTypeInfix(bodyMimeType) + methodBaseName;
    }

    public static String buildResponseMethodName(int statusCode, MimeType mimeType) {
        String status = EnglishReasonPhraseCatalog.INSTANCE.getReason(statusCode, Constants.DEFAULT_LOCALE);
        String string = Names.getShortMimeType(mimeType) + Names.buildJavaFriendlyName(StringUtils.defaultIfBlank((String)status, (String)("_" + statusCode)));
        return "with" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String buildNestedSchemaName(MimeType mimeType, Configuration config) {
        for (GeneratorExtension e : config.getExtensions()) {
            NestedSchemaNameComputer nc;
            String computed;
            if (!(e instanceof NestedSchemaNameComputer) || (computed = (nc = (NestedSchemaNameComputer)e).computeNestedSchemaName(mimeType)) == null) continue;
            return computed;
        }
        if (!StringUtils.isBlank((String)mimeType.getSchema())) {
            try {
                JsonObject p = (JsonObject)new JsonParser().parse(mimeType.getSchema());
                JsonElement title = p.get("title");
                if (title != null && title.getAsString() != null) {
                    return title.getAsString();
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return Names.getShortMimeType(mimeType) + (StringUtils.isBlank((String)mimeType.getSchema()) ? mimeType.hashCode() : mimeType.getSchema().hashCode());
    }

    public static String buildMimeTypeInfix(MimeType bodyMimeType) {
        return bodyMimeType != null ? Names.buildJavaFriendlyName(Names.getShortMimeType(bodyMimeType)) : "";
    }

    public static String getShortMimeType(MimeType mimeType) {
        if (mimeType == null) {
            return "";
        }
        String subType = StringUtils.substringAfter((String)mimeType.getType().toLowerCase(Constants.DEFAULT_LOCALE), (String)"/");
        if (subType.contains(".")) {
            StringBuilder sb = new StringBuilder();
            for (String s : subType.split("\\W+")) {
                sb.append(sb.length() == 0 ? s : StringUtils.capitalize((String)s));
            }
            return sb.toString();
        }
        return StringUtils.remove((String)StringUtils.remove((String)StringUtils.remove((String)subType, (String)"x-www-"), (String)"+"), (String)"-");
    }

    public static boolean canBenumConstantName(String value) {
        boolean res = value.length() > 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            res = i == 0 ? (res &= Character.isJavaIdentifierStart(c)) : (res &= Character.isJavaIdentifierPart(c));
            if (!res) break;
        }
        return res;
    }

    public static boolean isValidEnumValues(List<String> values) {
        boolean res = values.size() > 0;
        for (String v : values) {
            if (!(res &= Names.canBenumConstantName(v))) break;
        }
        return res;
    }

    private Names() {
        throw new UnsupportedOperationException();
    }
}

