/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.core;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.WordUtils;
import org.raml.jaxrs.codegen.core.Context;
import org.raml.jaxrs.codegen.core.Names;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Resource;
import org.raml.model.Response;
import org.raml.model.parameter.AbstractParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Types {
    private static final Logger LOGGER = LoggerFactory.getLogger(Types.class);
    private final Context context;
    private final Map<String, JClass> schemaClasses;

    public Types(Context context) {
        Validate.notNull((Object)context, (String)"context can't be null");
        this.context = context;
        this.schemaClasses = new HashMap<String, JClass>();
    }

    public JType buildParameterType(AbstractParam parameter, String name) throws Exception {
        if (parameter.getEnumeration() != null && !parameter.getEnumeration().isEmpty() && Names.isValidEnumValues(parameter.getEnumeration())) {
            return this.context.createResourceEnum(this.context.getCurrentResourceInterface(), WordUtils.capitalize((String)name), parameter.getEnumeration());
        }
        JType codegenType = this.context.getGeneratorType(Types.getJavaType(parameter));
        if (parameter.isRepeat()) {
            return ((JClass)this.context.getGeneratorType(List.class)).narrow(codegenType);
        }
        return codegenType;
    }

    public JType getRequestEntityClass(MimeType mimeType) throws IOException {
        JClass schemaClass = this.getSchemaClass(mimeType);
        if (schemaClass != null) {
            return schemaClass;
        }
        if (StringUtils.startsWith((String)mimeType.getType(), (String)"text/")) {
            return this.getGeneratorType(String.class);
        }
        if ("application/octet-stream".equals(mimeType.getType())) {
            return this.getGeneratorType(InputStream.class);
        }
        return this.getGeneratorType(Reader.class);
    }

    public JType getResponseEntityClass(MimeType mimeType) throws IOException {
        JClass schemaClass = this.getSchemaClass(mimeType);
        if (schemaClass != null) {
            return schemaClass;
        }
        if (StringUtils.startsWith((String)mimeType.getType(), (String)"text/")) {
            return this.getGeneratorType(String.class);
        }
        return this.getGeneratorType(StreamingOutput.class);
    }

    public JType getGeneratorType(Class<?> clazz) {
        return this.context.getGeneratorType(clazz);
    }

    public JClass getGeneratorClass(Class<?> clazz) {
        return (JClass)this.context.getGeneratorType(clazz);
    }

    public JClass getGeneratorClass(String classFQN) {
        return this.context.getGeneratorClass(classFQN);
    }

    private JClass getSchemaClass(MimeType mimeType) throws IOException {
        String schemaNameOrContent = mimeType.getSchema();
        if (StringUtils.isBlank((String)schemaNameOrContent)) {
            return null;
        }
        String buildSchemaKey = this.buildSchemaKey(mimeType);
        JClass existingClass = this.schemaClasses.get(buildSchemaKey);
        if (existingClass != null) {
            return existingClass;
        }
        if (this.isCompatibleWith(mimeType, "application/xml", "text/xml")) {
            return null;
        }
        if (this.isCompatibleWith(mimeType, "application/json")) {
            Map.Entry<File, String> schemaNameAndFile = this.context.getSchemaFile(schemaNameOrContent);
            if (StringUtils.isBlank((String)schemaNameAndFile.getValue())) {
                schemaNameAndFile.setValue(Names.buildNestedSchemaName(mimeType, this.context.getConfiguration()));
            }
            String className = Names.buildJavaFriendlyName(schemaNameAndFile.getValue());
            JClass generatedClass = this.context.generateClassFromJsonSchema(className, schemaNameAndFile.getKey().toURI().toURL());
            this.schemaClasses.put(buildSchemaKey, generatedClass);
            return generatedClass;
        }
        return null;
    }

    private boolean isCompatibleWith(MimeType mt, String ... mediaTypes) {
        String mimeType = mt.getType();
        if (StringUtils.isBlank((String)mimeType)) {
            return false;
        }
        for (String mediaType : mediaTypes) {
            if (mediaType.toString().equals(mimeType)) {
                return true;
            }
            String primaryType = StringUtils.substringBefore((String)mimeType, (String)"/");
            if (!StringUtils.substringBefore((String)mediaType, (String)"/").equals(primaryType)) continue;
            String subType = StringUtils.defaultIfBlank((String)StringUtils.substringAfterLast((String)mimeType, (String)"+"), (String)StringUtils.substringAfter((String)mimeType, (String)"/"));
            if (!StringUtils.substringAfter((String)mediaType, (String)"/").equals(subType)) continue;
            return true;
        }
        return false;
    }

    private String buildSchemaKey(MimeType mimeType) {
        return Names.getShortMimeType(mimeType) + "@" + mimeType.getSchema().hashCode();
    }

    static Class<?> getJavaType(AbstractParam parameter) {
        if (parameter.getType() == null) {
            return String.class;
        }
        boolean usePrimitive = !parameter.isRepeat() && (parameter.isRequired() || StringUtils.isNotBlank((String)parameter.getDefaultValue()));
        switch (parameter.getType()) {
            case BOOLEAN: {
                return usePrimitive ? Boolean.TYPE : Boolean.class;
            }
            case DATE: {
                return Date.class;
            }
            case FILE: {
                return File.class;
            }
            case INTEGER: {
                return usePrimitive ? Integer.TYPE : Integer.class;
            }
            case NUMBER: {
                return BigDecimal.class;
            }
            case STRING: {
                return String.class;
            }
        }
        LOGGER.warn("Unsupported RAML type: " + parameter.getType().toString());
        return Object.class;
    }

    public void generateClassesFromXmlSchemas(Collection<Resource> resources) {
        if (resources == null) {
            return;
        }
        HashMap<String, File> schemaFiles = new HashMap<String, File>();
        for (Resource r : resources) {
            this.collectXmlSchemaFiles(r, schemaFiles);
        }
        this.schemaClasses.putAll(this.context.generateClassesFromXmlSchemas(schemaFiles));
    }

    public void collectXmlSchemaFiles(Resource resource, Map<String, File> schemaFiles) {
        Collection actions = resource.getActions().values();
        for (Action a : actions) {
            Map body;
            Map responses = a.getResponses();
            if (responses != null) {
                for (Response resp : responses.values()) {
                    Map body2 = resp.getBody();
                    if (body2 == null) continue;
                    for (MimeType mt : body2.values()) {
                        try {
                            this.collectXmlSchemaFiles(mt, schemaFiles);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if ((body = a.getBody()) == null) continue;
            for (MimeType mt : body.values()) {
                try {
                    this.collectXmlSchemaFiles(mt, schemaFiles);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Collection resources = resource.getResources().values();
        for (Resource r : resources) {
            this.collectXmlSchemaFiles(r, schemaFiles);
        }
    }

    private void collectXmlSchemaFiles(MimeType mimeType, Map<String, File> schemaFiles) throws IOException {
        if (!this.isCompatibleWith(mimeType, "application/xml", "text/xml")) {
            return;
        }
        String schemaNameOrContent = mimeType.getSchema();
        if (StringUtils.isBlank((String)schemaNameOrContent)) {
            return;
        }
        String buildSchemaKey = this.buildSchemaKey(mimeType);
        Map.Entry<File, String> schemaNameAndFile = this.context.getSchemaFile(schemaNameOrContent);
        schemaFiles.put(buildSchemaKey, schemaNameAndFile.getKey());
    }
}

