/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.io.OutputStream;
import org.rapidoid.RapidoidThing;
import org.rapidoid.buffer.Buf;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.bytes.BytesUtil;
import org.rapidoid.commons.Dates;
import org.rapidoid.config.BasicConfig;
import org.rapidoid.config.Conf;
import org.rapidoid.data.BufRange;
import org.rapidoid.data.JSON;
import org.rapidoid.http.HttpResponseCodes;
import org.rapidoid.http.HttpStatus;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.impl.HttpParser;
import org.rapidoid.http.impl.MaybeReq;
import org.rapidoid.http.impl.lowlevel.HttpIO;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.Server;
import org.rapidoid.net.TCP;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.util.Msc;
import org.rapidoid.writable.ReusableWritable;

public abstract class AbstractHttpServer
extends RapidoidThing
implements Protocol {
    protected final byte[] STATUS_200 = HttpResponseCodes.get(200);
    protected final byte[] HTTP_404;
    protected final byte[] HTTP_500;
    protected final byte[] CONN_CLOSE_HDR = AbstractHttpServer.hdr("Connection: close");
    protected final byte[] SERVER_HDR;
    protected final byte[] DATE_TXT = "Date: ".getBytes();
    protected final byte[] CONTENT_LENGTH_TXT = "Content-Length: ".getBytes();
    protected final byte[] CONTENT_TYPE_TXT = "Content-Type: ".getBytes();
    protected final HttpParser HTTP_PARSER = this.createParser();
    private final boolean syncBufs;

    public AbstractHttpServer() {
        this("Rapidoid", "Not found!", "Error!", true);
    }

    public AbstractHttpServer(String serverName, String notFoundMsg, String errorMsg, boolean syncBufs) {
        this.SERVER_HDR = AbstractHttpServer.hdr("Server: " + serverName);
        this.HTTP_404 = this.fullResp(404, notFoundMsg.getBytes());
        this.HTTP_500 = this.fullResp(500, errorMsg.getBytes());
        this.syncBufs = syncBufs;
    }

    private static byte[] hdr(String name) {
        return (name + "\r\n").getBytes();
    }

    protected byte[] fullResp(int code, byte[] content) {
        String status = new String(HttpResponseCodes.get(code));
        String resp = status + "Content-Length: " + content.length + "\r\n\r\n" + new String(content);
        return resp.getBytes();
    }

    protected HttpParser createParser() {
        return new HttpParser();
    }

    public void process(Channel ctx) {
        if (ctx.isInitial()) {
            return;
        }
        Buf buf = ctx.input();
        RapidoidHelper data = ctx.helper();
        this.HTTP_PARSER.parse(buf, data);
        boolean keepAlive = data.isKeepAlive.value;
        HttpStatus status = this.handle(ctx, buf, data);
        switch (status) {
            case DONE: {
                ctx.closeIf(!keepAlive);
                break;
            }
            case NOT_FOUND: {
                ctx.write(this.HTTP_404);
                ctx.closeIf(!keepAlive);
                break;
            }
            case ERROR: {
                ctx.write(this.HTTP_500);
                ctx.closeIf(!keepAlive);
                break;
            }
        }
    }

    protected abstract HttpStatus handle(Channel var1, Buf var2, RapidoidHelper var3);

    protected void startResponse(Channel ctx, boolean isKeepAlive) {
        ctx.write(this.STATUS_200);
        this.writeCommonHeaders(ctx, isKeepAlive);
    }

    protected void startResponse(Channel ctx, int code, boolean isKeepAlive) {
        ctx.write(HttpResponseCodes.get(code));
        this.writeCommonHeaders(ctx, isKeepAlive);
    }

    protected void writeCommonHeaders(Channel ctx, boolean isKeepAlive) {
        if (!isKeepAlive) {
            ctx.write(this.CONN_CLOSE_HDR);
        }
        ctx.write(this.SERVER_HDR);
        this.writeDateHeader(ctx);
    }

    protected void writeDateHeader(Channel ctx) {
        ctx.write(this.DATE_TXT);
        ctx.write(Dates.getDateTimeBytes());
        ctx.write(CR_LF);
    }

    private void writeContentTypeHeader(Channel ctx, MediaType contentType) {
        ctx.write(this.CONTENT_TYPE_TXT);
        ctx.write(contentType.getBytes());
        ctx.write(CR_LF);
    }

    protected void writeBody(Channel ctx, byte[] body, MediaType contentType) {
        this.writeBody(ctx, body, 0, body.length, contentType);
    }

    protected void writeBody(Channel ctx, byte[] body, int offset, int length, MediaType contentType) {
        this.writeContentTypeHeader(ctx, contentType);
        HttpIO.INSTANCE.writeContentLengthHeader(ctx, length);
        ctx.write(CR_LF);
        ctx.write(body, offset, length);
    }

    protected void writeJsonBody(MaybeReq req, Channel ctx, Object value) {
        this.writeContentTypeHeader(ctx, MediaType.JSON);
        ReusableWritable out = Msc.locals().jsonRenderingStream();
        JSON.stringify((Object)value, (OutputStream)out);
        HttpIO.INSTANCE.writeContentLengthHeader(ctx, out.size());
        HttpIO.INSTANCE.closeHeaders(req, ctx.output());
        ctx.write(out.array(), 0, out.size());
    }

    protected HttpStatus serializeToJson(MaybeReq req, Channel ctx, boolean isKeepAlive, Object value) {
        this.startResponse(ctx, isKeepAlive);
        this.writeJsonBody(req, ctx, value);
        return HttpStatus.DONE;
    }

    protected HttpStatus ok(Channel ctx, boolean isKeepAlive, byte[] body, MediaType contentType) {
        return this.ok(ctx, isKeepAlive, body, 0, body.length, contentType);
    }

    protected HttpStatus ok(Channel ctx, boolean isKeepAlive, byte[] body, int offset, int length, MediaType contentType) {
        this.startResponse(ctx, isKeepAlive);
        this.writeBody(ctx, body, offset, length, contentType);
        return HttpStatus.DONE;
    }

    protected HttpStatus plain(Channel ctx, boolean isKeepAlive, byte[] body) {
        return this.ok(ctx, isKeepAlive, body, MediaType.PLAIN_TEXT_UTF_8);
    }

    protected HttpStatus json(Channel ctx, boolean isKeepAlive, byte[] body) {
        return this.ok(ctx, isKeepAlive, body, MediaType.JSON);
    }

    protected HttpStatus html(Channel ctx, boolean isKeepAlive, byte[] body) {
        return this.ok(ctx, isKeepAlive, body, MediaType.HTML_UTF_8);
    }

    protected HttpStatus binary(Channel ctx, boolean isKeepAlive, byte[] body) {
        return this.ok(ctx, isKeepAlive, body, MediaType.APPLICATION_OCTET_STREAM);
    }

    protected boolean matches(Buf buf, BufRange range, byte[] value) {
        return BytesUtil.matches((Bytes)buf.bytes(), (BufRange)range, (byte[])value, (boolean)true);
    }

    protected boolean matchesIgnoreCase(Buf buf, BufRange range, byte[] value) {
        return BytesUtil.matches((Bytes)buf.bytes(), (BufRange)range, (byte[])value, (boolean)false);
    }

    public Server listen(int port) {
        return this.listen("0.0.0.0", port);
    }

    public Server listen(String address, int port) {
        return (Server)TCP.server((BasicConfig)Conf.HTTP).protocol((Protocol)this).address(address).port(port).syncBufs(this.syncBufs).build().start();
    }
}

