/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.rapidoid.RapidoidThing;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.bytes.BytesUtil;
import org.rapidoid.commons.Str;
import org.rapidoid.config.BasicConfig;
import org.rapidoid.config.Conf;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.ctx.UserInfo;
import org.rapidoid.data.BufRanges;
import org.rapidoid.gui.reqinfo.ReqInfo;
import org.rapidoid.http.HttpHeaders;
import org.rapidoid.http.HttpMetadata;
import org.rapidoid.http.HttpResponseCodes;
import org.rapidoid.http.HttpStatus;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.SimpleHttpResp;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.customize.HttpResponseRenderer;
import org.rapidoid.http.handler.HandlerResultProcessor;
import org.rapidoid.http.impl.MaybeReq;
import org.rapidoid.io.Res;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.u.U;
import org.rapidoid.util.ErrCodeAndMsg;
import org.rapidoid.util.Msc;
import org.rapidoid.util.MscOpts;
import org.rapidoid.util.TokenAuthData;
import org.rapidoid.util.Tokens;
import org.rapidoid.util.WebData;

public class HttpUtils
extends RapidoidThing
implements HttpMetadata {
    private static final MediaType DEFAULT_CONTENT_TYPE = MscOpts.hasRapidoidGUI() ? MediaType.HTML_UTF_8 : MediaType.JSON;
    private static final String PAGE_RELOAD = "<h2>&nbsp;Reloading...</h2><script>location.reload();</script>";
    private static final byte[] EMPTY_RESPONSE = new byte[0];
    private static final MaybeReq NO_REQ = new MaybeReq(){

        @Override
        public Req getReqOrNull() {
            return null;
        }
    };
    private static volatile Pattern REGEX_VALID_HTTP_RESOURCE = Pattern.compile("(?U)(?:/[ \\w\\-\\.]+)*/?");
    private static final Mapper<String[], String> PATH_PARAM_EXTRACTOR = new Mapper<String[], String>(){

        public String map(String[] src) throws Exception {
            return src[1].split(":", 2)[0];
        }
    };

    public static Map<String, Serializable> initAndDeserializeToken(Req req) {
        String token = req.cookie("_token", null);
        if (U.isEmpty((String)token)) {
            token = req.data("_token", null);
        }
        return Tokens.deserialize((String)token);
    }

    public static void saveTokenBeforeRenderingHeaders(Req req, Map<String, Serializable> tokenData) {
        String token = Tokens.serialize(tokenData);
        HttpUtils.setResponseTokenCookie(req.response(), token);
    }

    public static boolean isGetReq(Req req) {
        return req.verb().equals("GET");
    }

    public static boolean isPostReq(Req req) {
        return req.verb().equals("POST");
    }

    public static String resName(Req req) {
        String resName = HttpUtils.resName(req.path());
        U.notNull((Object)resName, (String)"resource name", (Object[])new Object[0]);
        return resName;
    }

    public static String resName(String path) {
        if (U.notEmpty((String)path) && REGEX_VALID_HTTP_RESOURCE.matcher(path).matches() && !path.contains("..")) {
            String res = Str.triml((String)path, (String)"/");
            return res.isEmpty() ? "index" : Str.trimr((String)res, (String)".html");
        }
        throw U.rte((String)"Invalid path!");
    }

    public static String viewName(Req req) {
        return HttpUtils.resName(req.path());
    }

    public static boolean hasExtension(String name) {
        int pos = name.lastIndexOf(46);
        return pos > 0 && pos < name.length() - 1;
    }

    public static void setContentTypeForFile(Resp resp, File file) {
        U.must((boolean)file.exists());
        HttpUtils.setContentType(resp, MediaType.getByFileName((String)file.getAbsolutePath()));
    }

    public static void setContentTypeForResource(Resp resp, Res resource) {
        U.must((boolean)resource.exists());
        HttpUtils.setContentType(resp, MediaType.getByFileName((String)resource.getName()));
    }

    public static void setContentType(Resp resp, MediaType mediaType) {
        resp.contentType(mediaType);
    }

    public static Res staticResource(Req req, String ... possibleLocations) {
        String resName = HttpUtils.resName(req);
        if (resName == null) {
            return null;
        }
        if (HttpUtils.hasExtension(resName)) {
            return Res.from((String)resName, (String[])possibleLocations);
        }
        Res res = Res.from((String)resName, (String[])possibleLocations);
        if (!res.exists()) {
            res = Res.from((String)(resName + ".html"), (String[])possibleLocations);
        }
        return res;
    }

    public static String getErrorMessageAndSetCode(Resp resp, Throwable err) {
        ErrCodeAndMsg codeAndMsg = Msc.getErrorCodeAndMsg((Throwable)err);
        resp.code(codeAndMsg.code());
        return codeAndMsg.msg();
    }

    public static Map<String, ?> getErrorInfo(Resp resp, Throwable error) {
        String errorMessage = HttpUtils.getErrorMessageAndSetCode(resp, error);
        return U.map((Object)"error", (Object)errorMessage, (Object)"code", (Object)resp.code(), (Object)"status", (Object)HttpResponseCodes.status(resp.code()));
    }

    public static void postProcessResponse(Resp resp) {
        HttpUtils.postProcessRedirect(resp);
        HttpUtils.postProcessFile(resp);
        HttpUtils.postProcessFilename(resp);
    }

    private static void postProcessFile(Resp resp) {
        File file = resp.file();
        if (file != null) {
            U.must((boolean)file.exists());
            if (resp.filename() == null) {
                resp.filename();
            }
            HttpUtils.setContentTypeForFile(resp, file);
            resp.result(Res.from((File)file, (String[])new String[0]).getBytes());
        }
    }

    private static void postProcessFilename(Resp resp) {
        String filename = resp.filename();
        if (filename != null) {
            resp.headers().put(HttpHeaders.CONTENT_DISPOSITION.name(), "attachment; filename=\"" + filename + "\"");
            resp.headers().put(HttpHeaders.CACHE_CONTROL.name(), "private");
        }
    }

    private static void postProcessRedirect(Resp resp) {
        String redirect = resp.redirect();
        if (redirect != null) {
            if (resp.code() < 300 || resp.code() >= 400) {
                resp.code(303);
            }
            resp.headers().put(HttpHeaders.LOCATION.name(), redirect);
            if (resp.result() == null && resp.body() == null) {
                resp.body(EMPTY_RESPONSE);
            }
        }
    }

    public static void reload(Req x) {
        Map sel = U.map((Object)"body", (Object)PAGE_RELOAD);
        x.response().json(U.map((Object)"_sel_", (Object)sel));
    }

    public static String constructUrl(Req x, String path) {
        return (Conf.ROOT.is("https") ? "https://" : "http://") + x.host() + path;
    }

    public static byte[] responseToBytes(Req req, Object result, MediaType contentType, HttpResponseRenderer responseRenderer) {
        if (U.eq((Object)contentType, (Object)MediaType.JSON) || U.eq((Object)contentType, (Object)MediaType.XML_UTF_8)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                responseRenderer.render(req, result, out);
            }
            catch (Exception e) {
                throw U.rte((Throwable)e);
            }
            return out.toByteArray();
        }
        return Msc.toBytes((Object)result);
    }

    public static Object resultOf(Req req, Object result) {
        result = HandlerResultProcessor.INSTANCE.postProcessResult(req, result);
        HttpUtils.resultToResponse(req, result);
        return req.response().result();
    }

    public static void resultToResponse(Req req, Object result) {
        if (result instanceof Req) {
            if (req != result) {
                req.response().result("Unknown request instance was received as result!");
            }
        } else if (result instanceof Resp) {
            if (req.response() != result) {
                req.response().result("Unknown response instance was received as result!");
            }
        } else if (!(result instanceof HttpStatus)) {
            req.response().result(result);
        }
    }

    public static String getContextPath(Req req) {
        return (String)HttpUtils.zone(req).entry("contextPath").or((Object)"");
    }

    public static BasicConfig zone(Customization custom, String zone) {
        BasicConfig defaultConfig = custom.config().sub(new String[]{"gui"}).or((BasicConfig)custom.config().sub(new String[]{"app"}));
        if (zone != null) {
            String zoneKey = zone + "-zone";
            return custom.config().sub(new String[]{zoneKey}).or(defaultConfig);
        }
        return defaultConfig;
    }

    public static BasicConfig zone(Req req) {
        Customization custom = Customization.of(req);
        return HttpUtils.zone(custom, req.zone());
    }

    public static void setResponseTokenCookie(Resp resp, String token) {
        resp.cookie("_token", token, "HttpOnly");
    }

    public static String cookiePath() {
        String ctxPath = ReqInfo.get().contextPath();
        return U.notEmpty((String)ctxPath) ? ctxPath : "/";
    }

    public static void clearUserData(Req req) {
        if (Ctxs.hasContext()) {
            Ctxs.required().setUser(UserInfo.ANONYMOUS);
        }
        if (req.hasToken()) {
            Map<String, Serializable> token = req.token();
            token.remove("_user");
            token.remove("_scope");
        }
    }

    public static TokenAuthData getAuth(Req req) {
        TokenAuthData auth;
        TokenAuthData tokenAuthData = auth = req.hasToken() ? Tokens.getAuth(req.token()) : null;
        if (auth != null && U.notEmpty((Collection)auth.scope) && !auth.scope.contains(req.verb() + " " + req.path())) {
            auth = null;
        }
        return auth;
    }

    public static String inferRealIpAddress(Req req) {
        return req.clientIpAddress();
    }

    public static MaybeReq noReq() {
        return NO_REQ;
    }

    public static MaybeReq maybe(Req req) {
        return req != null ? (MaybeReq)((Object)req) : HttpUtils.noReq();
    }

    public static MaybeReq req(Req req) {
        U.notNull((Object)req, (String)"HTTP request", (Object[])new Object[0]);
        return (MaybeReq)((Object)req);
    }

    public static int findBodyStart(byte[] response) {
        BufRanges lines;
        Bytes bytes = BytesUtil.from((byte[])response);
        int pos = BytesUtil.parseLines((Bytes)bytes, (BufRanges)(lines = new BufRanges(100)), (int)0, (int)bytes.limit());
        U.must((pos > 0 ? 1 : 0) != 0, (String)"Invalid HTTP response!");
        return pos;
    }

    private static boolean ignoreResponseHeaderInProxy(String name) {
        return name.equalsIgnoreCase("Transfer-encoding") || name.equalsIgnoreCase("Content-length") || name.equalsIgnoreCase("Connection") || name.equalsIgnoreCase("Date") || name.equalsIgnoreCase("Server");
    }

    public static void proxyResponseHeaders(Map<String, String> respHeaders, SimpleHttpResp resp) {
        for (Map.Entry<String, String> hdr : respHeaders.entrySet()) {
            String name = hdr.getKey();
            String value = hdr.getValue();
            if (name.equalsIgnoreCase("Content-type")) {
                resp.contentType = MediaType.of((String)value);
                continue;
            }
            if (name.equalsIgnoreCase("Set-Cookie")) {
                String[] parts = value.split("=", 2);
                U.must((parts.length == 2 ? 1 : 0) != 0, (String)"Invalid value of the Set-Cookie header!");
                if (resp.cookies == null) {
                    resp.cookies = U.map();
                }
                resp.cookies.put(parts[0], parts[1]);
                continue;
            }
            if (HttpUtils.ignoreResponseHeaderInProxy(name)) continue;
            if (resp.headers == null) {
                resp.headers = U.map();
            }
            resp.headers.put(name, value);
        }
    }

    public static MediaType getDefaultContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    public static void validateViewName(String view) {
        U.must((!view.startsWith("/") ? 1 : 0) != 0, (String)"Invalid view name: '%s'", (Object)view);
    }

    public static Map<String, WebData> webParams(Req req) {
        Map webParams = U.map();
        for (Map.Entry<String, String> e : req.params().entrySet()) {
            webParams.put(e.getKey(), new WebData(e.getValue()));
        }
        return webParams;
    }

    public static boolean isSpecialResult(Object result) {
        return result == null || result instanceof HttpStatus || result instanceof Req || result instanceof Resp;
    }
}

